/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.scripted;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import noppes.npcs.NoppesStringUtils;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.controllers.PlayerData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerDialogData;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.scripted.ScriptItemStack;
import noppes.npcs.scripted.ScriptLivingBase;

public class ScriptPlayer
extends ScriptLivingBase {
    protected EntityPlayerMP player;

    public ScriptPlayer(EntityPlayerMP player) {
        super((EntityLivingBase)player);
        this.player = player;
    }

    public String getDisplayName() {
        return this.player.getDisplayName();
    }

    public String getName() {
        return this.player.func_70005_c_();
    }

    @Override
    public void setPosition(double x, double y, double z) {
        NoppesUtilPlayer.teleportPlayer(this.player, x, y, z, this.player.field_71093_bK);
    }

    public boolean hasFinishedQuest(int id) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player).questData;
        return data.finishedQuests.containsKey(id);
    }

    public boolean hasActiveQuest(int id) {
        PlayerQuestData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player).questData;
        return data.activeQuests.containsKey(id);
    }

    public boolean hasReadDialog(int id) {
        PlayerDialogData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player).dialogData;
        return data.dialogsRead.contains(id);
    }

    @Override
    public int getType() {
        return 1;
    }

    public void addFactionPoints(int faction, int points) {
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        data.factionData.increasePoints(faction, points);
    }

    public int getFactionPoints(int faction) {
        PlayerData data = PlayerDataController.instance.getPlayerData((EntityPlayer)this.player);
        return data.factionData.getFactionPoints(faction);
    }

    public void sendMessage(String message) {
        this.player.func_145747_a((IChatComponent)new ChatComponentTranslation(NoppesStringUtils.formatText(message, this.player.getDisplayName()), new Object[0]));
    }

    public int getMode() {
        return this.player.field_71134_c.func_73081_b().func_77148_a();
    }

    public ScriptItemStack getHeldItem() {
        ItemStack item = this.player.field_71071_by.func_70448_g();
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    public ScriptItemStack getArmor(int slot) {
        ItemStack item = this.player.field_71071_by.func_70440_f(slot);
        if (item == null) {
            return null;
        }
        return new ScriptItemStack(item);
    }

    public int inventoryItemCount(ScriptItemStack item) {
        int i = 0;
        for (ItemStack is : this.player.field_71071_by.field_70462_a) {
            if (is == null || !is.func_77969_a(item.item)) continue;
            i += is.field_77994_a;
        }
        return i;
    }

    public boolean removeItem(ScriptItemStack item, int amount) {
        int count = this.inventoryItemCount(item);
        if (count > amount) {
            return false;
        }
        if (count == amount) {
            this.removeAllItems(item);
        } else {
            for (int i = 0; i < this.player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack is = this.player.field_71071_by.field_70462_a[i];
                if (is == null || !is.func_77969_a(item.item)) continue;
                if (amount > is.field_77994_a) {
                    this.player.field_71071_by.field_70462_a[i] = null;
                    amount -= is.field_77994_a;
                    continue;
                }
                is.func_77979_a(amount);
                break;
            }
        }
        return true;
    }

    public void removeAllItems(ScriptItemStack item) {
        for (int i = 0; i < this.player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack is = this.player.field_71071_by.field_70462_a[i];
            if (is == null || !is.func_77969_a(item.item)) continue;
            this.player.field_71071_by.field_70462_a[i] = null;
        }
    }

    public boolean hasAchievement(String achievement) {
        StatBase statbase = StatList.func_151177_a((String)achievement);
        if (statbase == null || !(statbase instanceof Achievement)) {
            return false;
        }
        return this.player.func_147099_x().func_77443_a((Achievement)statbase);
    }
}

