/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;
import noppes.npcs.controllers.PlayerBankData;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerDialogData;
import noppes.npcs.controllers.PlayerFactionData;
import noppes.npcs.controllers.PlayerItemGiverData;
import noppes.npcs.controllers.PlayerMailData;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.PlayerTransportData;

public class PlayerData
implements IExtendedEntityProperties {
    public PlayerDialogData dialogData = new PlayerDialogData();
    public PlayerBankData bankData = new PlayerBankData();
    public PlayerQuestData questData = new PlayerQuestData();
    public PlayerTransportData transportData = new PlayerTransportData();
    public PlayerFactionData factionData = new PlayerFactionData();
    public PlayerItemGiverData itemgiverData = new PlayerItemGiverData();
    public PlayerMailData mailData = new PlayerMailData();
    private String playerName;

    public PlayerData(String player) {
        this.playerName = player;
        this.readNBT(PlayerDataController.instance.loadPlayerData(this.playerName));
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        this.dialogData.saveNBTData(compound);
        this.bankData.saveNBTData(compound);
        this.questData.saveNBTData(compound);
        this.transportData.saveNBTData(compound);
        this.factionData.saveNBTData(compound);
        this.itemgiverData.saveNBTData(compound);
        this.mailData.saveNBTData(compound);
        return compound;
    }

    public void saveNBTData(NBTTagCompound compound) {
        PlayerDataController.instance.savePlayerData(this.playerName, this.getNBT());
    }

    public void loadNBTData(NBTTagCompound bla) {
    }

    public void init(Entity entity, World world) {
    }

    public void readNBT(NBTTagCompound compound) {
        this.dialogData.loadNBTData(compound);
        this.bankData.loadNBTData(compound);
        this.questData.loadNBTData(compound);
        this.transportData.loadNBTData(compound);
        this.factionData.loadNBTData(compound);
        this.itemgiverData.loadNBTData(compound);
        this.mailData.loadNBTData(compound);
    }
}

