/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import toughasnails.api.ITANBlock;
import toughasnails.api.TANBlocks;
import toughasnails.api.season.SeasonHelper;
import toughasnails.item.ItemTANBlock;
import toughasnails.tileentity.TileEntitySeasonSensor;

public class BlockSeasonSensor
extends BlockContainer
implements ITANBlock {
    public static final PropertyInteger POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    public static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0);
    private final DetectorType type;

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemTANBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[0];
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return new IProperty[]{POWER};
    }

    @Override
    public String getStateName(IBlockState state) {
        return this.type.func_176610_l();
    }

    public BlockSeasonSensor(DetectorType type) {
        super(Material.field_151575_d);
        this.type = type;
        this.func_149711_c(0.2f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return (Integer)blockState.func_177229_b((IProperty)POWER);
    }

    public void updatePower(World world, BlockPos pos) {
        if (world.field_73011_w.getDimension() == 0) {
            IBlockState currentState = world.func_180495_p(pos);
            int power = 0;
            int startTicks = this.type.ordinal() * 360000;
            int endTicks = (this.type.ordinal() + 1) * 360000;
            int currentTicks = SeasonHelper.getSeasonData(world).getSeasonCycleTicks();
            if (currentTicks >= startTicks && currentTicks <= endTicks) {
                float delta = (float)(currentTicks - startTicks) / 360000.0f;
                float peak = 2.0f * (-Math.abs(delta - 0.5f) + 0.5f);
                power = (int)Math.min(peak * 15.0f + 1.0f, 15.0f);
            }
            if ((Integer)currentState.func_177229_b((IProperty)POWER) != power) {
                world.func_180501_a(pos, currentState.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(power)), 3);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_175142_cm()) {
            if (world.field_72995_K) {
                return true;
            }
            Block nextBlock = TANBlocks.season_sensors[(this.type.ordinal() + 1) % DetectorType.values().length];
            world.func_180501_a(pos, nextBlock.func_176223_P().func_177226_a((IProperty)POWER, state.func_177229_b((IProperty)POWER)), 4);
            ((BlockSeasonSensor)nextBlock).updatePower(world, pos);
            return true;
        }
        return super.func_180639_a(world, pos, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)TANBlocks.season_sensors[0]);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntitySeasonSensor();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER});
    }

    public static enum DetectorType implements IStringSerializable
    {
        SPRING,
        SUMMER,
        AUTUMN,
        WINTER;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

