/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemBlock;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.api.ITANBlock;
import toughasnails.item.ItemTANBlock;

public class BlockTANGas
extends Block
implements ITANBlock {
    public static final PropertyEnum VARIANT = PropertyEnum.func_177709_a((String)"variant", GasType.class);

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Override
    public Class<? extends ItemBlock> getItemClass() {
        return ItemTANBlock.class;
    }

    @Override
    public IProperty[] getPresetProperties() {
        return new IProperty[]{VARIANT};
    }

    @Override
    public IProperty[] getNonRenderingProperties() {
        return null;
    }

    @Override
    public String getStateName(IBlockState state) {
        return ((GasType)((Object)state.func_177229_b((IProperty)VARIANT))).func_176610_l() + "_block";
    }

    public BlockTANGas() {
        super(Material.field_151579_a);
        this.func_149711_c(0.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)GasType.BLACKDAMP)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)GasType.values()[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((GasType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World worldIn, BlockPos pos, Random rand) {
        super.func_180655_c(state, worldIn, pos, rand);
        switch ((GasType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case WHITEDAMP: {
                if (rand.nextInt(12) == 0) {
                    worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.75f - rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.9f), (double)((float)pos.func_177952_p() + 0.75f - rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
                }
            }
            case STINKDAMP: {
                if (rand.nextInt(12) == 0) {
                    worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.75f - rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.9f), (double)((float)pos.func_177952_p() + 0.75f - rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
                }
            }
            case FIREDAMP: {
                if (rand.nextInt(12) != 0) break;
                worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.75f - rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.9f), (double)((float)pos.func_177952_p() + 0.75f - rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
            }
        }
        if (rand.nextInt(12) == 0) {
            worldIn.func_175688_a(EnumParticleTypes.SPELL_MOB, (double)((float)pos.func_177958_n() + 0.75f - rand.nextFloat() / 2.0f), (double)((float)pos.func_177956_o() + 0.9f), (double)((float)pos.func_177952_p() + 0.75f - rand.nextFloat() / 2.0f), 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)});
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, World world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        switch ((GasType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case STINKDAMP: 
            case FIREDAMP: {
                return 2000;
            }
        }
        return 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        IBlockState state = world.func_180495_p(pos);
        switch ((GasType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case STINKDAMP: 
            case FIREDAMP: {
                return 2000;
            }
        }
        return 0;
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        IBlockState state = worldIn.func_180495_p(pos);
        switch ((GasType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case STINKDAMP: {
                if (worldIn.field_72995_K) break;
                this.explode(worldIn, pos, state);
                break;
            }
        }
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        switch ((GasType)((Object)state.func_177229_b((IProperty)VARIANT))) {
            case WHITEDAMP: {
                if (!(entityIn instanceof EntityLivingBase)) break;
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76437_t, 500));
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76438_s, 500));
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76419_f, 500));
                ((EntityLivingBase)entityIn).func_70690_d(new PotionEffect(MobEffects.field_76421_d, 500));
                break;
            }
            case STINKDAMP: {
                EntityArrow entityarrow;
                if (worldIn.field_72995_K || !(entityIn instanceof EntityArrow) || !(entityarrow = (EntityArrow)entityIn).func_70027_ad()) break;
                this.explode(worldIn, pos, state);
                break;
            }
        }
    }

    public void explode(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            EntityFallingBlock explosion = new EntityFallingBlock(worldIn, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), state);
            worldIn.func_72838_d((Entity)explosion);
            float f = 2.0f;
            worldIn.func_72876_a((Entity)explosion, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), f, true);
            worldIn.func_175698_g(pos);
        }
    }

    public static enum GasType implements IStringSerializable
    {
        BLACKDAMP,
        WHITEDAMP,
        FIREDAMP,
        STINKDAMP;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public String toString() {
            return this.func_176610_l();
        }
    }
}

