/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.config;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.config.ISyncedOption;
import toughasnails.core.ToughAsNails;
import toughasnails.handler.PacketHandler;
import toughasnails.network.message.MessageSyncConfigs;

public class SyncedConfigHandler {
    public static Map<String, SyncedConfigEntry> optionsToSync = Maps.newHashMap();

    public static void addOption(ISyncedOption option, String defaultValue) {
        optionsToSync.put(option.getOptionName(), new SyncedConfigEntry(defaultValue));
    }

    public static boolean getBooleanValue(ISyncedOption option) {
        return Boolean.valueOf(SyncedConfigHandler.optionsToSync.get((Object)option.getOptionName()).value);
    }

    public static void restoreDefaults() {
        for (SyncedConfigEntry entry : optionsToSync.values()) {
            entry.value = entry.defaultValue;
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            NBTTagCompound nbtOptions = new NBTTagCompound();
            for (Map.Entry<String, SyncedConfigEntry> entry : optionsToSync.entrySet()) {
                nbtOptions.func_74778_a(entry.getKey(), entry.getValue().value);
            }
            MessageSyncConfigs message = new MessageSyncConfigs(nbtOptions);
            PacketHandler.instance.sendTo((IMessage)message, (EntityPlayerMP)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.getWorld().field_72995_K && !Minecraft.func_71410_x().func_147114_u().func_147298_b().func_150724_d()) {
            SyncedConfigHandler.restoreDefaults();
            ToughAsNails.logger.info("TAN configuration restored to local values");
        }
    }

    public static class SyncedConfigEntry {
        public String value;
        public final String defaultValue;

        public SyncedConfigEntry(String defaultValue) {
            this.defaultValue = defaultValue;
            this.value = defaultValue;
        }
    }
}

