/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.health;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import toughasnails.api.HealthHelper;
import toughasnails.config.GameplayOption;
import toughasnails.config.SyncedConfigHandler;

public class MaxHealthHandler {
    @SubscribeEvent
    public void onPlayerLogin(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        World world = player.field_70170_p;
        if (!world.field_72995_K) {
            this.updateStartingHealthModifier(world.func_175659_aa(), player);
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        IAttributeInstance oldMaxHealthInstance = event.getOriginal().func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier modifier = oldMaxHealthInstance.func_111127_a(HealthHelper.LIFEBLOOD_HEALTH_MODIFIER_ID);
        if (SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_LOWERED_STARTING_HEALTH) && modifier != null) {
            HashMultimap multimap = HashMultimap.create();
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)modifier);
            event.getEntityPlayer().func_110140_aT().func_111147_b((Multimap)multimap);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        IntegratedServer integratedServer = minecraft.func_71401_C();
        if (SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_LOWERED_STARTING_HEALTH) && event.phase == TickEvent.Phase.END && integratedServer != null) {
            boolean gamePaused;
            boolean bl = gamePaused = Minecraft.func_71410_x().func_147114_u() != null && minecraft.func_147113_T();
            if (!gamePaused && minecraft.field_71441_e != null) {
                WorldInfo serverWorldInfo = integratedServer.field_71305_c[0].func_72912_H();
                WorldInfo localWorldInfo = minecraft.field_71441_e.func_72912_H();
                if (localWorldInfo.func_176130_y() != serverWorldInfo.func_176130_y()) {
                    List players = integratedServer.func_184103_al().func_181057_v();
                    for (EntityPlayerMP player : players) {
                        this.updateStartingHealthModifier(localWorldInfo.func_176130_y(), (EntityPlayer)player);
                    }
                }
            }
        }
    }

    private void updateStartingHealthModifier(EnumDifficulty difficulty, EntityPlayer player) {
        double difficultyHealthDecrement;
        IAttributeInstance maxHealthInstance = player.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111267_a);
        AttributeModifier modifier = maxHealthInstance.func_111127_a(HealthHelper.STARTING_HEALTH_MODIFIER_ID);
        if (!SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_LOWERED_STARTING_HEALTH)) {
            if (modifier != null) {
                maxHealthInstance.func_188479_b(HealthHelper.STARTING_HEALTH_MODIFIER_ID);
            }
            return;
        }
        switch (difficulty) {
            case EASY: {
                difficultyHealthDecrement = -6.0;
                break;
            }
            case NORMAL: {
                difficultyHealthDecrement = -10.0;
                break;
            }
            case HARD: {
                difficultyHealthDecrement = -14.0;
                break;
            }
            default: {
                difficultyHealthDecrement = 0.0;
            }
        }
        double lifebloodHearts = HealthHelper.getLifebloodHearts(player) * 2;
        double overallHealthDecrement = difficultyHealthDecrement + lifebloodHearts;
        if (overallHealthDecrement > 0.0) {
            difficultyHealthDecrement -= overallHealthDecrement;
        }
        if (modifier == null || modifier.func_111164_d() != difficultyHealthDecrement) {
            HashMultimap multimap = HashMultimap.create();
            modifier = new AttributeModifier(HealthHelper.STARTING_HEALTH_MODIFIER_ID, "Starting Health Modifier", difficultyHealthDecrement, 0);
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)modifier);
            player.func_110140_aT().func_111147_b((Multimap)multimap);
            if (player.func_110143_aJ() > player.func_110138_aP()) {
                player.func_70606_j(player.func_110138_aP());
            }
        }
    }
}

