/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.season;

import java.util.Iterator;
import net.minecraft.block.BlockIce;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import toughasnails.api.season.Season;
import toughasnails.api.season.SeasonHelper;
import toughasnails.config.GameplayOption;
import toughasnails.config.SyncedConfigHandler;

public class RandomUpdateHandler {
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side == Side.SERVER) {
            WorldServer world = (WorldServer)event.world;
            Season season = SeasonHelper.getSeasonData((World)world).getSubSeason().getSeason();
            Season.SubSeason subSeason = SeasonHelper.getSeasonData((World)world).getSubSeason();
            if (!SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_SEASONS)) {
                season = Season.SUMMER;
                subSeason = Season.SubSeason.MID_SUMMER;
            }
            if (subSeason != Season.SubSeason.EARLY_WINTER && subSeason != Season.SubSeason.MID_WINTER && subSeason != Season.SubSeason.LATE_WINTER) {
                Iterator iterator = world.getPersistentChunkIterable(world.func_184164_w().func_187300_b());
                while (iterator.hasNext()) {
                    int rand;
                    Chunk chunk = (Chunk)iterator.next();
                    int x = chunk.field_76635_g * 16;
                    int z = chunk.field_76647_h * 16;
                    switch (subSeason) {
                        case EARLY_SPRING: {
                            rand = 16;
                            break;
                        }
                        case MID_SPRING: {
                            rand = 12;
                            break;
                        }
                        case LATE_SPRING: {
                            rand = 8;
                            break;
                        }
                        default: {
                            rand = 4;
                        }
                    }
                    if (world.field_73012_v.nextInt(rand) != 0) continue;
                    world.field_73005_l = world.field_73005_l * 3 + 1013904223;
                    int randOffset = world.field_73005_l >> 2;
                    BlockPos topPos = world.func_175725_q(new BlockPos(x + (randOffset & 0xF), 0, z + (randOffset >> 8 & 0xF)));
                    BlockPos groundPos = topPos.func_177977_b();
                    if (world.func_180495_p(groundPos).func_177230_c() == Blocks.field_150432_aD && !SeasonHelper.canSnowAtTempInSeason(season, world.func_180494_b(groundPos).func_180626_a(groundPos))) {
                        ((BlockIce)Blocks.field_150432_aD).func_185679_b((World)world, groundPos);
                    }
                    if (world.func_180495_p(topPos).func_177230_c() != Blocks.field_150431_aC || SeasonHelper.canSnowAtTempInSeason(season, world.func_180494_b(topPos).func_180626_a(topPos))) continue;
                    world.func_175698_g(topPos);
                }
            }
        }
    }
}

