/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.network.message;

import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import toughasnails.config.SyncedConfigHandler;
import toughasnails.core.ToughAsNails;

public class MessageSyncConfigs
implements IMessage,
IMessageHandler<MessageSyncConfigs, IMessage> {
    public NBTTagCompound nbtOptions;

    public MessageSyncConfigs() {
    }

    public MessageSyncConfigs(NBTTagCompound nbtOptions) {
        this.nbtOptions = nbtOptions;
    }

    public void fromBytes(ByteBuf buf) {
        this.nbtOptions = ByteBufUtils.readTag((ByteBuf)buf);
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.nbtOptions);
    }

    public IMessage onMessage(MessageSyncConfigs message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            for (String key : message.nbtOptions.func_150296_c()) {
                SyncedConfigHandler.SyncedConfigEntry entry = SyncedConfigHandler.optionsToSync.get(key);
                if (entry == null) {
                    ToughAsNails.logger.error("Option " + key + " does not exist locally!");
                }
                entry.value = message.nbtOptions.func_74779_i(key);
                ToughAsNails.logger.info("TAN configuration synchronized with the server");
            }
        }
        return null;
    }
}

