/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.network.message;

import io.netty.buffer.ByteBuf;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import toughasnails.api.TANCapabilities;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureHandler;

public class MessageTemperatureClient
implements IMessage,
IMessageHandler<MessageTemperatureClient, IMessage> {
    public int temperatureTimer;
    public int changeTicks;
    public int targetTemperature;
    public Map<TemperatureDebugger.Modifier, Integer>[] modifiers = new LinkedHashMap[TemperatureDebugger.ModifierType.values().length];

    public MessageTemperatureClient() {
        for (int i = 0; i < TemperatureDebugger.ModifierType.values().length; ++i) {
            this.modifiers[i] = new LinkedHashMap<TemperatureDebugger.Modifier, Integer>();
        }
    }

    public MessageTemperatureClient(int temperatureTimer, int changeTicks, int targetTemperature, Map<TemperatureDebugger.Modifier, Integer>[] modifiers) {
        this.temperatureTimer = temperatureTimer;
        this.changeTicks = changeTicks;
        this.targetTemperature = targetTemperature;
        this.modifiers = modifiers;
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        this.temperatureTimer = packetBuffer.readInt();
        this.changeTicks = packetBuffer.readInt();
        this.targetTemperature = packetBuffer.readInt();
        for (int mapIdx = 0; mapIdx < this.modifiers.length; ++mapIdx) {
            int size = packetBuffer.readInt();
            for (int i = 0; i < size; ++i) {
                TemperatureDebugger.Modifier modifier = (TemperatureDebugger.Modifier)packetBuffer.func_179257_a(TemperatureDebugger.Modifier.class);
                int value = packetBuffer.readInt();
                this.modifiers[mapIdx].put(modifier, value);
            }
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer packetBuffer = new PacketBuffer(buf);
        packetBuffer.writeInt(this.temperatureTimer);
        packetBuffer.writeInt(this.changeTicks);
        packetBuffer.writeInt(this.targetTemperature);
        for (Map<TemperatureDebugger.Modifier, Integer> modifier : this.modifiers) {
            packetBuffer.writeInt(modifier.size());
            for (Map.Entry<TemperatureDebugger.Modifier, Integer> entry : modifier.entrySet()) {
                packetBuffer.func_179249_a((Enum)entry.getKey());
                packetBuffer.writeInt(entry.getValue().intValue());
            }
        }
    }

    public IMessage onMessage(MessageTemperatureClient message, MessageContext ctx) {
        EntityPlayerSP player;
        if (ctx.side == Side.CLIENT && (player = Minecraft.func_71410_x().field_71439_g) != null) {
            TemperatureHandler temperatureStats = (TemperatureHandler)player.getCapability(TANCapabilities.TEMPERATURE, null);
            TemperatureDebugger debugger = temperatureStats.debugger;
            debugger.temperatureTimer = message.temperatureTimer;
            debugger.changeTicks = message.changeTicks;
            debugger.targetTemperature = message.targetTemperature;
            debugger.modifiers = message.modifiers;
        }
        return null;
    }
}

