/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import toughasnails.api.TANCapabilities;
import toughasnails.api.TANPotions;
import toughasnails.api.stat.StatHandlerBase;
import toughasnails.api.stat.capability.ITemperature;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureScale;
import toughasnails.config.GameplayOption;
import toughasnails.config.SyncedConfigHandler;
import toughasnails.network.message.MessageUpdateStat;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureTrend;
import toughasnails.temperature.modifier.AltitudeModifier;
import toughasnails.temperature.modifier.ArmorModifier;
import toughasnails.temperature.modifier.BiomeModifier;
import toughasnails.temperature.modifier.ObjectProximityModifier;
import toughasnails.temperature.modifier.PlayerStateModifier;
import toughasnails.temperature.modifier.SeasonModifier;
import toughasnails.temperature.modifier.TemperatureModifier;
import toughasnails.temperature.modifier.TimeModifier;
import toughasnails.temperature.modifier.WeatherModifier;

public class TemperatureHandler
extends StatHandlerBase
implements ITemperature {
    public static final int TEMPERATURE_SCALE_MIDPOINT = TemperatureScale.getScaleTotal() / 2;
    public static final int BASE_TEMPERATURE_CHANGE_TICKS = 1200;
    private int temperatureLevel;
    private int prevTemperatureLevel;
    private int temperatureTimer;
    private TemperatureModifier altitudeModifier;
    private TemperatureModifier armorModifier;
    private TemperatureModifier biomeModifier;
    private TemperatureModifier playerStateModifier;
    private TemperatureModifier objectProximityModifier;
    private TemperatureModifier weatherModifier;
    private TemperatureModifier timeModifier;
    private TemperatureModifier seasonModifier;
    private Map<String, TemperatureModifier.ExternalModifier> externalModifiers;
    public final TemperatureDebugger debugger = new TemperatureDebugger();

    public TemperatureHandler() {
        this.prevTemperatureLevel = this.temperatureLevel = TemperatureScale.getScaleTotal() / 2;
        this.altitudeModifier = new AltitudeModifier(this.debugger);
        this.armorModifier = new ArmorModifier(this.debugger);
        this.biomeModifier = new BiomeModifier(this.debugger);
        this.playerStateModifier = new PlayerStateModifier(this.debugger);
        this.objectProximityModifier = new ObjectProximityModifier(this.debugger);
        this.weatherModifier = new WeatherModifier(this.debugger);
        this.timeModifier = new TimeModifier(this.debugger);
        this.seasonModifier = new SeasonModifier(this.debugger);
        this.externalModifiers = Maps.newHashMap();
    }

    @Override
    public void update(EntityPlayer player, World world, TickEvent.Phase phase) {
        if (phase == TickEvent.Phase.END && !world.field_72995_K) {
            int newTempChangeTicks = 1200;
            TemperatureTrend trend = this.debugger.targetTemperature == this.temperatureLevel ? TemperatureTrend.STILL : (this.debugger.targetTemperature > this.temperatureLevel ? TemperatureTrend.INCREASING : TemperatureTrend.DECREASING);
            newTempChangeTicks = this.altitudeModifier.modifyChangeRate(world, player, newTempChangeTicks, trend);
            newTempChangeTicks = this.armorModifier.modifyChangeRate(world, player, newTempChangeTicks, trend);
            newTempChangeTicks = this.biomeModifier.modifyChangeRate(world, player, newTempChangeTicks, trend);
            newTempChangeTicks = this.playerStateModifier.modifyChangeRate(world, player, newTempChangeTicks, trend);
            newTempChangeTicks = this.objectProximityModifier.modifyChangeRate(world, player, newTempChangeTicks, trend);
            newTempChangeTicks = this.weatherModifier.modifyChangeRate(world, player, newTempChangeTicks, trend);
            newTempChangeTicks = this.timeModifier.modifyChangeRate(world, player, newTempChangeTicks, trend);
            Iterator<TemperatureModifier.ExternalModifier> iterator = this.externalModifiers.values().iterator();
            this.debugger.start(TemperatureDebugger.Modifier.CLIMATISATION_RATE, newTempChangeTicks);
            while (iterator.hasNext()) {
                TemperatureModifier.ExternalModifier modifier = iterator.next();
                if (this.temperatureTimer > modifier.getEndTime()) {
                    iterator.remove();
                    continue;
                }
                if (!SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_TEMPERATURE)) continue;
                newTempChangeTicks += modifier.getRate();
            }
            this.debugger.end(newTempChangeTicks);
            newTempChangeTicks = Math.max(20, newTempChangeTicks);
            boolean incrementTemperature = ++this.temperatureTimer >= newTempChangeTicks;
            boolean updateClient = ++this.debugger.debugTimer % 5 == 0;
            this.debugger.temperatureTimer = this.temperatureTimer;
            this.debugger.changeTicks = newTempChangeTicks;
            if (incrementTemperature && SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_TEMPERATURE)) {
                for (TemperatureModifier.ExternalModifier modifier : this.externalModifiers.values()) {
                    modifier.setEndTime(modifier.getEndTime() - this.temperatureTimer);
                }
            }
            if ((incrementTemperature || updateClient) && SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_TEMPERATURE)) {
                this.debugger.start(TemperatureDebugger.Modifier.EQUILIBRIUM_TARGET, 0);
                this.debugger.end(TemperatureScale.getScaleTotal() / 2);
                Temperature targetTemperature = this.biomeModifier.modifyTarget(world, player, new Temperature(TEMPERATURE_SCALE_MIDPOINT));
                targetTemperature = this.altitudeModifier.modifyTarget(world, player, targetTemperature);
                targetTemperature = this.armorModifier.modifyTarget(world, player, targetTemperature);
                targetTemperature = this.playerStateModifier.modifyTarget(world, player, targetTemperature);
                targetTemperature = this.objectProximityModifier.modifyTarget(world, player, targetTemperature);
                targetTemperature = this.weatherModifier.modifyTarget(world, player, targetTemperature);
                targetTemperature = this.timeModifier.modifyTarget(world, player, targetTemperature);
                targetTemperature = this.seasonModifier.modifyTarget(world, player, targetTemperature);
                this.debugger.start(TemperatureDebugger.Modifier.CLIMATISATION_TARGET, targetTemperature.getRawValue());
                for (TemperatureModifier.ExternalModifier modifier : this.externalModifiers.values()) {
                    targetTemperature = new Temperature(targetTemperature.getRawValue() + modifier.getAmount());
                }
                this.debugger.end(targetTemperature.getRawValue());
                this.debugger.targetTemperature = targetTemperature.getRawValue();
                targetTemperature = new Temperature(MathHelper.func_76125_a((int)targetTemperature.getRawValue(), (int)0, (int)TemperatureScale.getScaleTotal()));
                if (incrementTemperature) {
                    this.addTemperature(new Temperature((int)Math.signum(targetTemperature.getRawValue() - this.temperatureLevel)));
                    this.temperatureTimer = 0;
                }
            }
            this.addPotionEffects(player);
            if (updateClient) {
                this.debugger.finalize((EntityPlayerMP)player);
            }
        }
    }

    private void addPotionEffects(EntityPlayer player) {
        TemperatureScale.TemperatureRange range = TemperatureScale.getTemperatureRange(this.temperatureLevel);
        float multiplier = 1.0f;
        float extremityDelta = 0.5f;
        int hypoRangeSize = (int)((float)TemperatureScale.TemperatureRange.ICY.getRangeSize() * extremityDelta);
        int hypoRangeStart = hypoRangeSize - 1;
        int hyperRangeSize = (int)((float)TemperatureScale.TemperatureRange.HOT.getRangeSize() * extremityDelta);
        int hyperRangeStart = TemperatureScale.getScaleTotal() + 1 - hyperRangeSize;
        if (!player.field_71075_bZ.field_75098_d && SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_TEMPERATURE)) {
            if (!(this.temperatureLevel > hypoRangeStart || player.func_70644_a(TANPotions.cold_resistance) || this.temperatureLevel >= this.prevTemperatureLevel && player.func_70644_a(TANPotions.hypothermia))) {
                multiplier = 1.0f - (float)(this.temperatureLevel + 1) / (float)hypoRangeSize;
                player.func_184589_d(TANPotions.hypothermia);
                player.func_70690_d(new PotionEffect(TANPotions.hypothermia, (int)(1800.0f * multiplier) + 600, (int)(3.0f * multiplier + extremityDelta)));
            } else if (!(this.temperatureLevel < hyperRangeStart || player.func_70644_a(TANPotions.heat_resistance) || this.temperatureLevel <= this.prevTemperatureLevel && player.func_70644_a(TANPotions.hyperthermia))) {
                multiplier = (float)(this.temperatureLevel - hyperRangeStart) / (float)hyperRangeSize;
                player.func_184589_d(TANPotions.hyperthermia);
                player.func_70690_d(new PotionEffect(TANPotions.hyperthermia, (int)(1800.0f * multiplier) + 600, (int)(3.0f * multiplier)));
            }
        }
    }

    @Override
    public boolean hasChanged() {
        return this.prevTemperatureLevel != this.temperatureLevel;
    }

    @Override
    public void onSendClientUpdate() {
        this.prevTemperatureLevel = this.temperatureLevel;
    }

    @Override
    public IMessage createUpdateMessage() {
        NBTTagCompound data = (NBTTagCompound)TANCapabilities.TEMPERATURE.getStorage().writeNBT(TANCapabilities.TEMPERATURE, (Object)this, null);
        return new MessageUpdateStat(TANCapabilities.TEMPERATURE, data);
    }

    @Override
    public void setChangeTime(int ticks) {
        this.temperatureTimer = ticks;
    }

    @Override
    public int getChangeTime() {
        return this.temperatureTimer;
    }

    @Override
    public void setTemperature(Temperature temperature) {
        this.temperatureLevel = temperature.getRawValue();
    }

    @Override
    public void addTemperature(Temperature difference) {
        this.temperatureLevel = Math.max(Math.min(TemperatureScale.getScaleTotal(), this.temperatureLevel + difference.getRawValue()), 0);
    }

    @Override
    public void applyModifier(String name, int amount, int rate, int duration) {
        if (this.externalModifiers.containsKey(name)) {
            TemperatureModifier.ExternalModifier modifier = this.externalModifiers.get(name);
            modifier.setEndTime(this.temperatureTimer + duration);
        } else {
            TemperatureModifier.ExternalModifier modifier = new TemperatureModifier.ExternalModifier(name, amount, rate, this.temperatureTimer + duration);
            this.externalModifiers.put(name, modifier);
        }
    }

    @Override
    public boolean hasModifier(String name) {
        return this.externalModifiers.containsKey(name);
    }

    @Override
    public ImmutableMap<String, TemperatureModifier.ExternalModifier> getExternalModifiers() {
        return ImmutableMap.copyOf(this.externalModifiers);
    }

    @Override
    public void setExternalModifiers(Map<String, TemperatureModifier.ExternalModifier> externalModifiers) {
        this.externalModifiers = externalModifiers;
    }

    @Override
    public Temperature getTemperature() {
        return new Temperature(this.temperatureLevel);
    }
}

