/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import toughasnails.api.TANBlocks;
import toughasnails.api.temperature.Temperature;
import toughasnails.block.BlockTANCampfire;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureTrend;
import toughasnails.temperature.modifier.TemperatureModifier;

public class ObjectProximityModifier
extends TemperatureModifier {
    public ObjectProximityModifier(TemperatureDebugger debugger) {
        super(debugger);
    }

    @Override
    public int modifyChangeRate(World world, EntityPlayer player, int changeRate, TemperatureTrend trend) {
        int newChangeRate = changeRate;
        BlockPos playerPos = player.func_180425_c();
        int tempSourceBlocks = 0;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos pos = playerPos.func_177982_a(x, y - 1, z);
                    IBlockState state = world.func_180495_p(pos);
                    if (ObjectProximityModifier.getBlockTemperature(player, state) == 0.0f) continue;
                    ++tempSourceBlocks;
                }
            }
        }
        this.debugger.start(TemperatureDebugger.Modifier.NEARBY_BLOCKS_RATE, newChangeRate);
        this.debugger.end(newChangeRate -= tempSourceBlocks * 20);
        return newChangeRate;
    }

    @Override
    public Temperature modifyTarget(World world, EntityPlayer player, Temperature temperature) {
        int temperatureLevel;
        int newTemperatureLevel = temperatureLevel = temperature.getRawValue();
        BlockPos playerPos = player.func_180425_c();
        float blockTemperatureModifier = 0.0f;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    BlockPos pos = playerPos.func_177982_a(x, y - 1, z);
                    IBlockState state = world.func_180495_p(pos);
                    blockTemperatureModifier += ObjectProximityModifier.getBlockTemperature(player, state);
                }
            }
        }
        this.debugger.start(TemperatureDebugger.Modifier.NEARBY_BLOCKS_TARGET, newTemperatureLevel);
        newTemperatureLevel = (int)((float)newTemperatureLevel + blockTemperatureModifier);
        this.debugger.end(newTemperatureLevel);
        return new Temperature(newTemperatureLevel);
    }

    public static float getBlockTemperature(EntityPlayer player, IBlockState state) {
        World world = player.field_70170_p;
        Material material = state.func_185904_a();
        Biome biome = world.func_180494_b(player.func_180425_c());
        if (state.func_177230_c() == TANBlocks.campfire) {
            if (((Boolean)state.func_177229_b((IProperty)BlockTANCampfire.BURNING)).booleanValue()) {
                return 12.0f;
            }
            return 0.0f;
        }
        if (material == Material.field_151581_o) {
            return 1.0f;
        }
        if (material == Material.field_151587_i) {
            return 1.5f;
        }
        return 0.0f;
    }
}

