/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import toughasnails.api.season.Season;
import toughasnails.api.season.SeasonHelper;
import toughasnails.api.temperature.Temperature;
import toughasnails.config.GameplayOption;
import toughasnails.config.SyncedConfigHandler;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureTrend;
import toughasnails.temperature.modifier.TemperatureModifier;

public class SeasonModifier
extends TemperatureModifier {
    public SeasonModifier(TemperatureDebugger debugger) {
        super(debugger);
    }

    @Override
    public int modifyChangeRate(World world, EntityPlayer player, int changeRate, TemperatureTrend trend) {
        return changeRate;
    }

    @Override
    public Temperature modifyTarget(World world, EntityPlayer player, Temperature temperature) {
        int temperatureLevel = temperature.getRawValue();
        Season.SubSeason season = SeasonHelper.getSeasonData(world).getSubSeason();
        if (!SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_SEASONS)) {
            season = Season.SubSeason.MID_SUMMER;
        }
        this.debugger.start(TemperatureDebugger.Modifier.SEASON_TARGET, temperatureLevel);
        if (world.field_73011_w.func_76569_d()) {
            switch (season) {
                case MID_WINTER: 
                case LATE_WINTER: {
                    temperatureLevel -= 6;
                    break;
                }
                case EARLY_SPRING: 
                case EARLY_WINTER: {
                    temperatureLevel -= 4;
                    break;
                }
                case MID_SPRING: 
                case LATE_AUTUMN: {
                    temperatureLevel -= 2;
                    break;
                }
                case MID_SUMMER: 
                case EARLY_AUTUMN: {
                    temperatureLevel += 2;
                    break;
                }
                case LATE_SUMMER: {
                    temperatureLevel += 4;
                    break;
                }
            }
        }
        this.debugger.end(temperatureLevel);
        return new Temperature(temperatureLevel);
    }
}

