/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.api.stat;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import toughasnails.api.stat.IPlayerStat;
import toughasnails.api.stat.StatHandlerBase;
import toughasnails.api.stat.capability.CapabilityProvider;

public class PlayerStatRegistry {
    private static HashMap<String, Class<? extends StatHandlerBase>> playerStats = Maps.newHashMap();
    private static HashMap<String, Capability<? extends IPlayerStat>> statCapabilities = Maps.newHashMap();

    public static <T> void addStat(Class<T> capabilityClass, Capability.IStorage<T> storage, Class<? extends StatHandlerBase> implementationClass) {
        String identifier = capabilityClass.getName().intern();
        if (identifier == null) {
            throw new RuntimeException("Stat identifier cannot be null!");
        }
        if (playerStats.containsKey(identifier)) {
            throw new RuntimeException("Stat with identifier " + identifier + " already exists!");
        }
        try {
            CapabilityManager.INSTANCE.register(capabilityClass, storage, implementationClass);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Player stat must implement capability class!");
        }
        playerStats.put(identifier, implementationClass);
    }

    public static void registerCapability(Capability<? extends IPlayerStat> capability) {
        statCapabilities.put(capability.getName(), capability);
    }

    public static CapabilityProvider<?> createCapabilityProvider(String identifier) {
        return new CapabilityProvider<IPlayerStat>(statCapabilities.get(identifier));
    }

    public static Capability<?> getCapability(String identifier) {
        return statCapabilities.get(identifier);
    }

    public static ImmutableMap<String, Capability<? extends IPlayerStat>> getCapabilityMap() {
        return ImmutableMap.copyOf(statCapabilities);
    }
}

