/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.handler.health;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import toughasnails.api.HealthHelper;
import toughasnails.config.GameplayOption;
import toughasnails.config.SyncedConfigHandler;
import toughasnails.util.RenderUtils;

public class HealthOverlayHandler {
    public static final ResourceLocation OVERLAY = new ResourceLocation("toughasnails:textures/gui/overlay.png");
    private final Random random = new Random();
    private final Minecraft minecraft = Minecraft.func_71410_x();

    @SubscribeEvent
    public void onPostRenderOverlay(RenderGameOverlayEvent.Pre event) {
        ScaledResolution resolution = event.getResolution();
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (event.getType() == RenderGameOverlayEvent.ElementType.HEALTH && SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_LOWERED_STARTING_HEALTH)) {
            this.minecraft.func_110434_K().func_110577_a(OVERLAY);
            if (this.minecraft.field_71442_b.func_78763_f()) {
                this.drawInactiveHearts(width, height, HealthHelper.getInactiveHearts((EntityPlayer)player));
            }
        }
    }

    private void drawInactiveHearts(int width, int height, int inactiveHearts) {
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        int left = width / 2 - 91;
        int top = height - 39;
        for (int i = 0; i < inactiveHearts; ++i) {
            int activeOffset = 8 * (10 - inactiveHearts);
            int startX = left + i * 8 + activeOffset;
            int startY = top;
            RenderUtils.drawTexturedModalRect(startX, startY, 0, 43, 9, 9);
        }
        this.minecraft.func_110434_K().func_110577_a(Gui.field_110324_m);
        GlStateManager.func_179084_k();
        GlStateManager.func_179126_j();
    }
}

