/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.season;

import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import toughasnails.api.TANBlocks;
import toughasnails.api.season.IDecayableCrop;
import toughasnails.api.season.Season;
import toughasnails.api.season.SeasonHelper;
import toughasnails.api.temperature.Temperature;
import toughasnails.api.temperature.TemperatureHelper;
import toughasnails.config.GameplayOption;
import toughasnails.config.SyncedConfigHandler;
import toughasnails.handler.season.SeasonHandler;
import toughasnails.season.SeasonTime;

public class SeasonASMHelper {
    public static boolean canSnowAtInSeason(World world, BlockPos pos, boolean checkLight, Season season) {
        Biome biome = world.func_180494_b(pos);
        float temperature = biome.func_180626_a(pos);
        if (!SeasonHelper.canSnowAtTempInSeason(season, temperature)) {
            return false;
        }
        if (biome == Biomes.field_76781_i || biome == Biomes.field_76771_b || biome == Biomes.field_150575_M) {
            return false;
        }
        if (checkLight) {
            IBlockState state;
            return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && (state = world.func_180495_p(pos)).func_177230_c().isAir(state, (IBlockAccess)world, pos) && Blocks.field_150431_aC.func_176196_c(world, pos);
        }
        return true;
    }

    public static boolean canBlockFreezeInSeason(World world, BlockPos pos, boolean noWaterAdj, Season season) {
        IBlockState iblockstate;
        Block block;
        Biome Biome2 = world.func_180494_b(pos);
        float temperature = Biome2.func_180626_a(pos);
        if (!SeasonHelper.canSnowAtTempInSeason(season, temperature)) {
            return false;
        }
        if (Biome2 == Biomes.field_76781_i || Biome2 == Biomes.field_76771_b || Biome2 == Biomes.field_150575_M) {
            return false;
        }
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && ((block = (iblockstate = world.func_180495_p(pos)).func_177230_c()) == Blocks.field_150355_j || block == Blocks.field_150358_i) && (Integer)iblockstate.func_177229_b((IProperty)BlockLiquid.field_176367_b) == 0) {
            boolean flag;
            if (!noWaterAdj) {
                return true;
            }
            boolean bl = flag = world.func_175696_F(pos.func_177976_e()) && world.func_175696_F(pos.func_177974_f()) && world.func_175696_F(pos.func_177978_c()) && world.func_175696_F(pos.func_177968_d());
            if (!flag) {
                return true;
            }
        }
        return false;
    }

    public static boolean isRainingAtInSeason(World world, BlockPos pos, Season season) {
        Biome biome = world.func_180494_b(pos);
        return biome.func_76746_c() && season != Season.WINTER ? false : (world.func_175708_f(pos, false) ? false : biome.func_76738_d());
    }

    public static float getFloatTemperature(Biome biome, BlockPos pos) {
        Season season = new SeasonTime(SeasonHandler.clientSeasonCycleTicks).getSubSeason().getSeason();
        if (biome.func_185353_n() <= 0.7f && season == Season.WINTER && SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_SEASONS)) {
            return 0.0f;
        }
        return biome.func_180626_a(pos);
    }

    public static void onUpdateTick(BlockCrops block, World world, BlockPos pos) {
        Season season = SeasonHelper.getSeasonData(world).getSubSeason().getSeason();
        if (season == Season.WINTER && block instanceof IDecayableCrop && !TemperatureHelper.isPosClimatisedForTemp(world, pos, new Temperature(1)) && SyncedConfigHandler.getBooleanValue(GameplayOption.ENABLE_SEASONS)) {
            world.func_175656_a(pos, TANBlocks.dead_crops.func_176223_P());
        }
    }
}

