/*
 * Decompiled with CFR 0.152.
 */
package toughasnails.temperature.modifier;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import toughasnails.api.temperature.Temperature;
import toughasnails.temperature.TemperatureDebugger;
import toughasnails.temperature.TemperatureTrend;
import toughasnails.temperature.modifier.TemperatureModifier;

public class PlayerStateModifier
extends TemperatureModifier {
    public static final int SPRINTING_RATE_MODIFIER = 200;
    public static final int SPRINTING_TARGET_MODIFIER = 3;

    public PlayerStateModifier(TemperatureDebugger debugger) {
        super(debugger);
    }

    @Override
    public int modifyChangeRate(World world, EntityPlayer player, int changeRate, TemperatureTrend trend) {
        int newChangeRate = changeRate;
        int sprintingRateModifier = 200;
        switch (trend) {
            case INCREASING: {
                sprintingRateModifier *= -1;
                break;
            }
            case STILL: {
                sprintingRateModifier = 0;
            }
        }
        this.debugger.start(TemperatureDebugger.Modifier.SPRINTING_RATE, newChangeRate);
        if (player.func_70051_ag()) {
            newChangeRate += sprintingRateModifier;
        }
        this.debugger.end(newChangeRate);
        this.debugger.start(TemperatureDebugger.Modifier.HEALTH_RATE, newChangeRate);
        newChangeRate = (int)((double)newChangeRate - (1.0 - (double)(player.func_110143_aJ() / player.func_110138_aP())) * 200.0);
        this.debugger.end(newChangeRate);
        return newChangeRate;
    }

    @Override
    public Temperature modifyTarget(World world, EntityPlayer player, Temperature temperature) {
        int temperatureLevel;
        int newTemperatureLevel = temperatureLevel = temperature.getRawValue();
        BlockPos playerPos = player.func_180425_c();
        this.debugger.start(TemperatureDebugger.Modifier.SPRINTING_TARGET, newTemperatureLevel);
        if (player.func_70051_ag()) {
            newTemperatureLevel += 3;
        }
        this.debugger.end(newTemperatureLevel);
        return new Temperature(newTemperatureLevel);
    }
}

