/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.render;

import com.creativemd.creativecore.client.rendering.model.CreativeBakedModel;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderingThread
extends Thread {
    private static ConcurrentLinkedQueue<RenderingData> updateCoords = new ConcurrentLinkedQueue();
    private static HashMap<BlockPos, AtomicInteger> chunks = new HashMap();
    private static World lastWorld;
    public static RenderingThread instance;
    public boolean active = true;

    public static BlockPos getChunkCoords(BlockPos coord) {
        return new BlockPos(coord.func_177958_n() >> 4, 0, coord.func_177952_p() >> 4);
    }

    public static void addCoordToUpdate(TileEntityLittleTiles te, IBlockState state) {
        if (lastWorld != te.func_145831_w()) {
            updateCoords.clear();
        }
        lastWorld = te.func_145831_w();
        if (!updateCoords.contains(te.func_174877_v())) {
            BlockPos chunk = RenderingThread.getChunkCoords(te.func_174877_v());
            AtomicInteger count = chunks.get(chunk);
            if (count == null) {
                count = new AtomicInteger(0);
            }
            count.addAndGet(1);
            updateCoords.add(new RenderingData(te, state, te.func_174877_v()));
        }
    }

    public RenderingThread() {
        this.start();
    }

    @Override
    public void run() {
        while (this.active) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world != null && updateCoords.size() > 0) {
                RenderingData data = updateCoords.poll();
                try {
                    for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                        CreativeBakedModel.getBlockQuads((IBlockState)data.state, (EnumFacing)EnumFacing.field_82609_l[i], (long)0L, (boolean)true);
                    }
                    this.setRendered(data.te, data.pos);
                }
                catch (Exception e) {
                    updateCoords.add(data);
                }
                try {
                    RenderingThread.sleep(1L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (updateCoords.size() != 0) continue;
            chunks.clear();
        }
    }

    public synchronized void setRendered(TileEntityLittleTiles te, BlockPos coord) {
        te.isRendering = false;
        BlockPos chunk = RenderingThread.getChunkCoords(coord);
        AtomicInteger count = chunks.get(chunk);
        if (count != null) {
            count.addAndGet(-1);
        }
        if (count == null || count.intValue() <= 0) {
            chunks.remove(chunk);
            te.forceChunkRenderUpdate = true;
        }
    }

    static {
        instance = new RenderingThread();
    }

    private static class RenderingData {
        public TileEntityLittleTiles te;
        public IBlockState state;
        public BlockPos pos;

        public RenderingData(TileEntityLittleTiles te, IBlockState state, BlockPos pos) {
            this.te = te;
            this.state = state;
            this.pos = pos;
        }
    }
}

