/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.events;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.ISpecialBlockSelector;
import com.creativemd.littletiles.common.gui.SubContainerHammer;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.packet.LittleBlockVanillaPacket;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleEvent {
    @SubscribeEvent
    public void openContainer(PlayerContainerEvent event) {
        if (event.getContainer() instanceof ContainerWorkbench) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.LeftClickBlock event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = player.func_130014_f_();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (event.getHand() == EnumHand.MAIN_HAND && SubContainerHammer.isBlockValid(state.func_177230_c()) && stack != null && stack.func_77973_b() instanceof ISpecialBlockSelector) {
            if (world.field_72995_K) {
                this.onLeftInteractClient(stack, player, world, pos, state);
            }
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onLeftInteractClient(ItemStack stack, EntityPlayer player, World world, BlockPos pos, IBlockState state) {
        LittleTileBox box = ((ISpecialBlockSelector)stack.func_77973_b()).getBox(world, pos, state, player, Minecraft.func_71410_x().field_71476_x);
        world.func_175656_a(pos, LittleTiles.blockTile.func_176223_P());
        TileEntityLittleTiles te = (TileEntityLittleTiles)world.func_175625_s(pos);
        LittleTileBlock tile = new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
        tile.boundingBoxes.add(new LittleTileBox(0, 0, 0, LittleTile.maxPos, LittleTile.maxPos, LittleTile.maxPos));
        tile.te = te;
        ((LittleTile)tile).place();
        te.removeBoxFromTile(tile, box);
        if (!player.field_71075_bZ.field_75098_d) {
            tile.boundingBoxes.clear();
            tile.boundingBoxes.add(box.copy());
        }
        PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockVanillaPacket(pos, player));
    }

    @SubscribeEvent
    public void onInteract(PlayerInteractEvent.RightClickBlock event) {
        if (PlacementHelper.isLittleBlock(event.getEntityPlayer().func_184586_b(EnumHand.MAIN_HAND))) {
            if (event.getHand() == EnumHand.MAIN_HAND && event.getWorld().field_72995_K) {
                this.onRightInteractClient(event.getEntityPlayer(), event.getHand(), event.getWorld(), event.getEntityPlayer().func_184586_b(event.getHand()), event.getPos(), event.getFace());
            }
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void onRightInteractClient(EntityPlayer player, EnumHand hand, World world, ItemStack stack, BlockPos pos, EnumFacing facing) {
        RayTraceResult moving = Minecraft.func_71410_x().field_71476_x;
        ((ItemBlockTiles)Item.func_150898_a((Block)LittleTiles.blockTile)).func_180614_a(stack, player, world, pos, hand, facing, (float)moving.field_72307_f.field_72450_a, (float)moving.field_72307_f.field_72448_b, (float)moving.field_72307_f.field_72449_c);
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void drawHighlight(DrawBlockHighlightEvent event) {
        if (event.getTarget().field_72313_a == RayTraceResult.Type.BLOCK) {
            EntityPlayer player = event.getPlayer();
            World world = event.getPlayer().func_130014_f_();
            BlockPos pos = event.getTarget().func_178782_a();
            IBlockState state = world.func_180495_p(pos);
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (SubContainerHammer.isBlockValid(state.func_177230_c()) && stack != null && stack.func_77973_b() instanceof ISpecialBlockSelector) {
                double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
                double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
                double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
                LittleTileBox box = ((ISpecialBlockSelector)stack.func_77973_b()).getBox(world, pos, state, player, event.getTarget());
                box.addOffset(new LittleTileVec((Vec3i)pos));
                GlStateManager.func_179147_l();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187441_d((float)2.0f);
                GlStateManager.func_179090_x();
                GlStateManager.func_179132_a((boolean)false);
                RenderGlobal.func_189697_a((AxisAlignedBB)box.getBox().func_186662_g((double)0.002f).func_72317_d(-d0, -d1, -d2), (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4f);
                GlStateManager.func_179132_a((boolean)true);
                GlStateManager.func_179098_w();
                GlStateManager.func_179084_k();
                event.setCanceled(true);
            }
        }
    }
}

