/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.gui.container.SubContainer;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.LittleTileBlockColored;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBreakable;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SubContainerHammer
extends SubContainer {
    public InventoryBasic basic = new InventoryBasic("Hammer", false, 1);

    public SubContainerHammer(EntityPlayer player) {
        super(player);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean doesBlockSupportedTranslucent(Block block) {
        return block.func_180664_k() == BlockRenderLayer.SOLID || block.func_180664_k() == BlockRenderLayer.TRANSLUCENT;
    }

    public static boolean isBlockValid(Block block) {
        return block.func_149721_r(block.func_176223_P()) || block.func_185481_k(block.func_176223_P()) || block.func_149730_j(block.func_176223_P()) || block instanceof BlockGlass || block instanceof BlockStainedGlass || block instanceof BlockBreakable;
    }

    public void onClosed() {
        if (this.basic.func_70301_a(0) != null) {
            this.player.func_71019_a(this.basic.func_70301_a(0), false);
        }
    }

    public void createControls() {
        this.addSlotToContainer(new Slot((IInventory)this.basic, 0, 10, 10));
        this.addPlayerSlotsToContainer(this.player, 20, 120);
    }

    public void sendUpdate() {
    }

    public void onPacketReceive(NBTTagCompound nbt) {
        LittleTileSize size = new LittleTileSize(nbt.func_74762_e("sizeX"), nbt.func_74762_e("sizeY"), nbt.func_74762_e("sizeZ"));
        ItemStack stack = this.basic.func_70301_a(0);
        if (stack != null && stack.func_77973_b() instanceof ItemBlock) {
            double volumePerItem = 1.0;
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            if (SubContainerHammer.isBlockValid(block) || stack.func_77973_b() instanceof ItemBlockTiles) {
                double availableVolume = stack.field_77994_a;
                if (stack.func_77973_b() instanceof ItemBlockTiles) {
                    block = null;
                    volumePerItem = 0.0;
                    ArrayList<LittleTilePreview> previews = ((ItemBlockTiles)stack.func_77973_b()).getLittlePreview(stack);
                    for (int i = 0; i < previews.size(); ++i) {
                        if (block == null) {
                            block = previews.get(i).getPreviewBlock();
                        }
                        volumePerItem += (double)previews.get((int)i).size.getPercentVolume();
                    }
                    availableVolume = volumePerItem * (double)stack.field_77994_a;
                }
                if (block.hasTileEntity(block.func_176203_a(stack.func_77952_i()))) {
                    return;
                }
                int alltiles = (int)(availableVolume / (double)size.getPercentVolume());
                int tiles = Math.min(alltiles, 64);
                if (alltiles == 0 || block == null) {
                    return;
                }
                int blocks = (int)Math.ceil((double)((float)tiles * size.getPercentVolume()) / volumePerItem);
                stack.field_77994_a -= blocks;
                if (stack.field_77994_a <= 0) {
                    this.basic.func_70299_a(0, null);
                }
                ItemStack dropstack = new ItemStack((Block)LittleTiles.blockTile);
                dropstack.field_77994_a = tiles;
                dropstack.func_77982_d(new NBTTagCompound());
                size.writeToNBT("size", dropstack.func_77978_p());
                LittleTileBlock tile = null;
                tile = nbt.func_74764_b("color") && nbt.func_74762_e("color") != ColorUtils.WHITE ? new LittleTileBlockColored(block, stack.func_77952_i(), ColorUtils.IntToRGB((int)nbt.func_74762_e("color"))) : new LittleTileBlock(block, stack.func_77952_i());
                ((LittleTile)tile).saveTileExtra(dropstack.func_77978_p());
                dropstack.func_77978_p().func_74778_a("tID", "BlockTileBlock");
                float missingTiles = (float)blocks - (float)tiles * size.getPercentVolume();
                if (missingTiles > 0.0f) {
                    ItemTileContainer.addBlock(this.player, block, stack.func_77952_i(), missingTiles);
                }
                this.player.field_71071_by.func_70441_a(dropstack);
            }
        }
    }
}

