/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.client.rendering.model.ICreativeRendered;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.creativecore.common.utils.RenderCubeObject;
import com.creativemd.creativecore.common.utils.TickUtils;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.client.render.PreviewRenderer;
import com.creativemd.littletiles.common.blocks.BlockTile;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.items.ItemTileContainer;
import com.creativemd.littletiles.common.packet.LittlePlacePacket;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileCoord;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PlacePreviewTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBlockTiles
extends ItemBlock
implements ILittleTile,
ICreativeRendered {
    public ItemBlockTiles(Block block, ResourceLocation location) {
        super(block);
        this.func_77655_b(location.func_110623_a());
        this.field_77787_bX = true;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77653_i(ItemStack stack) {
        String result = super.func_77653_i(stack);
        if (stack.func_77942_o()) {
            LittleTileSize size = new LittleTileSize("size", stack.func_77978_p());
            result = result + " (x=" + size.sizeX + ",y=" + size.sizeY + "z=" + size.sizeZ + ")";
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public String func_77667_c(ItemStack stack) {
        Block block;
        if (stack.func_77942_o() && (block = Block.func_149684_b((String)stack.func_77978_p().func_74779_i("block"))) != null && !(block instanceof BlockAir)) {
            return new ItemStack(block, 1, stack.func_77978_p().func_74762_e("meta")).func_77977_a();
        }
        return super.func_77667_c(stack);
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            return EnumActionResult.FAIL;
        }
        PlacementHelper helper = PlacementHelper.getInstance(playerIn);
        RayTraceResult moving = Minecraft.func_71410_x().field_71476_x;
        if (PreviewRenderer.markedHit != null) {
            moving = PreviewRenderer.markedHit;
        }
        facing = moving.field_178784_b;
        if (PreviewRenderer.markedHit == null) {
            if (!helper.canBePlacedInside(pos, moving.field_72307_f, facing)) {
                pos = pos.func_177972_a(facing);
            }
        } else {
            pos = moving.func_178782_a().func_177972_a(facing);
        }
        if (stack.field_77994_a != 0 && playerIn.func_175151_a(pos, facing, stack)) {
            if (worldIn.field_72995_K) {
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittlePlacePacket(playerIn.func_174824_e(TickUtils.getPartialTickTime()), moving.field_72307_f, pos, facing, PreviewRenderer.markedHit != null, GuiScreen.func_146271_m()));
            }
            if (this.placeBlockAt(playerIn, stack, worldIn, playerIn.func_174824_e(TickUtils.getPartialTickTime()), moving.field_72307_f, helper, pos, facing, PreviewRenderer.markedHit != null, GuiScreen.func_146271_m())) {
                PreviewRenderer.markedHit = null;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item stack, CreativeTabs tab, List list) {
    }

    public static HashMapList<BlockPos, PlacePreviewTile> getSplittedTiles(ArrayList<PlacePreviewTile> tiles, BlockPos pos) {
        HashMapList splitted = new HashMapList();
        for (int i = 0; i < tiles.size(); ++i) {
            if (tiles.get(i).split((HashMapList<BlockPos, PlacePreviewTile>)splitted, pos)) continue;
            return null;
        }
        return splitted;
    }

    public static boolean canPlaceTiles(World world, HashMapList<BlockPos, PlacePreviewTile> splitted, ArrayList<BlockPos> coordsToCheck, boolean forced) {
        for (BlockPos pos : coordsToCheck) {
            ArrayList tiles = splitted.getValues((Object)pos);
            boolean needsCollisionCheck = false;
            if (tiles != null) {
                for (int j = 0; j < tiles.size(); ++j) {
                    if (!((PlacePreviewTile)tiles.get(j)).needsCollisionTest()) continue;
                    needsCollisionCheck = true;
                    break;
                }
            }
            if (!needsCollisionCheck) continue;
            TileEntity mainTile = world.func_175625_s(pos);
            if (mainTile instanceof TileEntityLittleTiles) {
                if (forced) {
                    return true;
                }
                if (tiles == null) continue;
                for (int j = 0; j < tiles.size(); ++j) {
                    if (!((PlacePreviewTile)tiles.get(j)).needsCollisionTest() || ((TileEntityLittleTiles)mainTile).isSpaceForLittleTile(((PlacePreviewTile)tiles.get((int)j)).box)) continue;
                    return false;
                }
                continue;
            }
            IBlockState state = world.func_180495_p(pos);
            if (forced) {
                if (!(state.func_177230_c() instanceof BlockTile) && !state.func_185904_a().func_76222_j()) continue;
                return true;
            }
            if (state.func_177230_c() instanceof BlockTile || state.func_185904_a().func_76222_j()) continue;
            return false;
        }
        return !forced;
    }

    public static boolean placeTiles(World world, EntityPlayer player, ArrayList<PlacePreviewTile> previews, LittleStructure structure, BlockPos pos, ItemStack stack, ArrayList<LittleTile> unplaceableTiles, boolean forced, EnumFacing facing) {
        HashMapList<BlockPos, PlacePreviewTile> splitted = ItemBlockTiles.getSplittedTiles(previews, pos);
        if (splitted == null) {
            return false;
        }
        ArrayList<BlockPos> coordsToCheck = new ArrayList<BlockPos>();
        if (structure != null) {
            coordsToCheck.addAll(splitted.getKeys());
        } else if (forced) {
            coordsToCheck.addAll(splitted.getKeys());
        } else {
            coordsToCheck.add(pos);
        }
        ArrayList<SoundType> soundsToBePlayed = new ArrayList<SoundType>();
        if (ItemBlockTiles.canPlaceTiles(world, splitted, coordsToCheck, forced)) {
            LittleTile.LittleTilePosition littlePos = null;
            ArrayList<LastPlacedTile> lastPlacedTiles = new ArrayList<LastPlacedTile>();
            for (BlockPos coord : splitted.getKeys()) {
                TileEntity te;
                ArrayList placeTiles = splitted.getValues((Object)coord);
                boolean hascollideBlock = false;
                int i = 0;
                while (i < placeTiles.size()) {
                    if (((PlacePreviewTile)placeTiles.get(i)).needsCollisionTest()) {
                        hascollideBlock = true;
                        ++i;
                        continue;
                    }
                    lastPlacedTiles.add(new LastPlacedTile((PlacePreviewTile)placeTiles.get(i), coord));
                    placeTiles.remove(i);
                }
                if (!hascollideBlock) continue;
                if (!(world.func_180495_p(coord).func_177230_c() instanceof BlockTile) && world.func_180495_p(coord).func_185904_a().func_76222_j()) {
                    world.func_175656_a(coord, LittleTiles.blockTile.func_176223_P());
                }
                if (!((te = world.func_175625_s(coord)) instanceof TileEntityLittleTiles)) continue;
                TileEntityLittleTiles teLT = (TileEntityLittleTiles)te;
                teLT.preventUpdate = true;
                for (int j = 0; j < placeTiles.size(); ++j) {
                    LittleTile LT = ((PlacePreviewTile)placeTiles.get(j)).placeTile(player, stack, coord, teLT, structure, unplaceableTiles, forced, facing);
                    if (LT == null) continue;
                    if (!soundsToBePlayed.contains(LT.getSound())) {
                        soundsToBePlayed.add(LT.getSound());
                    }
                    if (structure == null) continue;
                    if (littlePos == null) {
                        structure.setMainTile(LT);
                        littlePos = new LittleTile.LittleTilePosition(coord, LT.cornerVec);
                        continue;
                    }
                    LT.coord = new LittleTileCoord((TileEntity)teLT, littlePos.coord, littlePos.position);
                }
                teLT.preventUpdate = false;
                teLT.updateTiles();
            }
            for (int j = 0; j < lastPlacedTiles.size(); ++j) {
                ((LastPlacedTile)lastPlacedTiles.get((int)j)).tile.placeTile(player, stack, ((LastPlacedTile)lastPlacedTiles.get((int)j)).pos, null, structure, unplaceableTiles, forced, facing);
            }
            if (structure != null) {
                structure.combineTiles();
            }
            for (int i = 0; i < soundsToBePlayed.size(); ++i) {
                world.func_184133_a((EntityPlayer)null, pos, ((SoundType)soundsToBePlayed.get(i)).func_185841_e(), SoundCategory.BLOCKS, (((SoundType)soundsToBePlayed.get(i)).func_185843_a() + 1.0f) / 2.0f, ((SoundType)soundsToBePlayed.get(i)).func_185847_b() * 0.8f);
            }
            return true;
        }
        return false;
    }

    public boolean placeBlockAt(EntityPlayer player, ItemStack stack, World world, Vec3d playerPos, Vec3d hitVec, PlacementHelper helper, BlockPos pos, EnumFacing facing, boolean customPlacement, boolean forced) {
        ArrayList<LittleTile> unplaceableTiles;
        ArrayList<PlacePreviewTile> previews;
        LittleStructure structure = null;
        if (stack.func_77973_b() instanceof ILittleTile) {
            structure = ((ILittleTile)stack.func_77973_b()).getLittleStructure(stack);
        } else if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
            structure = ((ILittleTile)Block.func_149634_a((Item)stack.func_77973_b())).getLittleStructure(stack);
        }
        if (structure != null) {
            structure.setTiles(new ArrayList<LittleTile>());
            forced = false;
        }
        if (ItemBlockTiles.placeTiles(world, player, previews = helper.getPreviewTiles(stack, pos, playerPos, hitVec, facing, customPlacement, true), structure, pos, stack, unplaceableTiles = new ArrayList<LittleTile>(), forced, facing)) {
            if (!player.field_71075_bZ.field_75098_d) {
                --player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a;
                if (player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c].field_77994_a == 0) {
                    player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                }
            }
            if (!world.field_72995_K) {
                for (int j = 0; j < unplaceableTiles.size(); ++j) {
                    if (unplaceableTiles.get(j) instanceof LittleTileBlock || ItemTileContainer.addBlock(player, ((LittleTileBlock)unplaceableTiles.get((int)j)).block, ((LittleTileBlock)unplaceableTiles.get((int)j)).meta, (float)((LittleTileBlock)unplaceableTiles.get(j)).getPercentVolume())) continue;
                    WorldUtils.dropItem((World)world, unplaceableTiles.get(j).getDrops(), (BlockPos)pos);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<LittleTilePreview> getLittlePreview(ItemStack stack) {
        ArrayList<LittleTilePreview> previews = new ArrayList<LittleTilePreview>();
        previews.add(LittleTilePreview.loadPreviewFromNBT(stack.func_77978_p()));
        return previews;
    }

    @Override
    public void saveLittlePreview(ItemStack stack, ArrayList<LittleTilePreview> previews) {
        stack.func_77982_d(new NBTTagCompound());
        if (previews.size() > 0) {
            previews.get(0).writeToNBT(stack.func_77978_p());
        }
    }

    public static ArrayList<RenderCubeObject> getItemRenderingCubes(ItemStack stack) {
        ArrayList<RenderCubeObject> cubes = new ArrayList<RenderCubeObject>();
        Block block = Block.func_149684_b((String)stack.func_77978_p().func_74779_i("block"));
        int meta = stack.func_77978_p().func_74762_e("meta");
        LittleTileSize size = new LittleTileSize("size", stack.func_77978_p());
        if (!(block instanceof BlockAir)) {
            RenderCubeObject cube = new RenderCubeObject(new LittleTileBox(new LittleTileVec(LittleTile.halfGridSize, LittleTile.halfGridSize, LittleTile.halfGridSize), size).getCube(), block, meta);
            if (stack.func_77978_p().func_74764_b("color")) {
                cube.color = stack.func_77978_p().func_74762_e("color");
            }
            cubes.add(cube);
        }
        return cubes;
    }

    @Override
    public LittleStructure getLittleStructure(ItemStack stack) {
        return null;
    }

    public ArrayList<RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        if (stack != null) {
            return ItemBlockTiles.getItemRenderingCubes(stack);
        }
        return new ArrayList<RenderCubeObject>();
    }

    public static class LastPlacedTile {
        public final PlacePreviewTile tile;
        public final BlockPos pos;

        public LastPlacedTile(PlacePreviewTile tile, BlockPos pos) {
            this.tile = tile;
            this.pos = pos;
        }
    }
}

