/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.items;

import com.creativemd.creativecore.gui.container.SubContainer;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.creativecore.gui.opener.GuiHandler;
import com.creativemd.creativecore.gui.opener.IGuiCreator;
import com.creativemd.littletiles.common.gui.SubContainerTileContainer;
import com.creativemd.littletiles.common.gui.SubGuiTileContainer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemTileContainer
extends Item
implements IGuiCreator {
    public ItemTileContainer() {
        this.func_77637_a(CreativeTabs.field_78040_i);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        list.add("can store little pieces and");
        list.add("can be used to provide");
        list.add("needed materials");
    }

    public static void saveMap(ItemStack stack, ArrayList<BlockEntry> map) {
        NBTTagCompound nbt = new NBTTagCompound();
        int i = 0;
        for (BlockEntry entry : map) {
            if (entry.block == null || entry.block instanceof BlockAir) continue;
            nbt.func_74778_a("b" + i, ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)entry.block)).toString());
            nbt.func_74768_a("m" + i, entry.meta);
            nbt.func_74776_a("v" + i, entry.value);
            ++i;
        }
        nbt.func_74768_a("count", i + 1);
        stack.func_77982_d(nbt);
    }

    public static ArrayList<BlockEntry> loadMap(EntityPlayer player) {
        ArrayList<BlockEntry> mainList = new ArrayList<BlockEntry>();
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null || !(stack.func_77973_b() instanceof ItemTileContainer)) continue;
            ItemTileContainer.mergeMap(mainList, ItemTileContainer.loadMap(stack));
        }
        return mainList;
    }

    public static void mergeMap(ArrayList<BlockEntry> mainMap, ArrayList<BlockEntry> newMap) {
        if (newMap == null) {
            return;
        }
        for (BlockEntry entry : newMap) {
            if (mainMap.contains(entry)) {
                BlockEntry mainEntry = mainMap.get(mainMap.indexOf(entry));
                mainEntry.value += entry.value;
                continue;
            }
            mainMap.add(entry);
        }
    }

    public static ArrayList<BlockEntry> loadMap(ItemStack stack) {
        ArrayList<BlockEntry> mainMap = new ArrayList<BlockEntry>();
        if (stack.func_77942_o()) {
            int count = stack.func_77978_p().func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                Block block = Block.func_149684_b((String)stack.func_77978_p().func_74779_i("b" + i));
                int meta = stack.func_77978_p().func_74762_e("m" + i);
                if (block == null || block instanceof BlockAir) continue;
                mainMap.add(new BlockEntry(block, meta, stack.func_77978_p().func_74760_g("v" + i)));
            }
        }
        return mainMap;
    }

    public static boolean drainBlock(EntityPlayer player, Block block, int meta, float ammount) {
        BlockEntry entry;
        ArrayList<BlockEntry> mainList = ItemTileContainer.loadMap(player);
        if (mainList.contains(entry = new BlockEntry(block, meta, 0.0f)) && mainList.get((int)mainList.indexOf((Object)entry)).value >= ammount) {
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ArrayList<BlockEntry> stackMap;
                ItemStack stack = player.field_71071_by.field_70462_a[i];
                if (stack == null || !(stack.func_77973_b() instanceof ItemTileContainer) || !(stackMap = ItemTileContainer.loadMap(stack)).contains(entry)) continue;
                float stored = stackMap.get((int)stackMap.indexOf((Object)entry)).value;
                float drain = Math.min(ammount, stored);
                ammount -= drain;
                stackMap.get((int)stackMap.indexOf((Object)entry)).value = stored -= drain;
                if (stored <= 0.0f) {
                    stackMap.remove(entry);
                }
                ItemTileContainer.saveMap(stack, stackMap);
            }
            return true;
        }
        return false;
    }

    public static boolean drainBlock(ItemStack stack, Block block, int meta, float ammount) {
        BlockEntry entry = new BlockEntry(block, meta, 0.0f);
        ArrayList<BlockEntry> stackMap = ItemTileContainer.loadMap(stack);
        if (stackMap.contains(entry) && stackMap.get((int)stackMap.indexOf((Object)entry)).value >= ammount) {
            float stored = stackMap.get((int)stackMap.indexOf((Object)entry)).value;
            float drain = Math.min(ammount, stored);
            ammount -= drain;
            stackMap.get((int)stackMap.indexOf((Object)entry)).value -= (stored -= drain);
            if (stored <= 0.0f) {
                stackMap.remove(entry);
            }
            ItemTileContainer.saveMap(stack, stackMap);
            return true;
        }
        return false;
    }

    public static boolean addBlock(EntityPlayer player, Block block, int meta, float ammount) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            ItemStack stack = player.field_71071_by.field_70462_a[i];
            if (stack == null || !(stack.func_77973_b() instanceof ItemTileContainer)) continue;
            ItemTileContainer.addBlock(stack, block, meta, ammount);
            return true;
        }
        return false;
    }

    public static void addBlock(ItemStack stack, Block block, int meta, float ammount) {
        BlockEntry entry = new BlockEntry(block, meta, ammount);
        ArrayList<BlockEntry> stackMap = ItemTileContainer.loadMap(stack);
        if (stackMap.contains(entry)) {
            stackMap.get((int)stackMap.indexOf((Object)entry)).value += ammount;
        } else {
            stackMap.add(entry);
        }
        ItemTileContainer.saveMap(stack, stackMap);
    }

    @SideOnly(value=Side.CLIENT)
    public SubGui getGui(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubGuiTileContainer(stack);
    }

    public SubContainer getContainer(EntityPlayer player, ItemStack stack, World world, BlockPos pos, IBlockState state) {
        return new SubContainerTileContainer(player, stack, player.field_71071_by.field_70461_c);
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        if (!worldIn.field_72995_K) {
            GuiHandler.openGuiItem((EntityPlayer)playerIn, (World)worldIn);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
    }

    public static class BlockEntry {
        public Block block;
        public int meta;
        public float value;

        public BlockEntry(Block block, int meta, float value) {
            this.block = block;
            this.meta = meta;
            this.value = value;
        }

        public ItemStack getItemStack() {
            return new ItemStack(this.block, 1, this.meta);
        }

        public boolean equals(Object object) {
            return object instanceof BlockEntry && ((BlockEntry)object).block == this.block && ((BlockEntry)object).meta == this.meta;
        }
    }
}

