/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.creativecore.common.utils.RenderCubeObject;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PlacePreviewTile;
import com.creativemd.littletiles.utils.ShiftHandler;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTilePreview {
    private static HashMap<String, Class<? extends LittleTilePreview>> previewTypes = new HashMap();
    public boolean canSplit = true;
    public LittleTileSize size = null;
    protected NBTTagCompound tileData;
    public LittleTileBox box;
    public ArrayList<ShiftHandler> shifthandlers = new ArrayList();

    public static void registerPreviewType(String id, Class<? extends LittleTilePreview> type) {
        previewTypes.put(id, type);
    }

    public String getTypeID() {
        if (!this.isCustomPreview()) {
            return "";
        }
        for (Map.Entry<String, Class<? extends LittleTilePreview>> type : previewTypes.entrySet()) {
            if (type.getValue() != this.getClass()) continue;
            return type.getKey();
        }
        return "";
    }

    public LittleTilePreview(NBTTagCompound nbt) {
        if (nbt.func_74764_b("sizex") || nbt.func_74764_b("size")) {
            this.size = new LittleTileSize("size", nbt);
        }
        if (nbt.func_74764_b("bBoxminX") || nbt.func_74764_b("bBox")) {
            this.box = new LittleTileBox("bBox", nbt);
            if (this.size == null) {
                this.size = this.box.getSize();
            }
        }
        if (nbt.func_74764_b("tile")) {
            this.tileData = nbt.func_74775_l("tile");
        } else {
            this.tileData = nbt.func_74737_b();
            this.tileData.func_82580_o("bBox");
            this.tileData.func_82580_o("size");
        }
    }

    public LittleTilePreview(LittleTileBox box, NBTTagCompound tileData) {
        this(box.getSize(), tileData);
        this.box = box;
    }

    public LittleTilePreview(LittleTileSize size, NBTTagCompound tileData) {
        this.size = size;
        this.tileData = tileData;
    }

    public LittleTile getLittleTile(TileEntityLittleTiles te) {
        return LittleTile.CreateandLoadTile(te, te.func_145831_w(), this.tileData);
    }

    public String getPreviewBlockName() {
        return this.tileData.func_74779_i("block");
    }

    public Block getPreviewBlock() {
        if (this.tileData.func_74764_b("block")) {
            return Block.func_149684_b((String)this.getPreviewBlockName());
        }
        return Blocks.field_150350_a;
    }

    public int getPreviewBlockMeta() {
        return this.tileData.func_74762_e("meta");
    }

    public boolean hasColor() {
        return this.tileData.func_74764_b("color");
    }

    public int getColor() {
        return this.tileData.func_74762_e("color");
    }

    @SideOnly(value=Side.CLIENT)
    public RenderCubeObject getCubeBlock() {
        RenderCubeObject cube = new RenderCubeObject(this.box.getCube(), null);
        if (this.tileData.func_74764_b("block")) {
            cube.block = this.getPreviewBlock();
            cube.meta = this.getPreviewBlockMeta();
        } else {
            cube.block = Blocks.field_150348_b;
        }
        if (this.tileData.func_74764_b("color")) {
            cube.color = this.tileData.func_74762_e("color");
        }
        return cube;
    }

    public LittleTilePreview copy() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        LittleTilePreview preview = LittleTilePreview.loadPreviewFromNBT(nbt);
        if (preview == null) {
            preview = this.box != null ? new LittleTilePreview(this.box, this.tileData.func_74737_b()) : new LittleTilePreview(this.size != null ? this.size.copy() : null, this.tileData.func_74737_b());
        }
        preview.canSplit = this.canSplit;
        preview.shifthandlers = new ArrayList<ShiftHandler>(this.shifthandlers);
        return preview;
    }

    public PlacePreviewTile getPlaceableTile(LittleTileBox box, boolean canPlaceNormal, LittleTileVec offset) {
        if (this.box == null) {
            return new PlacePreviewTile(box.copy(), this);
        }
        LittleTileBox newBox = this.box.copy();
        if (!canPlaceNormal) {
            newBox.addOffset(offset);
        }
        return new PlacePreviewTile(newBox, this);
    }

    public void flipPreview(EnumFacing direction) {
        if (this.box != null) {
            this.box.flipBoxWithCenter(direction, null);
        }
    }

    public void rotatePreview(Rotation direction) {
        this.size.rotateSize(direction);
        if (this.box != null) {
            this.box.rotateBoxWithCenter(direction, new Vec3d(0.03125, 0.03125, 0.03125));
            this.size = this.box.getSize();
        }
    }

    public void rotatePreview(EnumFacing direction) {
        this.size.rotateSize(direction);
        if (this.box != null) {
            this.box.rotateBox(direction);
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.box != null) {
            this.box.writeToNBT("bBox", nbt);
        }
        this.size.writeToNBT("size", nbt);
        nbt.func_74782_a("tile", (NBTBase)this.tileData);
        if (this.isCustomPreview() && !this.getTypeID().equals("")) {
            nbt.func_74778_a("type", this.getTypeID());
        }
    }

    public boolean isCustomPreview() {
        return this.getClass() != LittleTilePreview.class;
    }

    public static LittleTilePreview loadPreviewFromNBT(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        if (nbt.func_74764_b("type")) {
            Class<? extends LittleTilePreview> type = previewTypes.get(nbt.func_74779_i("type"));
            if (type != null) {
                LittleTilePreview preview = null;
                try {
                    preview = type.getConstructor(NBTTagCompound.class).newInstance(nbt);
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                    e.printStackTrace();
                }
                return preview;
            }
        } else {
            return new LittleTilePreview(nbt);
        }
        return null;
    }
}

