/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.converting;

import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.items.ItemMultiTiles;
import com.creativemd.littletiles.common.items.ItemRecipe;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class StructureStringUtils {
    public static String exportStructure(ItemStack stack) {
        String text = "";
        if (stack != null && (PlacementHelper.isLittleBlock(stack) || stack.func_77973_b() instanceof ItemRecipe)) {
            NBTTagCompound nbt = new NBTTagCompound();
            ArrayList<LittleTilePreview> previews = null;
            LittleStructure structure = null;
            if (stack.func_77973_b() instanceof ItemRecipe) {
                previews = ItemRecipe.getPreview(stack);
                structure = ItemMultiTiles.getLTStructure(stack);
            } else {
                ILittleTile tile = PlacementHelper.getLittleInterface(stack);
                previews = tile.getLittlePreview(stack);
                structure = tile.getLittleStructure(stack);
            }
            nbt.func_74768_a("tiles", previews.size());
            ArrayList<String> blockNames = new ArrayList<String>();
            for (int i = 0; i < previews.size(); ++i) {
                if (previews.get((int)i).box == null) continue;
                LittleTileBox box = previews.get((int)i).box;
                String blockName = previews.get(i).getPreviewBlockName();
                if (!blockNames.contains(blockName)) {
                    blockNames.add(blockName);
                }
                String tileString = blockNames.indexOf(blockName) + "." + previews.get(i).getPreviewBlockMeta();
                if (previews.get(i).hasColor()) {
                    tileString = tileString + "." + previews.get(i).getColor();
                }
                nbt.func_74778_a("" + i, box.minX + "." + box.minY + "." + box.minZ + "." + box.maxX + "." + box.maxY + "." + box.maxZ + "." + tileString);
            }
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < blockNames.size(); ++i) {
                if (i > 0) {
                    builder.append(".");
                }
                builder.append((String)blockNames.get(i));
            }
            nbt.func_74778_a("names", builder.toString());
            if (structure != null) {
                NBTTagCompound nbtStructure = new NBTTagCompound();
                structure.writeToNBT(nbtStructure);
                nbt.func_74782_a("structure", (NBTBase)nbtStructure);
            }
            text = nbt.toString();
        }
        return text;
    }

    public static ItemStack importStructure(String input) {
        try {
            NBTTagCompound nbt = JsonToNBT.func_180713_a((String)input);
            NBTTagCompound itemNBT = new NBTTagCompound();
            if (nbt.func_74764_b("structure")) {
                itemNBT.func_74782_a("structure", (NBTBase)nbt.func_74775_l("structure"));
            }
            String[] names = nbt.func_74779_i("names").split("\\.");
            int tiles = nbt.func_74762_e("tiles");
            for (int i = 0; i < tiles; ++i) {
                String[] entries = nbt.func_74779_i("" + i).split("\\.");
                if (entries.length < 8) continue;
                NBTTagCompound tileNBT = new NBTTagCompound();
                LittleTileBox box = new LittleTileBox(Integer.parseInt(entries[0]), Integer.parseInt(entries[1]), Integer.parseInt(entries[2]), Integer.parseInt(entries[3]), Integer.parseInt(entries[4]), Integer.parseInt(entries[5]));
                tileNBT.func_74778_a("block", names[Integer.parseInt(entries[6])]);
                tileNBT.func_74768_a("meta", Integer.parseInt(entries[7]));
                if (entries.length >= 9) {
                    tileNBT.func_74768_a("color", Integer.parseInt(entries[8]));
                }
                box.writeToNBT("bBox", tileNBT);
                tileNBT.func_74778_a("tID", "BlockTileBlock");
                itemNBT.func_74782_a("tile" + i, (NBTBase)tileNBT);
            }
            itemNBT.func_74768_a("tiles", tiles);
            ItemStack stack = new ItemStack(LittleTiles.recipe);
            stack.func_77982_d(itemNBT);
            return stack;
        }
        catch (Exception exception) {
            return null;
        }
    }
}

