/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.utils;

import com.creativemd.creativecore.client.rendering.RenderHelper3D;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.ShiftHandler;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public abstract class BoxShiftHandler
extends ShiftHandler {
    public ArrayList<LittleTileBox> boxes = new ArrayList();

    @Override
    public void init(World world, BlockPos pos) {
        this.boxes = this.getBoxes(world, pos);
    }

    public abstract ArrayList<LittleTileBox> getBoxes(World var1, BlockPos var2);

    @Override
    public void handleRendering(Minecraft mc, double x, double y, double z) {
        for (int i = 0; i < this.boxes.size(); ++i) {
            if (!this.boxes.get(i).isValidBox()) continue;
            GL11.glPushMatrix();
            CubeObject cube = this.boxes.get(i).getCube();
            LittleTileSize size = this.boxes.get(i).getSize();
            double cubeX = x + (double)cube.minX + size.getPosX() / 2.0;
            double cubeY = y + (double)cube.minY + size.getPosY() / 2.0;
            double cubeZ = z + (double)cube.minZ + size.getPosZ() / 2.0;
            RenderHelper3D.renderBlock((double)cubeX, (double)cubeY, (double)cubeZ, (double)size.getPosX(), (double)size.getPosY(), (double)size.getPosZ(), (double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)0.5, (double)((Math.sin((double)System.nanoTime() / 2.0E8) + 1.5) * 0.2));
            GL11.glPopMatrix();
        }
    }

    @Override
    public double getDistance(LittleTileVec suggestedPos) {
        double distance = 2.0;
        for (int i = 0; i < this.boxes.size(); ++i) {
            distance = Math.min(distance, this.boxes.get(i).distanceTo(suggestedPos));
        }
        return 0.0;
    }

    @Override
    protected LittleTileBox getNewPos(World world, BlockPos pos, LittleTileBox suggested) {
        return null;
    }
}

