/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.utils;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PlacePreviewTile {
    public static final Vec3d white = new Vec3d(1.0, 1.0, 1.0);
    public LittleTileBox box;
    public LittleTilePreview preview;

    public PlacePreviewTile(LittleTileBox box, LittleTilePreview preview) {
        this.box = box;
        this.preview = preview;
    }

    public PlacePreviewTile copy() {
        return new PlacePreviewTile(this.box.copy(), this.preview.copy());
    }

    public Vec3d getPreviewColor() {
        return white;
    }

    public boolean needsCollisionTest() {
        return true;
    }

    public LittleTileBox getPreviewBox() {
        return this.box;
    }

    public LittleTile placeTile(EntityPlayer player, ItemStack stack, BlockPos pos, TileEntityLittleTiles teLT, LittleStructure structure, ArrayList<LittleTile> unplaceableTiles, boolean forced, EnumFacing facing) {
        LittleTile LT = this.preview.getLittleTile(teLT);
        if (LT == null) {
            return null;
        }
        LT.boundingBoxes.clear();
        LT.boundingBoxes.add(this.box.copy());
        LT.updateCorner();
        if (structure != null) {
            LT.isStructureBlock = true;
            LT.structure = structure;
            structure.getTiles().add(LT);
        }
        if (teLT.isSpaceForLittleTile(this.box.copy())) {
            LT.place();
            LT.onPlaced(player, stack, facing);
            return LT;
        }
        if (forced) {
            int i;
            ArrayList<LittleTileBox> newBoxes = new ArrayList<LittleTileBox>();
            ArrayList<LittleTileBox> unplaceableBoxes = new ArrayList<LittleTileBox>();
            for (int littleX = this.box.minX; littleX < this.box.maxX; ++littleX) {
                for (int littleY = this.box.minY; littleY < this.box.maxY; ++littleY) {
                    for (int littleZ = this.box.minZ; littleZ < this.box.maxZ; ++littleZ) {
                        LittleTileBox newBox = new LittleTileBox(littleX, littleY, littleZ, littleX + 1, littleY + 1, littleZ + 1);
                        if (teLT.isSpaceForLittleTile(newBox)) {
                            newBoxes.add(newBox);
                            continue;
                        }
                        unplaceableBoxes.add(newBox);
                    }
                }
            }
            LittleTileBox.combineBoxes(newBoxes);
            LittleTile first = null;
            for (i = 0; i < newBoxes.size(); ++i) {
                LittleTile newTile = LT.copy();
                newTile.boundingBoxes.clear();
                newTile.boundingBoxes.add(newBoxes.get(i));
                newTile.place();
                newTile.onPlaced(player, stack, facing);
                if (i != 0) continue;
                first = newTile;
            }
            LittleTileBox.combineBoxes(unplaceableBoxes);
            for (i = 0; i < unplaceableBoxes.size(); ++i) {
                LittleTile newTile = LT.copy();
                newTile.boundingBoxes.clear();
                newTile.boundingBoxes.add(unplaceableBoxes.get(i));
                unplaceableTiles.add(newTile);
            }
            return first;
        }
        if (unplaceableTiles != null) {
            unplaceableTiles.add(LT);
        }
        return null;
    }

    public boolean split(HashMapList<BlockPos, PlacePreviewTile> tiles, BlockPos pos) {
        if (this.preview != null && !this.preview.canSplit && this.box.needsMultipleBlocks()) {
            return false;
        }
        LittleTileSize size = this.box.getSize();
        int offX = this.box.minX / LittleTile.gridSize;
        if (this.box.minX < 0) {
            offX = (int)Math.floor((double)this.box.minX / (double)LittleTile.gridSize);
        }
        int offY = this.box.minY / LittleTile.gridSize;
        if (this.box.minY < 0) {
            offY = (int)Math.floor((double)this.box.minY / (double)LittleTile.gridSize);
        }
        int offZ = this.box.minZ / LittleTile.gridSize;
        if (this.box.minZ < 0) {
            offZ = (int)Math.floor((double)this.box.minZ / (double)LittleTile.gridSize);
        }
        int posX = pos.func_177958_n() + offX;
        int posY = pos.func_177956_o() + offY;
        int posZ = pos.func_177952_p() + offZ;
        int spaceX = this.box.minX - offX * LittleTile.gridSize;
        int spaceY = this.box.minY - offY * LittleTile.gridSize;
        int spaceZ = this.box.minZ - offZ * LittleTile.gridSize;
        int i = 0;
        while (spaceX + size.sizeX > i * LittleTile.gridSize) {
            posY = pos.func_177956_o() + offY;
            int j = 0;
            while (spaceY + size.sizeY > j * LittleTile.gridSize) {
                posZ = pos.func_177952_p() + offZ;
                int h = 0;
                while (spaceZ + size.sizeZ > h * LittleTile.gridSize) {
                    PlacePreviewTile tile = this.copy();
                    tile.box.minX = i > 0 ? 0 : spaceX;
                    if (i * LittleTile.gridSize + LittleTile.gridSize > spaceX + size.sizeX) {
                        tile.box.maxX = this.box.maxX - this.box.maxX / LittleTile.gridSize * LittleTile.gridSize;
                        if (this.box.maxX < 0) {
                            tile.box.maxX = LittleTile.gridSize + tile.box.maxX;
                        }
                    } else {
                        tile.box.maxX = LittleTile.gridSize;
                    }
                    tile.box.minY = j > 0 ? 0 : spaceY;
                    if (j * LittleTile.gridSize + LittleTile.gridSize > spaceY + size.sizeY) {
                        tile.box.maxY = this.box.maxY - this.box.maxY / LittleTile.gridSize * LittleTile.gridSize;
                        if (this.box.maxY < 0) {
                            tile.box.maxY = LittleTile.gridSize + tile.box.maxY;
                        }
                    } else {
                        tile.box.maxY = LittleTile.gridSize;
                    }
                    tile.box.minZ = h > 0 ? 0 : spaceZ;
                    if (h * LittleTile.gridSize + LittleTile.gridSize > spaceZ + size.sizeZ) {
                        tile.box.maxZ = this.box.maxZ - this.box.maxZ / LittleTile.gridSize * LittleTile.gridSize;
                        if (this.box.maxZ < 0) {
                            tile.box.maxZ = LittleTile.gridSize + tile.box.maxZ;
                        }
                    } else {
                        tile.box.maxZ = LittleTile.gridSize;
                    }
                    if (tile.box.isValidBox()) {
                        tiles.add((Object)new BlockPos(posX, posY, posZ), (Object)tile);
                    }
                    ++posZ;
                    ++h;
                }
                ++posY;
                ++j;
            }
            ++posX;
            ++i;
        }
        return true;
    }
}

