/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.blocks;

import com.creativemd.creativecore.client.rendering.model.ICustomCachedCreativeRendered;
import com.creativemd.creativecore.client.rendering.model.QuadCache;
import com.creativemd.creativecore.common.block.TileEntityState;
import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.common.utils.RenderCubeObject;
import com.creativemd.littletiles.client.render.RenderingThread;
import com.creativemd.littletiles.common.blocks.ISpecialBlockSelector;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.items.ItemRubberMallet;
import com.creativemd.littletiles.common.packet.LittleBlockPacket;
import com.creativemd.littletiles.common.packet.LittleNeighborUpdatePacket;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.ParticleDigging;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTile
extends BlockContainer
implements ICustomCachedCreativeRendered {
    public static final SoundType SILENT = new SoundType(-1.0f, 1.0f, SoundEvents.field_187835_fT, SoundEvents.field_187902_gb, SoundEvents.field_187845_fY, SoundEvents.field_187843_fX, SoundEvents.field_187841_fW);
    @SideOnly(value=Side.CLIENT)
    public static Minecraft mc;
    public LittleTile sleepingTile = null;
    public static boolean cancelNext;
    public boolean first = true;

    public static TileEntityLittleTiles loadTe(IBlockAccess world, BlockPos pos) {
        if (world == null) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLittleTiles) {
            return (TileEntityLittleTiles)tileEntity;
        }
        return null;
    }

    public static TEResult loadTeAndTile(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            return new TEResult(te, te.getFocusedTile(player));
        }
        return new TEResult(null, null);
    }

    public BlockTile(Material material) {
        super(material);
        this.func_149647_a(CreativeTabs.field_78031_c);
        this.func_149752_b(3.0f);
        this.func_149672_a(SILENT);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new TileEntityState(state, world.func_175625_s(pos));
    }

    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return true;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public EnumFacing getBedDirection(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.sleepingTile != null && this.sleepingTile.isStructureBlock && this.sleepingTile.structure != null) {
            return this.sleepingTile.structure.getBedDirection(state, world, pos);
        }
        return EnumFacing.EAST;
    }

    public void setBedOccupied(IBlockAccess world, BlockPos pos, EntityPlayer player, boolean occupied) {
    }

    public boolean isBed(IBlockState state, IBlockAccess world, BlockPos pos, Entity player) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                if (!tile.isBed(world, pos, (EntityLivingBase)player)) continue;
                return true;
            }
        }
        return false;
    }

    public BlockPos getBedSpawnPosition(IBlockState state, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        int tries = 0;
        EnumFacing enumfacing = EnumFacing.EAST;
        int i = pos.func_177958_n();
        int j = pos.func_177956_o();
        int k = pos.func_177952_p();
        for (int l = 0; l <= 1; ++l) {
            int i1 = i - enumfacing.func_82601_c() * l - 1;
            int j1 = k - enumfacing.func_82599_e() * l - 1;
            int k1 = i1 + 2;
            int l1 = j1 + 2;
            for (int i2 = i1; i2 <= k1; ++i2) {
                for (int j2 = j1; j2 <= l1; ++j2) {
                    BlockPos blockpos = new BlockPos(i2, j, j2);
                    if (!BlockTile.hasRoomForPlayer(world, blockpos)) continue;
                    if (tries <= 0) {
                        return blockpos;
                    }
                    --tries;
                }
            }
        }
        return null;
    }

    protected static boolean hasRoomForPlayer(IBlockAccess worldIn, BlockPos pos) {
        return worldIn.func_180495_p(pos.func_177977_b()).func_185896_q() && !worldIn.func_180495_p(pos).func_185904_a().func_76220_a() && !worldIn.func_180495_p(pos.func_177984_a()).func_185904_a().func_76220_a();
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        AxisAlignedBB bb = entity.func_174813_aQ();
        int mX = MathHelper.func_76128_c((double)bb.field_72340_a);
        int mY = MathHelper.func_76128_c((double)bb.field_72338_b);
        int mZ = MathHelper.func_76128_c((double)bb.field_72339_c);
        int y2 = mY;
        while ((double)y2 < bb.field_72337_e) {
            int x2 = mX;
            while ((double)x2 < bb.field_72336_d) {
                int z2 = mZ;
                while ((double)z2 < bb.field_72334_f) {
                    TileEntity te = world.func_175625_s(new BlockPos(x2, y2, z2));
                    if (te instanceof TileEntityLittleTiles) {
                        TileEntityLittleTiles littleTE = (TileEntityLittleTiles)te;
                        for (LittleTile tile : littleTE.getTiles()) {
                            if (!tile.isLadder()) continue;
                            for (int j = 0; j < tile.boundingBoxes.size(); ++j) {
                                LittleTileBox box = tile.boundingBoxes.get(j).copy();
                                box.addOffset(new LittleTileVec(x2 * LittleTile.gridSize, y2 * LittleTile.gridSize, z2 * LittleTile.gridSize));
                                double expand = 1.0E-4;
                                if (!bb.func_72326_a(box.getBox().func_72314_b(expand, expand, expand))) continue;
                                return true;
                            }
                        }
                    }
                    ++z2;
                }
                ++x2;
            }
            ++y2;
        }
        return false;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        return 0.1f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)worldIn, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete()) {
            LittleTileBox box;
            ItemStack stack = BlockTile.mc.field_71439_g.func_184586_b(EnumHand.MAIN_HAND);
            if (stack != null && stack.func_77973_b() instanceof ISpecialBlockSelector && (box = ((ISpecialBlockSelector)stack.func_77973_b()).getBox(result.te, result.tile, pos, (EntityPlayer)BlockTile.mc.field_71439_g, result.te.getMoving((EntityPlayer)BlockTile.mc.field_71439_g))) != null) {
                return box.getBox().func_186670_a(pos);
            }
            return result.tile.getSelectedBox().func_186670_a(pos);
        }
        return new AxisAlignedBB(pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> list, @Nullable Entity entityIn) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                for (int i = 0; i < tile.boundingBoxes.size(); ++i) {
                    AxisAlignedBB box = tile.boundingBoxes.get(i).getBox();
                    BlockTile.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, list, (AxisAlignedBB)box);
                }
            }
        }
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null && te.getTiles().size() == 0) {
            super.func_180663_b(world, pos, state);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                tile.randomDisplayTick(stateIn, worldIn, pos, rand);
            }
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (heldItem != null && heldItem.func_77973_b() instanceof ItemRubberMallet) {
            return false;
        }
        if (worldIn.field_72995_K) {
            return this.onBlockActivatedClient(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        if (cancelNext) {
            cancelNext = false;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean onBlockActivatedClient(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)worldIn, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete()) {
            if (result.tile.onBlockActivated(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ)) {
                if (worldIn.field_72995_K) {
                    PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(pos, playerIn, 0));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List items) {
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        int light = 0;
        if (!this.first) {
            return 0;
        }
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                this.first = false;
                int tempLight = tile.getLightValue(state, world, pos);
                this.first = true;
                if (tempLight <= light) continue;
                light = tempLight;
            }
        }
        return light;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            LittleTileBox box = new LittleTileBox(0, 0, 0, 1, LittleTile.gridSize, LittleTile.gridSize);
            box.rotateBox(side.func_176734_d());
            return te.isBoxFilled(box);
        }
        return false;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            this.removedByPlayerClient(state, world, pos, player, willHarvest);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void removedByPlayerClient(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, player);
        if (result.isComplete()) {
            LittleTileBox box = null;
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            if (stack != null && stack.func_77973_b() instanceof ISpecialBlockSelector) {
                box = ((ISpecialBlockSelector)stack.func_77973_b()).getBox(result.te, result.tile, pos, player, result.te.getMoving(player));
            }
            if (box == null) {
                result.tile.destroy();
                result.te.updateRender();
            }
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleBlockPacket(pos, player, 1));
        }
    }

    public boolean func_176200_f(IBlockAccess world, BlockPos pos) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            return te.getTiles().size() == 0;
        }
        return true;
    }

    public ArrayList<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                stacks.addAll(tile.getDrops());
            }
        }
        return stacks;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ArrayList<ItemStack> drops;
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete() && (drops = result.tile.getDrops()).size() > 0) {
            return drops.get(0);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(IBlockState oldstate, World worldObj, RayTraceResult target, ParticleManager manager) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)worldObj, target.func_178782_a(), (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete() && result.tile instanceof LittleTileBlock) {
            IBlockState state = ((LittleTileBlock)result.tile).getBlockState();
            BlockPos pos = target.func_178782_a();
            int i = pos.func_177958_n();
            int j = pos.func_177956_o();
            int k = pos.func_177952_p();
            float f = 0.1f;
            AxisAlignedBB axisalignedbb = result.tile.getSelectedBox();
            double d0 = (double)i + worldObj.field_73012_v.nextDouble() * (axisalignedbb.field_72336_d - axisalignedbb.field_72340_a - (double)0.2f) + (double)0.1f + axisalignedbb.field_72340_a;
            double d1 = (double)j + worldObj.field_73012_v.nextDouble() * (axisalignedbb.field_72337_e - axisalignedbb.field_72338_b - (double)0.2f) + (double)0.1f + axisalignedbb.field_72338_b;
            double d2 = (double)k + worldObj.field_73012_v.nextDouble() * (axisalignedbb.field_72334_f - axisalignedbb.field_72339_c - (double)0.2f) + (double)0.1f + axisalignedbb.field_72339_c;
            EnumFacing side = target.field_178784_b;
            if (side == EnumFacing.DOWN) {
                d1 = (double)j + axisalignedbb.field_72338_b - (double)0.1f;
            }
            if (side == EnumFacing.UP) {
                d1 = (double)j + axisalignedbb.field_72337_e + (double)0.1f;
            }
            if (side == EnumFacing.NORTH) {
                d2 = (double)k + axisalignedbb.field_72339_c - (double)0.1f;
            }
            if (side == EnumFacing.SOUTH) {
                d2 = (double)k + axisalignedbb.field_72334_f + (double)0.1f;
            }
            if (side == EnumFacing.WEST) {
                d0 = (double)i + axisalignedbb.field_72340_a - (double)0.1f;
            }
            if (side == EnumFacing.EAST) {
                d0 = (double)i + axisalignedbb.field_72336_d + (double)0.1f;
            }
            manager.func_78873_a(((ParticleDigging)manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)state)})).func_174846_a(pos).func_70543_e(0.2f).func_70541_f(0.6f));
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World world, BlockPos pos, ParticleManager manager) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result.isComplete() && result.tile instanceof LittleTileBlock) {
            IBlockState state = ((LittleTileBlock)result.tile).getBlockState();
            int i = 4;
            for (int j = 0; j < 1; ++j) {
                for (int k = 0; k < 1; ++k) {
                    for (int l = 0; l < 1; ++l) {
                        double d0 = (double)pos.func_177958_n() + ((double)j + 0.5) / 4.0;
                        double d1 = (double)pos.func_177956_o() + ((double)k + 0.5) / 4.0;
                        double d2 = (double)pos.func_177952_p() + ((double)l + 0.5) / 4.0;
                        manager.func_178927_a(EnumParticleTypes.BLOCK_CRACK.func_179348_c(), d0, d1, d2, d0 - (double)pos.func_177958_n() - 0.5, d1 - (double)pos.func_177956_o() - 0.5, d2 - (double)pos.func_177952_p() - 0.5, new int[]{Block.func_176210_f((IBlockState)state)});
                    }
                }
            }
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public SoundType getSoundTypeClient(IBlockState state, World world, BlockPos pos) {
        TEResult result = BlockTile.loadTeAndTile((IBlockAccess)world, pos, (EntityPlayer)BlockTile.mc.field_71439_g);
        if (result != null && result.tile != null) {
            return result.tile.getSound();
        }
        return null;
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        TileEntityLittleTiles te;
        if (entity == null) {
            return SILENT;
        }
        SoundType sound = null;
        if (entity instanceof EntityPlayer && world.field_72995_K) {
            sound = this.getSoundTypeClient(state, world, pos);
        }
        if (sound == null && (te = BlockTile.loadTe((IBlockAccess)world, pos)) != null) {
            int heighest = 0;
            LittleTile heighestTile = null;
            for (LittleTile tile : te.getTiles()) {
                for (int i = 0; i < tile.boundingBoxes.size(); ++i) {
                    if (tile.boundingBoxes.get((int)i).maxY <= heighest) continue;
                    heighest = tile.boundingBoxes.get((int)i).maxY;
                    heighestTile = tile;
                }
            }
            if (heighestTile != null) {
                return heighestTile.getSound();
            }
        }
        return sound;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (int i = 0; i < 6; ++i) {
            if (this.isSideSolid(state, world, pos, EnumFacing.func_82600_a((int)i))) continue;
            return false;
        }
        return true;
    }

    public float getEnchantPowerBonus(World world, BlockPos pos) {
        float bonus = 0.0f;
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null) {
            for (LittleTile tile : te.getTiles()) {
                bonus = (float)((double)bonus + (double)tile.getEnchantPowerBonus(world, pos) * tile.getPercentVolume());
            }
        }
        return bonus;
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null) {
            if (worldIn.field_72995_K) {
                te.onNeighBorChangedClient();
            } else {
                PacketHandler.sendPacketToNearPlayers((World)worldIn, (CreativeCorePacket)new LittleNeighborUpdatePacket(pos), (int)100, (BlockPos)pos);
            }
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos pos, BlockPos neighbor) {
        TileEntityLittleTiles te = BlockTile.loadTe(world, pos);
        if (te != null && te.func_145831_w().field_72995_K) {
            te.onNeighBorChangedClient();
        }
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World worldIn, BlockPos pos, Vec3d start, Vec3d end) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)worldIn, pos);
        if (te != null) {
            RayTraceResult moving = null;
            for (LittleTile tile : te.getTiles()) {
                for (int i = 0; i < tile.boundingBoxes.size(); ++i) {
                    RayTraceResult tempMoving = tile.boundingBoxes.get(i).getBox().func_186670_a(pos).func_72327_a(start, end);
                    if (tempMoving == null || moving != null && !(moving.field_72307_f.func_72438_d(start) > tempMoving.field_72307_f.func_72438_d(start))) continue;
                    moving = tempMoving;
                }
            }
            if (moving != null) {
                return new RayTraceResult(moving.field_72307_f, moving.field_178784_b, pos);
            }
        }
        return null;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityLittleTiles();
    }

    @SideOnly(value=Side.CLIENT)
    private TileEntityLittleTiles checkforTileEntity(World world, EnumFacing facing, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(facing));
        if (tileEntity instanceof TileEntityLittleTiles) {
            return (TileEntityLittleTiles)tileEntity;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private boolean checkforNeighbor(World world, EnumFacing facing, BlockPos pos) {
        BlockPos newPos = pos.func_177972_a(facing);
        IBlockState state = world.func_180495_p(newPos);
        return !state.doesSideBlockRendering((IBlockAccess)world, newPos, facing.func_176734_d());
    }

    @SideOnly(value=Side.CLIENT)
    private void updateRenderer(TileEntityLittleTiles tileEntity, EnumFacing facing, HashMap<EnumFacing, Boolean> neighbors, HashMap<EnumFacing, TileEntityLittleTiles> neighborsTiles, RenderCubeObject cube, LittleTileBox box) {
        Boolean shouldRender = neighbors.get(facing);
        if (shouldRender == null) {
            shouldRender = this.checkforNeighbor(tileEntity.func_145831_w(), facing, tileEntity.func_174877_v());
            neighbors.put(facing, shouldRender);
        }
        if (shouldRender == Boolean.TRUE) {
            TileEntityLittleTiles otherTile = null;
            if (!neighborsTiles.containsKey(facing)) {
                otherTile = this.checkforTileEntity(tileEntity.func_145831_w(), facing, tileEntity.func_174877_v());
                neighborsTiles.put(facing, otherTile);
            } else {
                otherTile = neighborsTiles.get(facing);
            }
            if (otherTile != null) {
                shouldRender = otherTile.shouldSideBeRendered(facing.func_176734_d(), box.createInsideBlockBox(facing), (LittleTile)cube.customData);
            }
        }
        cube.setSideRender(facing, shouldRender != false ? RenderCubeObject.EnumSideRender.OUTSIDE_RENDERED : RenderCubeObject.EnumSideRender.OUTSIDE_NOT_RENDERD);
    }

    @SideOnly(value=Side.CLIENT)
    public List<RenderCubeObject> getRenderingCubes(IBlockState state, TileEntity te, ItemStack stack) {
        ArrayList<RenderCubeObject> cubes = new ArrayList<RenderCubeObject>();
        if (te instanceof TileEntityLittleTiles) {
            List<RenderCubeObject> cachedCubes;
            BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
            HashMap<EnumFacing, Boolean> neighbors = new HashMap<EnumFacing, Boolean>();
            HashMap<EnumFacing, TileEntityLittleTiles> neighborsTiles = new HashMap<EnumFacing, TileEntityLittleTiles>();
            TileEntityLittleTiles tileEntity = (TileEntityLittleTiles)te;
            HashMap<BlockRenderLayer, List<RenderCubeObject>> cached = tileEntity.cachedCubes;
            if (cached != null && (cachedCubes = cached.get(layer)) != null) {
                if (tileEntity.hasNeighborChanged) {
                    for (List<RenderCubeObject> renderCubes : cached.values()) {
                        for (int i = 0; i < renderCubes.size(); ++i) {
                            RenderCubeObject cube = renderCubes.get(i);
                            for (int k = 0; k < EnumFacing.field_82609_l.length; ++k) {
                                EnumFacing facing = EnumFacing.field_82609_l[k];
                                if (!cube.getSidedRendererType((EnumFacing)facing).outside) continue;
                                LittleTileBox box = new LittleTileBox((CubeObject)cube).getSideOfBox(facing);
                                this.updateRenderer(tileEntity, facing, neighbors, neighborsTiles, cube, box);
                            }
                        }
                    }
                    tileEntity.hasNeighborChanged = false;
                }
                return cachedCubes;
            }
            for (LittleTile tile : tileEntity.getTiles()) {
                if (!tile.shouldBeRenderedInLayer(layer)) continue;
                ArrayList<RenderCubeObject> tileCubes = tile.getRenderingCubes();
                boolean canUseBoundingBoxes = tile.boundingBoxes.size() == tileCubes.size();
                for (int j = 0; j < tileCubes.size(); ++j) {
                    RenderCubeObject cube = tileCubes.get(j);
                    for (int k = 0; k < EnumFacing.field_82609_l.length; ++k) {
                        EnumFacing facing = EnumFacing.field_82609_l[k];
                        LittleTileBox box = null;
                        box = !canUseBoundingBoxes ? new LittleTileBox((CubeObject)cube).getSideOfBox(facing) : tile.boundingBoxes.get(j).copy().getSideOfBox(facing);
                        if (box.isBoxInsideBlock()) {
                            cube.setSideRender(facing, ((TileEntityLittleTiles)te).shouldSideBeRendered(facing, box, tile) ? RenderCubeObject.EnumSideRender.INSIDE_RENDERED : RenderCubeObject.EnumSideRender.INSIDE_NOT_RENDERED);
                        } else {
                            this.updateRenderer(tileEntity, facing, neighbors, neighborsTiles, cube, box);
                        }
                        cube.customData = tile;
                    }
                }
                cubes.addAll(tileCubes);
            }
            if (tileEntity.cachedCubes == null) {
                tileEntity.cachedCubes = new HashMap();
            }
            tileEntity.cachedCubes.put(layer, cubes);
        } else if (stack != null) {
            return ItemBlockTiles.getItemRenderingCubes(stack);
        }
        return cubes;
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getCachedModel(EnumFacing facing, BlockRenderLayer layer, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        if (te instanceof TileEntityLittleTiles) {
            TileEntityLittleTiles littleTe = (TileEntityLittleTiles)te;
            if (threaded && littleTe.cachedQuads == null) {
                if (!littleTe.isRendering) {
                    RenderingThread.addCoordToUpdate(littleTe, state);
                }
                littleTe.isRendering = true;
                return new ArrayList<BakedQuad>();
            }
            if (littleTe.cachedQuads == null) {
                return null;
            }
            HashMap<EnumFacing, List<BakedQuad>> quads = littleTe.cachedQuads.get(layer);
            if (quads != null) {
                if (layer == BlockRenderLayer.SOLID) {
                    littleTe.updateQuadCache();
                }
                return quads.get(facing);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCachedModel(EnumFacing facing, BlockRenderLayer layer, List<BakedQuad> cachedQuads, IBlockState state, TileEntity te, ItemStack stack, boolean threaded) {
        if (te instanceof TileEntityLittleTiles) {
            HashMap<Object, List<Object>> quads;
            TileEntityLittleTiles littleTe = (TileEntityLittleTiles)te;
            if (littleTe.cachedQuads == null) {
                littleTe.cachedQuads = new HashMap();
            }
            if ((quads = littleTe.cachedQuads.get(layer)) == null) {
                quads = new HashMap();
                littleTe.cachedQuads.put(layer, quads);
            }
            quads.put(facing, cachedQuads);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public QuadCache[] getCustomCachedQuads(BlockRenderLayer layer, EnumFacing facing, TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityLittleTiles) {
            return ((TileEntityLittleTiles)te).getQuadCache(layer, facing);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void saveCachedQuads(QuadCache[] quads, BlockRenderLayer layer, EnumFacing facing, TileEntity te, ItemStack stack) {
        if (te instanceof TileEntityLittleTiles) {
            ((TileEntityLittleTiles)te).setQuadCache(quads, layer, facing);
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        TileEntityLittleTiles te = BlockTile.loadTe((IBlockAccess)world, pos);
        if (te != null && !world.field_72995_K) {
            float size = ((Float)ReflectionHelper.getPrivateValue(Explosion.class, (Object)explosion, (String[])new String[]{"explosionSize", "field_77280_f"})).floatValue();
            Vec3d center = explosion.getPosition();
            ArrayList<LittleTile> removeTiles = new ArrayList<LittleTile>();
            for (LittleTile tile : te.getTiles()) {
                if (tile.boundingBoxes.size() <= 0 || tile.isStructureBlock) continue;
                LittleTileVec vec = tile.boundingBoxes.get(0).getCenter();
                Vec3d newVec = new Vec3d((Vec3i)pos);
                newVec = newVec.func_72441_c(vec.getPosX(), vec.getPosY(), vec.getPosZ());
                int explosionStrength = (int)(50.0 / center.func_72438_d(newVec) * (double)size);
                double random = Math.random() * (double)explosionStrength;
                if (!(random > (double)tile.getExplosionResistance())) continue;
                removeTiles.add(tile);
            }
            for (int i = 0; i < removeTiles.size(); ++i) {
                te.removeTile((LittleTile)removeTiles.get(i));
            }
            te.func_73660_a();
        }
    }

    static {
        cancelNext = false;
    }

    public static class TEResult {
        public final TileEntityLittleTiles te;
        public final LittleTile tile;

        public TEResult(TileEntityLittleTiles te, LittleTile tile) {
            this.te = te;
            this.tile = tile;
        }

        public boolean isComplete() {
            return this.te != null && this.tile != null;
        }
    }
}

