/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.utils.TickUtils;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.blocks.ISpecialBlockSelector;
import com.creativemd.littletiles.common.gui.SubContainerHammer;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleBlockVanillaPacket
extends CreativeCorePacket {
    public BlockPos blockPos;
    public Vec3d pos;
    public Vec3d look;

    public LittleBlockVanillaPacket() {
    }

    public LittleBlockVanillaPacket(BlockPos blockPos, EntityPlayer player) {
        this.blockPos = blockPos;
        this.pos = player.func_174824_e(TickUtils.getPartialTickTime());
        double d0 = player.field_71075_bZ.field_75098_d ? 5.0 : 4.5;
        Vec3d look = player.func_70676_i(TickUtils.getPartialTickTime());
        this.look = this.pos.func_72441_c(look.field_72450_a * d0, look.field_72448_b * d0, look.field_72449_c * d0);
    }

    public void writeBytes(ByteBuf buf) {
        LittleBlockVanillaPacket.writePos((ByteBuf)buf, (BlockPos)this.blockPos);
        LittleBlockVanillaPacket.writeVec3((Vec3d)this.pos, (ByteBuf)buf);
        LittleBlockVanillaPacket.writeVec3((Vec3d)this.look, (ByteBuf)buf);
    }

    public void readBytes(ByteBuf buf) {
        this.blockPos = LittleBlockVanillaPacket.readPos((ByteBuf)buf);
        this.pos = LittleBlockVanillaPacket.readVec3((ByteBuf)buf);
        this.look = LittleBlockVanillaPacket.readVec3((ByteBuf)buf);
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        World world = player.field_70170_p;
        IBlockState state = world.func_180495_p(this.blockPos);
        ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
        if (SubContainerHammer.isBlockValid(state.func_177230_c()) && stack != null && stack.func_77973_b() instanceof ISpecialBlockSelector) {
            RayTraceResult trace = new AxisAlignedBB(this.blockPos).func_72327_a(this.pos, this.look);
            LittleTileBox box = ((ISpecialBlockSelector)stack.func_77973_b()).getBox(world, this.blockPos, state, player, trace);
            world.func_175656_a(this.blockPos, LittleTiles.blockTile.func_176223_P());
            TileEntityLittleTiles te = (TileEntityLittleTiles)world.func_175625_s(this.blockPos);
            LittleTileBlock tile = new LittleTileBlock(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
            tile.boundingBoxes.add(new LittleTileBox(0, 0, 0, LittleTile.maxPos, LittleTile.maxPos, LittleTile.maxPos));
            tile.te = te;
            ((LittleTile)tile).place();
            world.func_184133_a((EntityPlayer)null, this.blockPos, ((LittleTile)tile).getSound().func_185841_e(), SoundCategory.BLOCKS, (((LittleTile)tile).getSound().func_185843_a() + 1.0f) / 2.0f, ((LittleTile)tile).getSound().func_185847_b() * 0.8f);
            te.removeBoxFromTile(tile, box);
            if (!player.field_71075_bZ.field_75098_d) {
                tile.boundingBoxes.clear();
                tile.boundingBoxes.add(box.copy());
                WorldUtils.dropItem((EntityPlayer)player, tile.getDrops());
            }
        }
    }
}

