/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.blocks.ILittleTile;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;

public class LittleRotatePacket
extends CreativeCorePacket {
    public EnumFacing direction;

    public LittleRotatePacket() {
    }

    public LittleRotatePacket(EnumFacing direction) {
        this.direction = direction;
    }

    public void writeBytes(ByteBuf buf) {
        LittleRotatePacket.writeFacing((ByteBuf)buf, (EnumFacing)this.direction);
    }

    public void readBytes(ByteBuf buf) {
        this.direction = LittleRotatePacket.readFacing((ByteBuf)buf);
    }

    public void executeClient(EntityPlayer player) {
        this.execute(player);
    }

    public void execute(EntityPlayer player) {
        if (PlacementHelper.isLittleBlock(player.func_184586_b(EnumHand.MAIN_HAND))) {
            ItemStack stack = player.func_184586_b(EnumHand.MAIN_HAND);
            ILittleTile itile = null;
            if (stack.func_77973_b() instanceof ILittleTile) {
                itile = (ILittleTile)stack.func_77973_b();
            } else if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof ILittleTile) {
                itile = (ILittleTile)Block.func_149634_a((Item)stack.func_77973_b());
            }
            if (itile != null) {
                itile.rotateLittlePreview(stack, this.direction);
                LittleStructure structure = itile.getLittleStructure(stack);
                if (structure != null) {
                    structure.onRotate(player.field_70170_p, player, stack, this.direction);
                    NBTTagCompound nbt = new NBTTagCompound();
                    structure.writeToNBT(nbt);
                    stack.func_77978_p().func_74782_a("structure", (NBTBase)nbt);
                }
            }
        }
    }

    public void executeServer(EntityPlayer player) {
        this.execute(player);
    }
}

