/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.utils.HashMapList;
import com.creativemd.creativecore.common.utils.WorldUtils;
import com.creativemd.creativecore.gui.container.SubGui;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.structure.LittleBed;
import com.creativemd.littletiles.common.structure.LittleChair;
import com.creativemd.littletiles.common.structure.LittleDoor;
import com.creativemd.littletiles.common.structure.LittleFixedStructure;
import com.creativemd.littletiles.common.structure.LittleLadder;
import com.creativemd.littletiles.common.structure.LittleStorage;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTilePreview;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import com.creativemd.littletiles.common.utils.small.LittleTileCoord;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import com.creativemd.littletiles.utils.PlacePreviewTile;
import java.util.ArrayList;
import java.util.HashMap;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class LittleStructure {
    private static HashMap<String, LittleStructureEntry> structures = new HashMap();
    private LittleTile mainTile;
    private ArrayList<LittleTile> tiles = null;
    public ArrayList<LittleTileCoord> tilesToLoad = null;

    public static ArrayList<String> getStructureNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : structures.keySet()) {
            result.add(id);
        }
        return result;
    }

    public static void registerLittleStructure(String id, LittleStructure structure) {
        LittleStructure.registerLittleStructure(id, new LittleStructureEntry(structure.getClass(), structure));
    }

    public static void registerLittleStructure(String id, LittleStructureEntry entry) {
        if (structures.containsKey(id)) {
            System.out.println("ID is already taken! id=" + id);
        } else if (structures.containsValue(entry)) {
            System.out.println("Already registered class=" + entry);
        } else {
            structures.put(id, entry);
        }
    }

    public static String getIDByClass(Class<? extends LittleStructure> classStructure) {
        for (String id : structures.keySet()) {
            if (!classStructure.equals(LittleStructure.structures.get((Object)id).structureClass)) continue;
            return id;
        }
        return "";
    }

    public static Class<? extends LittleStructure> getClassByID(String id) {
        LittleStructureEntry entry = structures.get(id);
        if (entry != null) {
            return entry.structureClass;
        }
        return null;
    }

    public static LittleStructureEntry getEntryByID(String id) {
        return structures.get(id);
    }

    public static void initStructures() {
        LittleStructure.registerLittleStructure("fixed", new LittleFixedStructure());
        LittleStructure.registerLittleStructure("chair", new LittleChair());
        LittleStructure.registerLittleStructure("door", new LittleDoor());
        LittleStructure.registerLittleStructure("ladder", new LittleLadder());
        LittleStructure.registerLittleStructure("bed", new LittleBed());
        LittleStructure.registerLittleStructure("storage", new LittleStorage());
    }

    public static LittleStructure createAndLoadStructure(NBTTagCompound nbt, LittleTile mainTile) {
        Class<? extends LittleStructure> classStructure;
        if (nbt == null) {
            return null;
        }
        String id = nbt.func_74779_i("id");
        LittleStructureEntry entry = LittleStructure.getEntryByID(id);
        if (entry != null && (classStructure = entry.structureClass) != null) {
            LittleStructure structure = null;
            try {
                structure = classStructure.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                System.out.println("Found invalid structureID=" + id);
            }
            structure.mainTile = mainTile;
            structure.loadFromNBT(nbt);
            return structure;
        }
        return null;
    }

    public void setMainTile(LittleTile tile) {
        this.mainTile = tile;
        this.mainTile.isMainBlock = true;
        this.mainTile.updateCorner();
        this.mainTile.coord = null;
        if (!this.tiles.contains(tile)) {
            this.tiles.add(tile);
        }
        for (int i = 0; i < this.tiles.size(); ++i) {
            LittleTile stTile = this.tiles.get(i);
            if (stTile == this.mainTile) continue;
            stTile.te.func_70296_d();
            stTile.isMainBlock = false;
            stTile.coord = new LittleTileCoord((TileEntity)stTile.te, this.mainTile.te.func_174877_v(), this.mainTile.cornerVec);
        }
    }

    public void moveStructure(EnumFacing facing) {
    }

    public void combineTiles() {
        ArrayList<TileEntityLittleTiles> tes = new ArrayList<TileEntityLittleTiles>();
        for (int i = 0; i < this.tiles.size(); ++i) {
            if (tes.contains(this.tiles.get(i))) continue;
            this.tiles.get((int)i).te.combineTiles(this);
            tes.add(this.tiles.get((int)i).te);
        }
    }

    public void selectMainTile() {
        if (this.tiles.size() > 0) {
            this.setMainTile(this.tiles.get(0));
        }
    }

    public LittleTile getMainTile() {
        return this.mainTile;
    }

    public void setTiles(ArrayList<LittleTile> tiles) {
        this.tiles = tiles;
    }

    public ArrayList<LittleTile> getTiles() {
        if (this.tiles == null && !this.loadTiles()) {
            ArrayList<LittleTile> tiles = new ArrayList<LittleTile>();
            return tiles;
        }
        return this.tiles;
    }

    public boolean hasLoaded() {
        this.loadTiles();
        return this.tilesToLoad == null || this.tilesToLoad.size() == 0;
    }

    public boolean loadTiles() {
        if (this.mainTile != null) {
            if (this.tiles == null) {
                this.tiles = new ArrayList();
                this.tiles.add(this.mainTile);
            }
            if (this.tilesToLoad == null) {
                return true;
            }
            int i = 0;
            while (i < this.tilesToLoad.size()) {
                if (this.checkForTile(this.mainTile.te.func_145831_w(), this.tilesToLoad.get(i))) {
                    this.tilesToLoad.remove(i);
                    continue;
                }
                ++i;
            }
            if (this.tilesToLoad.size() == 0) {
                this.tilesToLoad = null;
            }
            return true;
        }
        return false;
    }

    public void loadFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("count")) {
            this.tilesToLoad = new ArrayList();
            int count = nbt.func_74762_e("count");
            for (int i = 0; i < count; ++i) {
                LittleTileCoord coord = null;
                if (nbt.func_74764_b("i" + i + "coX")) {
                    LittleTile.LittleTilePosition pos = new LittleTile.LittleTilePosition("i" + i, nbt);
                    coord = new LittleTileCoord((TileEntity)this.mainTile.te, pos.coord, pos.position);
                } else {
                    coord = new LittleTileCoord("i" + i, nbt);
                }
                this.tilesToLoad.add(coord);
            }
        }
        this.loadFromNBTExtra(nbt);
    }

    protected abstract void loadFromNBTExtra(NBTTagCompound var1);

    public void writeToNBTPreview(NBTTagCompound nbt, BlockPos newCenter) {
        nbt.func_74778_a("id", this.getIDOfStructure());
        this.writeToNBTExtra(nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("id", this.getIDOfStructure());
        if (this.tiles != null) {
            nbt.func_74768_a("count", this.tiles.size());
            for (int i = 0; i < this.tiles.size(); ++i) {
                if (!this.tiles.get((int)i).isStructureBlock) continue;
                this.tiles.get(i).updateCorner();
                new LittleTileCoord((TileEntity)this.mainTile.te, this.tiles.get((int)i).te.func_174877_v(), this.tiles.get((int)i).cornerVec.copy()).writeToNBT("i" + i, nbt);
            }
        }
        if (this.tilesToLoad != null) {
            int start = nbt.func_74762_e("count");
            nbt.func_74768_a("count", start + this.tilesToLoad.size());
            for (int i = 0; i < this.tilesToLoad.size(); ++i) {
                this.tilesToLoad.get(i).writeToNBT("i" + (i + start), nbt);
            }
        }
        this.writeToNBTExtra(nbt);
    }

    protected abstract void writeToNBTExtra(NBTTagCompound var1);

    public boolean checkForTile(World world, LittleTileCoord pos) {
        LittleTile tile;
        TileEntity tileEntity;
        BlockPos coord = pos.getAbsolutePosition((TileEntity)this.mainTile.te);
        Chunk chunk = world.func_175726_f(coord);
        if (WorldUtils.checkIfChunkExists((Chunk)chunk) && (tileEntity = world.func_175625_s(coord)) instanceof TileEntityLittleTiles && (tile = ((TileEntityLittleTiles)tileEntity).getTile(pos.position)) != null && tile.isStructureBlock) {
            if (!this.tiles.contains(tile)) {
                this.tiles.add(tile);
            }
            tile.structure = this;
            return true;
        }
        return false;
    }

    public ArrayList<PlacePreviewTile> getSpecialTiles() {
        return new ArrayList<PlacePreviewTile>();
    }

    public void onLittleTileDestory() {
        ArrayList<LittleTile> tiles = this.getTiles();
        for (int i = 0; i < tiles.size(); ++i) {
            tiles.get((int)i).te.removeTile(tiles.get(i));
        }
    }

    public ItemStack getStructureDrop() {
        if (this.hasLoaded()) {
            BlockPos pos = this.getMainTile().te.func_174877_v();
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            for (int i = 0; i < this.tiles.size(); ++i) {
                x = Math.min(x, this.tiles.get((int)i).te.func_174877_v().func_177958_n());
                y = Math.min(y, this.tiles.get((int)i).te.func_174877_v().func_177956_o());
                z = Math.min(z, this.tiles.get((int)i).te.func_174877_v().func_177952_p());
            }
            pos = new BlockPos(x, y, z);
            ItemStack stack = new ItemStack(LittleTiles.multiTiles);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74768_a("tiles", this.tiles.size());
            for (int i = 0; i < this.tiles.size(); ++i) {
                NBTTagCompound tileNBT = new NBTTagCompound();
                LittleTilePreview preview = this.tiles.get(i).getPreviewTile();
                preview.box.addOffset(new LittleTileVec((Vec3i)this.tiles.get((int)i).te.func_174877_v().func_177973_b((Vec3i)pos)));
                preview.writeToNBT(tileNBT);
                nbt.func_74782_a("tile" + i, (NBTBase)tileNBT);
            }
            NBTTagCompound structureNBT = new NBTTagCompound();
            this.writeToNBTPreview(structureNBT, pos);
            nbt.func_74782_a("structure", (NBTBase)structureNBT);
            stack.func_77982_d(nbt);
            return stack;
        }
        return null;
    }

    public boolean onBlockActivated(World worldIn, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public HashMapList<BlockPos, LittleTile> getTilesSortedPerBlock() {
        HashMapList coords = new HashMapList();
        ArrayList<LittleTile> tiles = this.getTiles();
        for (int i = 0; i < tiles.size(); ++i) {
            coords.add((Object)tiles.get((int)i).te.func_174877_v(), (Object)tiles.get(i));
        }
        return coords;
    }

    public void onFlip(World world, EntityPlayer player, ItemStack stack, EnumFacing direction) {
    }

    public void onRotate(World world, EntityPlayer player, ItemStack stack, EnumFacing direction) {
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void createControls(SubGui var1, LittleStructure var2);

    @SideOnly(value=Side.CLIENT)
    public abstract LittleStructure parseStructure(SubGui var1);

    public LittleTileSize getSize() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        HashMapList<BlockPos, LittleTile> coords = this.getTilesSortedPerBlock();
        if (coords.sizeOfValues() == 0) {
            return null;
        }
        for (BlockPos coord : coords.getKeys()) {
            ArrayList values = coords.getValues((Object)coord);
            for (int j = 0; j < values.size(); ++j) {
                for (int h = 0; h < ((LittleTile)values.get((int)j)).boundingBoxes.size(); ++h) {
                    LittleTileBox box = ((LittleTile)values.get((int)j)).boundingBoxes.get(h);
                    minX = Math.min(minX, coord.func_177958_n() * LittleTile.gridSize + box.minX);
                    minY = Math.min(minY, coord.func_177956_o() * LittleTile.gridSize + box.minY);
                    minZ = Math.min(minZ, coord.func_177952_p() * LittleTile.gridSize + box.minZ);
                    maxX = Math.max(maxX, coord.func_177958_n() * LittleTile.gridSize + box.maxX);
                    maxY = Math.max(maxY, coord.func_177956_o() * LittleTile.gridSize + box.maxY);
                    maxZ = Math.max(maxZ, coord.func_177952_p() * LittleTile.gridSize + box.maxZ);
                }
            }
        }
        return new LittleTileBox(minX, minY, minZ, maxX, maxY, maxZ).getSize();
    }

    public LittleTileVec getHighestCenterPoint() {
        int minYPos = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxYPos = Integer.MIN_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        HashMapList<BlockPos, LittleTile> coords = this.getTilesSortedPerBlock();
        if (coords.sizeOfValues() == 0) {
            return null;
        }
        for (BlockPos coord : coords.getKeys()) {
            ArrayList values = coords.getValues((Object)coord);
            for (int j = 0; j < values.size(); ++j) {
                for (int h = 0; h < ((LittleTile)values.get((int)j)).boundingBoxes.size(); ++h) {
                    LittleTileBox box = ((LittleTile)values.get((int)j)).boundingBoxes.get(h);
                    minX = Math.min(minX, coord.func_177958_n() * LittleTile.gridSize + box.minX);
                    minY = Math.min(minY, coord.func_177956_o() * LittleTile.gridSize + box.minY);
                    minZ = Math.min(minZ, coord.func_177952_p() * LittleTile.gridSize + box.minZ);
                    maxX = Math.max(maxX, coord.func_177958_n() * LittleTile.gridSize + box.maxX);
                    maxY = Math.max(maxY, coord.func_177956_o() * LittleTile.gridSize + box.maxY);
                    maxZ = Math.max(maxZ, coord.func_177952_p() * LittleTile.gridSize + box.maxZ);
                }
                minYPos = Math.min(minYPos, coord.func_177956_o());
                maxYPos = Math.max(maxYPos, coord.func_177956_o());
            }
        }
        int centerX = (int)Math.floor((double)(minX + maxX) / (double)LittleTile.gridSize / 2.0);
        int centerY = (int)Math.floor((double)(minY + maxY) / (double)LittleTile.gridSize / 2.0);
        int centerZ = (int)Math.floor((double)(minZ + maxZ) / (double)LittleTile.gridSize / 2.0);
        int centerTileX = (int)(Math.floor(minX + maxX) / 2.0) - centerX * LittleTile.gridSize;
        int centerTileY = (int)(Math.floor(minY + maxY) / 2.0) - centerY * LittleTile.gridSize;
        int centerTileZ = (int)(Math.floor(minZ + maxZ) / 2.0) - centerZ * LittleTile.gridSize;
        LittleTileVec position = new LittleTileVec((minX + maxX) / 2, minYPos * LittleTile.gridSize, (minZ + maxZ) / 2);
        for (int y = minYPos; y <= maxYPos; ++y) {
            ArrayList tilesInCenter = coords.getValues((Object)new BlockPos(centerX, y, centerZ));
            if (tilesInCenter == null) continue;
            LittleTileBox box = new LittleTileBox(centerTileX, LittleTile.minPos, centerTileZ, centerTileX + 1, LittleTile.maxPos, centerTileZ + 1);
            for (int i = 0; i < tilesInCenter.size(); ++i) {
                for (int j = 0; j < ((LittleTile)tilesInCenter.get((int)i)).boundingBoxes.size(); ++j) {
                    LittleTileBox littleBox = ((LittleTile)tilesInCenter.get((int)i)).boundingBoxes.get(j);
                    if (!box.intersectsWith(littleBox)) continue;
                    position.y = Math.max(y * LittleTile.gridSize + littleBox.maxY, position.y);
                }
            }
        }
        return position;
    }

    public String getIDOfStructure() {
        return LittleStructure.getIDByClass(this.getClass());
    }

    public boolean isBed(IBlockAccess world, BlockPos pos, EntityLivingBase player) {
        return false;
    }

    public EnumFacing getBedDirection(IBlockState state, IBlockAccess world, BlockPos pos) {
        return EnumFacing.EAST;
    }

    public boolean isLadder() {
        return false;
    }

    public static class LittleStructureEntry {
        public Class<? extends LittleStructure> structureClass;
        public LittleStructure parser;

        public LittleStructureEntry(Class<? extends LittleStructure> structureClass, LittleStructure parser) {
            this.structureClass = structureClass;
            this.parser = parser;
        }

        public boolean equals(Object object) {
            return object instanceof LittleStructureEntry && ((LittleStructureEntry)object).structureClass == this.structureClass;
        }

        public String toString() {
            return this.structureClass.toString();
        }
    }
}

