/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.creativecore.common.utils.RenderCubeObject;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileBox;
import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTileBlock
extends LittleTile {
    public Block block;
    public int meta;
    @SideOnly(value=Side.CLIENT)
    private boolean translucent;
    private IBlockState state = null;

    public IBlockState getBlockState() {
        if (this.state == null) {
            this.state = this.block.func_176203_a(this.meta);
            if (this.state == null) {
                this.state = this.block.func_176223_P();
            }
        }
        return this.state;
    }

    public LittleTileBlock(Block block, int meta) {
        this.block = block;
        this.meta = meta;
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.updateClient();
        }
    }

    public LittleTileBlock(Block block) {
        this(block, 0);
    }

    public LittleTileBlock() {
    }

    public void updateClient() {
        this.updateTranslucent();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTranslucent() {
        this.translucent = this.block.canRenderInLayer(this.getBlockState(), BlockRenderLayer.TRANSLUCENT) || this.block.canRenderInLayer(this.getBlockState(), BlockRenderLayer.CUTOUT);
    }

    @Override
    public void saveTileExtra(NBTTagCompound nbt) {
        nbt.func_74778_a("block", ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString());
        nbt.func_74768_a("meta", this.meta);
    }

    @Override
    public void loadTileExtra(NBTTagCompound nbt) {
        this.block = Block.func_149684_b((String)nbt.func_74779_i("block"));
        this.meta = nbt.func_74762_e("meta");
        if (this.block == null || this.block instanceof BlockAir) {
            // empty if block
        }
        if (this.te.isClientSide()) {
            this.updateClient();
        }
    }

    @Override
    public void copyExtra(LittleTile tile) {
        if (tile instanceof LittleTileBlock) {
            LittleTileBlock thisTile = (LittleTileBlock)tile;
            thisTile.block = this.block;
            thisTile.meta = this.meta;
            if (FMLCommonHandler.instance().getSide().isClient()) {
                thisTile.translucent = this.translucent;
            }
        }
    }

    @Override
    public ItemStack getDrop() {
        ItemStack stack = new ItemStack((Block)LittleTiles.blockTile);
        stack.func_77982_d(new NBTTagCompound());
        stack.func_77978_p().func_74778_a("tID", this.getID());
        stack.func_77978_p().func_74768_a("bSize", 0);
        this.saveTileExtra(stack.func_77978_p());
        ((LittleTileBox)this.boundingBoxes.get(0)).getSize().writeToNBT("size", stack.func_77978_p());
        return stack;
    }

    @Override
    public ArrayList<RenderCubeObject> getRenderingCubes() {
        ArrayList<RenderCubeObject> cubes = new ArrayList<RenderCubeObject>();
        for (int i = 0; i < this.boundingBoxes.size(); ++i) {
            cubes.add(new RenderCubeObject(((LittleTileBox)this.boundingBoxes.get(i)).getCube(), this.block, this.meta));
        }
        return cubes;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldBeRenderedInLayer(BlockRenderLayer layer) {
        if (this.translucent) {
            return layer == BlockRenderLayer.TRANSLUCENT;
        }
        return this.block.canRenderInLayer(this.getBlockState(), layer);
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack, EnumFacing facing) {
        super.onPlaced(player, stack, facing);
        try {
            this.block.func_180633_a(this.te.func_145831_w(), this.te.func_174877_v(), this.getBlockState(), (EntityLivingBase)player, stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SoundType getSound() {
        return this.block.func_185467_w();
    }

    @Override
    public void randomDisplayTick(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        this.block.func_180655_c(this.getBlockState(), worldIn, pos, rand);
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (super.onBlockActivated(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ)) {
            return true;
        }
        return this.block.func_180639_a(worldIn, pos, this.getBlockState(), playerIn, hand, heldItem, side, hitX, hitY, hitZ);
    }

    @Override
    public void place() {
        super.place();
        this.block.func_176213_c(this.te.func_145831_w(), this.te.func_174877_v(), this.getBlockState());
    }

    @Override
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.block.func_149750_m(this.getBlockState());
    }

    @Override
    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return this.block.getEnchantPowerBonus(world, pos);
    }

    @Override
    public boolean canBeCombined(LittleTile tile) {
        if (super.canBeCombined(tile) && tile instanceof LittleTileBlock) {
            return this.block == ((LittleTileBlock)tile).block && this.meta == ((LittleTileBlock)tile).meta;
        }
        return false;
    }

    @Override
    public boolean doesProvideSolidFace(EnumFacing facing) {
        return !this.translucent;
    }

    @Override
    public boolean canBeRenderCombined(LittleTile tile) {
        if (tile instanceof LittleTileBlock) {
            return this.block == ((LittleTileBlock)tile).block && this.meta == ((LittleTileBlock)tile).meta;
        }
        return false;
    }

    @Override
    protected boolean canSawResize(EnumFacing facing, EntityPlayer player) {
        return true;
    }

    @Override
    public float getExplosionResistance() {
        return this.block.func_149638_a(null);
    }
}

