/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils;

import com.creativemd.creativecore.common.utils.ColorUtils;
import com.creativemd.creativecore.common.utils.RenderCubeObject;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.LittleTileBlock;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.util.math.Vec3i;

public class LittleTileBlockColored
extends LittleTileBlock {
    public int color;

    public LittleTileBlockColored(Block block, int meta, Vec3i color) {
        super(block, meta);
        this.color = ColorUtils.RGBToInt((Vec3i)color);
    }

    public LittleTileBlockColored() {
    }

    @Override
    public void updatePacket(NBTTagCompound nbt) {
        super.updatePacket(nbt);
        nbt.func_74768_a("color", this.color);
    }

    @Override
    public void receivePacket(NBTTagCompound nbt, NetworkManager net) {
        super.receivePacket(nbt, net);
        this.color = nbt.func_74762_e("color");
    }

    @Override
    public ArrayList<RenderCubeObject> getRenderingCubes() {
        ArrayList<RenderCubeObject> cubes = super.getRenderingCubes();
        int color = this.color;
        for (int i = 0; i < cubes.size(); ++i) {
            cubes.get((int)i).color = color;
        }
        return cubes;
    }

    @Override
    public void copyExtra(LittleTile tile) {
        super.copyExtra(tile);
        if (tile instanceof LittleTileBlockColored) {
            LittleTileBlockColored thisTile = (LittleTileBlockColored)tile;
            thisTile.color = this.color;
        }
    }

    @Override
    public void saveTileExtra(NBTTagCompound nbt) {
        super.saveTileExtra(nbt);
        nbt.func_74768_a("color", this.color);
    }

    @Override
    public void loadTileExtra(NBTTagCompound nbt) {
        super.loadTileExtra(nbt);
        this.color = nbt.func_74762_e("color");
    }

    @Override
    public boolean canBeCombined(LittleTile tile) {
        if (tile instanceof LittleTileBlockColored && super.canBeCombined(tile)) {
            int color1 = ((LittleTileBlockColored)tile).color;
            int color2 = this.color;
            return color1 == color2;
        }
        return super.canBeCombined(tile);
    }

    @Override
    public boolean canBeRenderCombined(LittleTile tile) {
        if (tile instanceof LittleTileBlockColored) {
            return super.canBeRenderCombined(tile) && ((LittleTileBlockColored)tile).color == this.color;
        }
        return false;
    }

    public static LittleTileBlock setColor(LittleTileBlock tile, int color) {
        if (color == ColorUtils.WHITE || color == -1) {
            return LittleTileBlockColored.removeColor(tile);
        }
        if (!(tile instanceof LittleTileBlockColored)) {
            LittleTileBlockColored newTile = new LittleTileBlockColored();
            tile.assign(newTile);
            newTile.color = color;
            return newTile;
        }
        ((LittleTileBlockColored)tile).color = color;
        return null;
    }

    public static LittleTileBlock removeColor(LittleTileBlock tile) {
        if (tile instanceof LittleTileBlockColored) {
            LittleTileBlock newTile = new LittleTileBlock();
            tile.assign(newTile);
            return newTile;
        }
        return null;
    }
}

