/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.small;

import com.creativemd.creativecore.common.utils.CubeObject;
import com.creativemd.creativecore.common.utils.Rotation;
import com.creativemd.littletiles.common.utils.LittleTile;
import com.creativemd.littletiles.common.utils.small.LittleTileSize;
import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import java.util.ArrayList;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class LittleTileBox {
    public int minX;
    public int minY;
    public int minZ;
    public int maxX;
    public int maxY;
    public int maxZ;

    public LittleTileBox(LittleTileVec center, LittleTileSize size) {
        LittleTileVec offset = size.calculateCenter();
        this.minX = center.x - offset.x;
        this.minY = center.y - offset.y;
        this.minZ = center.z - offset.z;
        this.maxX = this.minX + size.sizeX;
        this.maxY = this.minY + size.sizeY;
        this.maxZ = this.minZ + size.sizeZ;
    }

    public LittleTileBox(String name, NBTTagCompound nbt) {
        if (nbt.func_74781_a(name + "minX") instanceof NBTTagByte) {
            this.set(nbt.func_74771_c(name + "minX"), nbt.func_74771_c(name + "minY"), nbt.func_74771_c(name + "minZ"), nbt.func_74771_c(name + "maxX"), nbt.func_74771_c(name + "maxY"), nbt.func_74771_c(name + "maxZ"));
            this.writeToNBT(name, nbt);
        } else if (nbt.func_74781_a(name + "minX") instanceof NBTTagInt) {
            this.set(nbt.func_74762_e(name + "minX"), nbt.func_74762_e(name + "minY"), nbt.func_74762_e(name + "minZ"), nbt.func_74762_e(name + "maxX"), nbt.func_74762_e(name + "maxY"), nbt.func_74762_e(name + "maxZ"));
        } else {
            String[] coords = nbt.func_74779_i(name).split("\\.");
            try {
                this.set(Integer.parseInt(coords[0]), Integer.parseInt(coords[1]), Integer.parseInt(coords[2]), Integer.parseInt(coords[3]), Integer.parseInt(coords[4]), Integer.parseInt(coords[5]));
            }
            catch (Exception e) {
                this.set(0, 0, 0, 0, 0, 0);
            }
        }
    }

    public LittleTileBox(CubeObject cube) {
        this((int)Math.ceil(cube.minX * (float)LittleTile.gridSize), (int)Math.ceil(cube.minY * (float)LittleTile.gridSize), (int)Math.ceil(cube.minZ * (float)LittleTile.gridSize), (int)Math.ceil(cube.maxX * (float)LittleTile.gridSize), (int)Math.ceil(cube.maxY * (float)LittleTile.gridSize), (int)Math.ceil(cube.maxZ * (float)LittleTile.gridSize));
    }

    public LittleTileBox(AxisAlignedBB box) {
        this((int)(box.field_72340_a * (double)LittleTile.gridSize), (int)(box.field_72338_b * (double)LittleTile.gridSize), (int)(box.field_72339_c * (double)LittleTile.gridSize), (int)(box.field_72336_d * (double)LittleTile.gridSize), (int)(box.field_72337_e * (double)LittleTile.gridSize), (int)(box.field_72334_f * (double)LittleTile.gridSize));
    }

    public LittleTileBox(LittleTileVec min, LittleTileVec max) {
        this(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public LittleTileBox(LittleTileVec min) {
        this(min.x, min.y, min.z, min.x + 1, min.y + 1, min.z + 1);
    }

    public LittleTileBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.set(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public AxisAlignedBB getBox() {
        return new AxisAlignedBB((double)this.minX / (double)LittleTile.gridSize, (double)this.minY / (double)LittleTile.gridSize, (double)this.minZ / (double)LittleTile.gridSize, (double)this.maxX / (double)LittleTile.gridSize, (double)this.maxY / (double)LittleTile.gridSize, (double)this.maxZ / (double)LittleTile.gridSize);
    }

    public CubeObject getCube() {
        return new CubeObject((float)this.minX / (float)LittleTile.gridSize, (float)this.minY / (float)LittleTile.gridSize, (float)this.minZ / (float)LittleTile.gridSize, (float)this.maxX / (float)LittleTile.gridSize, (float)this.maxY / (float)LittleTile.gridSize, (float)this.maxZ / (float)LittleTile.gridSize);
    }

    public void writeToNBT(String name, NBTTagCompound nbt) {
        nbt.func_74778_a(name, this.minX + "." + this.minY + "." + this.minZ + "." + this.maxX + "." + this.maxY + "." + this.maxZ);
    }

    public Vec3d getSizeD() {
        return new Vec3d((double)(this.maxX - this.minX) * LittleTile.gridMCLength, (double)(this.maxY - this.minY) * LittleTile.gridMCLength, (double)(this.maxZ - this.minZ) * LittleTile.gridMCLength);
    }

    public LittleTileSize getSize() {
        return new LittleTileSize(this.maxX - this.minX, this.maxY - this.minY, this.maxZ - this.minZ);
    }

    public LittleTileBox copy() {
        return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public boolean isValidBox() {
        return this.maxX > this.minX && this.maxY > this.minY && this.maxZ > this.minZ;
    }

    public void set(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public boolean needsMultipleBlocks() {
        int x = this.minX / LittleTile.gridSize;
        int y = this.minY / LittleTile.gridSize;
        int z = this.minZ / LittleTile.gridSize;
        return this.maxX - x * LittleTile.gridSize <= LittleTile.maxPos && this.maxY - y * LittleTile.gridSize <= LittleTile.maxPos && this.maxZ - z * LittleTile.gridSize <= LittleTile.maxPos;
    }

    public boolean doesMatchTwoSides(LittleTileBox box, EnumFacing facing) {
        switch (facing) {
            case EAST: 
            case WEST: {
                return this.minY == box.minY && this.maxY == box.maxY && this.minZ == box.minZ && this.maxZ == box.maxZ;
            }
            case UP: 
            case DOWN: {
                return this.minX == box.minX && this.maxX == box.maxX && this.minZ == box.minZ && this.maxZ == box.maxZ;
            }
            case SOUTH: 
            case NORTH: {
                return this.minX == box.minX && this.maxX == box.maxX && this.minY == box.minY && this.maxY == box.maxY;
            }
        }
        return false;
    }

    public LittleTileBox combineBoxes(LittleTileBox box) {
        boolean z;
        boolean x = this.minX == box.minX && this.maxX == box.maxX;
        boolean y = this.minY == box.minY && this.maxY == box.maxY;
        boolean bl = z = this.minZ == box.minZ && this.maxZ == box.maxZ;
        if (x && y && z) {
            return this;
        }
        if (x && y) {
            if (this.minZ == box.maxZ) {
                return new LittleTileBox(this.minX, this.minY, box.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxZ == box.minZ) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, this.maxY, box.maxZ);
            }
        }
        if (x && z) {
            if (this.minY == box.maxY) {
                return new LittleTileBox(this.minX, box.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxY == box.minY) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, this.maxX, box.maxY, this.maxZ);
            }
        }
        if (y && z) {
            if (this.minX == box.maxX) {
                return new LittleTileBox(box.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
            }
            if (this.maxX == box.minX) {
                return new LittleTileBox(this.minX, this.minY, this.minZ, box.maxX, this.maxY, this.maxZ);
            }
        }
        return null;
    }

    public void addOffset(LittleTileVec vec) {
        this.minX += vec.x;
        this.minY += vec.y;
        this.minZ += vec.z;
        this.maxX += vec.x;
        this.maxY += vec.y;
        this.maxZ += vec.z;
    }

    public void subOffset(LittleTileVec vec) {
        this.minX -= vec.x;
        this.minY -= vec.y;
        this.minZ -= vec.z;
        this.maxX -= vec.x;
        this.maxY -= vec.y;
        this.maxZ -= vec.z;
    }

    public void assignCube(CubeObject cube) {
        this.minX = (int)(cube.minX * (float)LittleTile.gridSize);
        this.minY = (int)(cube.minY * (float)LittleTile.gridSize);
        this.minZ = (int)(cube.minZ * (float)LittleTile.gridSize);
        this.maxX = (int)(cube.maxX * (float)LittleTile.gridSize);
        this.maxY = (int)(cube.maxY * (float)LittleTile.gridSize);
        this.maxZ = (int)(cube.maxZ * (float)LittleTile.gridSize);
    }

    public LittleTileVec getMinVec() {
        return new LittleTileVec(this.minX, this.minY, this.minZ);
    }

    public LittleTileVec getMaxVec() {
        return new LittleTileVec(this.maxX, this.maxY, this.maxZ);
    }

    public void rotateBoxWithCenter(Rotation direction, Vec3d center) {
        CubeObject cube = this.getCube();
        cube = CubeObject.rotateCube((CubeObject)cube, (Rotation)direction, (Vec3d)center);
        this.minX = (int)(cube.minX * (float)LittleTile.gridSize);
        this.minY = (int)(cube.minY * (float)LittleTile.gridSize);
        this.minZ = (int)(cube.minZ * (float)LittleTile.gridSize);
        this.maxX = (int)(cube.maxX * (float)LittleTile.gridSize);
        this.maxY = (int)(cube.maxY * (float)LittleTile.gridSize);
        this.maxZ = (int)(cube.maxZ * (float)LittleTile.gridSize);
    }

    public void flipBox(EnumFacing direction) {
        switch (direction) {
            case EAST: 
            case WEST: {
                this.minX = -this.minX;
                this.maxX = -this.maxX;
                break;
            }
            case UP: 
            case DOWN: {
                this.minY = -this.minY;
                this.maxY = -this.maxY;
                break;
            }
            case SOUTH: 
            case NORTH: {
                this.minZ = -this.minZ;
                this.maxZ = -this.maxZ;
                break;
            }
        }
        this.resort();
    }

    public void flipBoxWithCenter(EnumFacing direction, LittleTileVec center) {
        if (center == null) {
            center = new LittleTileVec(LittleTile.halfGridSize, LittleTile.halfGridSize, LittleTile.halfGridSize);
        }
        this.subOffset(center);
        this.flipBox(direction);
        this.addOffset(center);
    }

    public void rotateBox(EnumFacing direction) {
        CubeObject cube = this.getCube();
        cube = CubeObject.rotateCube((CubeObject)cube, (EnumFacing)direction);
        this.assignCube(cube);
    }

    public boolean equals(Object object) {
        if (object instanceof LittleTileBox) {
            return this.minX == ((LittleTileBox)object).minX && this.minY == ((LittleTileBox)object).minY && this.minZ == ((LittleTileBox)object).minZ && this.maxX == ((LittleTileBox)object).maxX && this.maxY == ((LittleTileBox)object).maxY && this.maxZ == ((LittleTileBox)object).maxZ;
        }
        return super.equals(object);
    }

    public String toString() {
        return "[" + this.minX + "," + this.minY + "," + this.minZ + " -> " + this.maxX + "," + this.maxY + "," + this.maxZ + "]";
    }

    public LittleTileVec getNearstedPointTo(LittleTileVec vec) {
        int x = this.minX;
        if (vec.x >= this.minX || vec.x <= this.maxX) {
            x = vec.x;
        }
        if (Math.abs(this.minX - x) > Math.abs(this.maxX - x)) {
            x = this.maxX;
        }
        int y = this.minY;
        if (vec.y >= this.minY || vec.y <= this.maxY) {
            y = vec.y;
        }
        if (Math.abs(this.minY - y) > Math.abs(this.maxY - y)) {
            y = this.maxY;
        }
        int z = this.minZ;
        if (vec.z >= this.minZ || vec.z <= this.maxZ) {
            z = vec.z;
        }
        if (Math.abs(this.minZ - z) > Math.abs(this.maxZ - z)) {
            z = this.maxZ;
        }
        return new LittleTileVec(x, y, z);
    }

    public LittleTileVec getNearstedPointTo(LittleTileBox box) {
        int x = 0;
        x = this.minX >= box.minX && this.minX <= box.maxX ? this.minX : (box.minX >= this.minX && box.minX <= box.maxX ? box.minX : (Math.abs(this.minX - box.maxX) > Math.abs(this.maxX - box.minX) ? this.maxX : this.minX));
        int y = 0;
        y = this.minY >= box.minY && this.minY <= box.maxY ? this.minY : (box.minY >= this.minY && box.minY <= box.maxY ? box.minY : (Math.abs(this.minY - box.maxY) > Math.abs(this.maxY - box.minY) ? this.maxY : this.minY));
        int z = 0;
        z = this.minZ >= box.minZ && this.minZ <= box.maxZ ? this.minZ : (box.minZ >= this.minZ && box.minZ <= box.maxZ ? box.minZ : (Math.abs(this.minZ - box.maxZ) > Math.abs(this.maxZ - box.minZ) ? this.maxZ : this.minZ));
        return new LittleTileVec(x, y, z);
    }

    public double distanceTo(LittleTileBox box) {
        return this.distanceTo(box.getNearstedPointTo(this));
    }

    public double distanceTo(LittleTileVec vec) {
        return this.getNearstedPointTo(vec).distanceTo(vec);
    }

    public boolean isBoxInside(LittleTileBox box) {
        if (this.minX > box.maxX || box.minX > this.minX) {
            return false;
        }
        if (this.minY > box.maxY || box.minY > this.minY) {
            return false;
        }
        return this.minZ <= box.maxZ && box.minZ <= this.minZ;
    }

    public boolean isVecInsideBox(LittleTileVec vec) {
        if (this.minX > vec.x || vec.x > this.minX) {
            return false;
        }
        if (this.minY > vec.y || vec.y > this.minY) {
            return false;
        }
        return this.minZ <= vec.z && vec.z <= this.minZ;
    }

    public boolean intersectsWith(LittleTileBox box) {
        return box.maxX > this.minX && box.minX < this.maxX ? (box.maxY > this.minY && box.minY < this.maxY ? box.maxZ > this.minZ && box.minZ < this.maxZ : false) : false;
    }

    public EnumFacing faceTo(LittleTileBox box) {
        boolean z;
        boolean x = this.minX < box.maxX && box.minX < this.maxX;
        boolean y = this.minY < box.maxY && box.minY < this.maxY;
        boolean bl = z = this.minZ < box.maxZ && box.minZ < this.maxZ;
        if (x && y && z) {
            return EnumFacing.EAST;
        }
        if (x && y) {
            if (this.minZ > box.maxZ) {
                return EnumFacing.NORTH;
            }
            return EnumFacing.SOUTH;
        }
        if (x && z) {
            if (this.minY > box.maxY) {
                return EnumFacing.DOWN;
            }
            return EnumFacing.UP;
        }
        if (y && z) {
            if (this.minX > box.maxX) {
                return EnumFacing.WEST;
            }
            return EnumFacing.EAST;
        }
        return EnumFacing.EAST;
    }

    public boolean hasTwoSideIntersection(LittleTileBox box) {
        boolean z;
        boolean x = this.minX <= box.maxX && box.minX <= this.minX;
        boolean y = this.minY <= box.maxY && box.minY <= this.minY;
        boolean bl = z = this.minZ <= box.maxZ && box.minZ <= this.minZ;
        if (x && y && z) {
            return false;
        }
        return x && y || x && z || y && z;
    }

    public boolean isParallel(LittleTileBox box) {
        return true;
    }

    public boolean isBoxInsideBlock() {
        return this.minX >= LittleTile.minPos && this.maxX <= LittleTile.maxPos && this.minY >= LittleTile.minPos && this.maxY <= LittleTile.maxPos && this.minZ >= LittleTile.minPos && this.maxZ <= LittleTile.maxPos;
    }

    public LittleTileBox expand(EnumFacing direction) {
        LittleTileBox result = this.copy();
        switch (direction) {
            case EAST: {
                ++result.maxX;
                break;
            }
            case WEST: {
                --result.minX;
                break;
            }
            case UP: {
                ++result.maxY;
                break;
            }
            case DOWN: {
                --result.minY;
                break;
            }
            case SOUTH: {
                ++result.maxZ;
                break;
            }
            case NORTH: {
                --result.minZ;
                break;
            }
        }
        return result;
    }

    public LittleTileBox shrink(EnumFacing direction) {
        LittleTileBox result = this.copy();
        switch (direction) {
            case EAST: {
                --result.maxX;
                break;
            }
            case WEST: {
                ++result.minX;
                break;
            }
            case UP: {
                --result.maxY;
                break;
            }
            case DOWN: {
                ++result.minY;
                break;
            }
            case SOUTH: {
                --result.maxZ;
                break;
            }
            case NORTH: {
                ++result.minZ;
                break;
            }
        }
        return result;
    }

    public void applyDirection(EnumFacing direction) {
        switch (direction) {
            case EAST: {
                this.minX += LittleTile.gridSize;
                this.maxX += LittleTile.gridSize;
                break;
            }
            case WEST: {
                this.minX -= LittleTile.gridSize;
                this.maxX -= LittleTile.gridSize;
                break;
            }
            case UP: {
                this.minY += LittleTile.gridSize;
                this.maxY += LittleTile.gridSize;
                break;
            }
            case DOWN: {
                this.minY -= LittleTile.gridSize;
                this.maxY -= LittleTile.gridSize;
                break;
            }
            case SOUTH: {
                this.minZ += LittleTile.gridSize;
                this.maxZ += LittleTile.gridSize;
                break;
            }
            case NORTH: {
                this.minZ -= LittleTile.gridSize;
                this.maxZ -= LittleTile.gridSize;
                break;
            }
        }
    }

    public void resort() {
        this.set(Math.min(this.minX, this.maxX), Math.min(this.minY, this.maxY), Math.min(this.minZ, this.maxZ), Math.max(this.minX, this.maxX), Math.max(this.minY, this.maxY), Math.max(this.minZ, this.maxZ));
    }

    public LittleTileBox getSideOfBox(EnumFacing facing) {
        LittleTileBox newBox = this.copy();
        switch (facing) {
            case EAST: {
                newBox.minX = this.maxX;
                ++newBox.maxX;
                break;
            }
            case WEST: {
                newBox.maxX = this.minX;
                --newBox.minX;
                break;
            }
            case UP: {
                newBox.minY = this.maxY;
                ++newBox.maxY;
                break;
            }
            case DOWN: {
                newBox.maxY = this.minY;
                --newBox.minY;
                break;
            }
            case SOUTH: {
                newBox.minZ = this.maxZ;
                ++newBox.maxZ;
                break;
            }
            case NORTH: {
                newBox.maxZ = this.minZ;
                --newBox.minZ;
            }
        }
        return newBox;
    }

    public LittleTileBox createOutsideBlockBox(EnumFacing facing) {
        LittleTileBox box = this.copy();
        switch (facing) {
            case EAST: {
                box.minX = 0;
                box.maxX -= LittleTile.gridSize;
                break;
            }
            case WEST: {
                box.minX += LittleTile.gridSize;
                box.maxX = LittleTile.gridSize;
                break;
            }
            case UP: {
                box.minY = 0;
                box.maxY -= LittleTile.gridSize;
                break;
            }
            case DOWN: {
                box.minY += LittleTile.gridSize;
                box.maxY = LittleTile.gridSize;
                break;
            }
            case SOUTH: {
                box.minZ = 0;
                box.maxZ -= LittleTile.gridSize;
                break;
            }
            case NORTH: {
                box.minZ += LittleTile.gridSize;
                box.maxZ = LittleTile.gridSize;
            }
        }
        return box;
    }

    public LittleTileBox createInsideBlockBox(EnumFacing facing) {
        CubeObject cube = this.getCube();
        return new LittleTileBox(cube.offset(new BlockPos(0, 0, 0).func_177972_a(facing)));
    }

    public static void combineBoxes(ArrayList<LittleTileBox> boxes) {
        int size = 0;
        while (size != boxes.size()) {
            size = boxes.size();
            for (int i = 0; i < boxes.size(); ++i) {
                int j = 0;
                while (j < boxes.size()) {
                    LittleTileBox box;
                    if (i != j && (box = boxes.get(i).combineBoxes(boxes.get(j))) != null) {
                        boxes.set(i, box);
                        boxes.remove(j);
                        if (i <= j) continue;
                        --i;
                        continue;
                    }
                    ++j;
                }
            }
        }
    }

    public void makeItFitInsideBlock() {
        this.minX = Math.max(LittleTile.minPos, this.minX);
        this.maxX = Math.min(LittleTile.gridSize, this.maxX);
        this.minY = Math.max(LittleTile.minPos, this.minY);
        this.maxY = Math.min(LittleTile.gridSize, this.maxY);
        this.minZ = Math.max(LittleTile.minPos, this.minZ);
        this.maxZ = Math.min(LittleTile.gridSize, this.maxZ);
    }

    public LittleTileVec getCenter() {
        return new LittleTileVec((this.maxX + this.minX) / 2, (this.maxY + this.minY) / 2, (this.maxZ + this.minZ) / 2);
    }
}

