/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.small;

import com.creativemd.littletiles.common.utils.small.LittleTileVec;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class LittleTileCoord {
    private BlockPos coord;
    public LittleTileVec position;

    public LittleTileCoord(TileEntity te, BlockPos coord, LittleTileVec position) {
        this(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p(), coord, position);
    }

    public LittleTileCoord(BlockPos origin, BlockPos coord, LittleTileVec position) {
        this(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p(), coord, position);
    }

    public LittleTileCoord(int baseX, int baseY, int baseZ, BlockPos coord, LittleTileVec position) {
        this(coord.func_177958_n() - baseX, coord.func_177956_o() - baseY, coord.func_177952_p() - baseZ, position);
    }

    protected LittleTileCoord(int relativeX, int relativeY, int relativeZ, LittleTileVec position) {
        this.coord = new BlockPos(relativeX, relativeY, relativeZ);
        this.position = position;
    }

    public LittleTileCoord(String id, NBTTagCompound nbt) {
        this.coord = new BlockPos(nbt.func_74762_e(id + "coordX"), nbt.func_74762_e(id + "coordY"), nbt.func_74762_e(id + "coordZ"));
        this.position = new LittleTileVec(id + "pos", nbt);
    }

    public LittleTileCoord(NBTTagCompound nbt) {
        this("", nbt);
    }

    public BlockPos getAbsolutePosition(TileEntity te) {
        return this.getAbsolutePosition(te.func_174877_v().func_177958_n(), te.func_174877_v().func_177956_o(), te.func_174877_v().func_177952_p());
    }

    public BlockPos getAbsolutePosition(BlockPos origin) {
        return this.getAbsolutePosition(origin.func_177958_n(), origin.func_177956_o(), origin.func_177952_p());
    }

    public BlockPos getAbsolutePosition(int x, int y, int z) {
        return new BlockPos(this.coord.func_177958_n() + x, this.coord.func_177956_o() + y, this.coord.func_177952_p() + z);
    }

    public void writeToNBT(String id, NBTTagCompound nbt) {
        nbt.func_74768_a(id + "coordX", this.coord.func_177958_n());
        nbt.func_74768_a(id + "coordY", this.coord.func_177956_o());
        nbt.func_74768_a(id + "coordZ", this.coord.func_177952_p());
        this.position.writeToNBT(id + "pos", nbt);
    }

    public void writeToNBT(NBTTagCompound nbt) {
        this.writeToNBT("", nbt);
    }

    public String toString() {
        return "coord:[" + this.coord.func_177958_n() + "," + this.coord.func_177956_o() + "," + this.coord.func_177952_p() + "]|position:" + this.position;
    }

    public LittleTileCoord copy() {
        return new LittleTileCoord(this.coord.func_177958_n(), this.coord.func_177956_o(), this.coord.func_177952_p(), this.position.copy());
    }
}

