/*
 * Decompiled with CFR 0.152.
 */
package me.kk47.christmastrees.tree;

import java.util.Random;
import me.kk47.christmastrees.items.TreeItems;
import me.kk47.christmastrees.tree.BlockChristmasTree;
import me.kk47.christmastrees.tree.ItemChristmasTree;
import me.kk47.christmastrees.tree.TileEntityChristmasTree;
import me.kk47.christmastrees.tree.TileEntityChristmasTreeTrains;
import me.kk47.christmastrees.tree.trees.ChristmasTrees;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public class ChristmasTree {
    public BlockChristmasTree block;
    public Class<? extends TileEntityChristmasTreeTrains> tileEntity;
    public ItemChristmasTree item;
    public final String name;

    public ChristmasTree(String name) {
        this.name = name;
        this.block = new BlockChristmasTree(name);
        this.tileEntity = TileEntityChristmasTreeTrains.class;
        this.item = new ItemChristmasTree((Block)this.block);
    }

    public void registerCommon() {
        GameRegistry.register((IForgeRegistryEntry)this.block);
        GameRegistry.register((IForgeRegistryEntry)this.item);
        GameRegistry.registerTileEntity(this.tileEntity, (String)this.name);
    }

    public static final void placeTreeAt(World world, BlockPos bp) {
        Random random = new Random();
        boolean success = world.func_180501_a(bp, ChristmasTrees.normal.block.func_176223_P(), 2);
        if (world.func_175625_s(bp) == null) {
            world.func_175690_a(bp, ChristmasTrees.normal.block.func_149915_a(world, 0));
        }
        TileEntityChristmasTree tect = (TileEntityChristmasTree)world.func_175625_s(bp);
        ChristmasTree.checkTopper(tect, random);
        ChristmasTree.checkDecorations(tect, random);
        ChristmasTree.checkLights(tect, random);
    }

    private static void checkDecorations(TileEntityChristmasTree tect, Random random) {
        if (random.nextInt(2) == 0) {
            tect.func_70299_a(1, new ItemStack((Item)TreeItems.decorations.get(random.nextInt(TreeItems.decorations.size()))));
        }
    }

    private static void checkLights(TileEntityChristmasTree tect, Random random) {
        if (random.nextInt(2) == 0) {
            tect.func_70299_a(3, new ItemStack((Item)TreeItems.lights.get(random.nextInt(TreeItems.lights.size()))));
        }
    }

    private static void checkTopper(TileEntityChristmasTree tect, Random random) {
        if (random.nextInt(3) == 0) {
            tect.func_70299_a(0, new ItemStack((Item)TreeItems.toppers.get(random.nextInt(TreeItems.toppers.size()))));
        }
    }
}

