/*
 * Decompiled with CFR 0.152.
 */
package me.kk47.christmastrees.tree;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import me.kk47.christmastrees.items.ItemChristmasLights;
import me.kk47.christmastrees.items.ItemDecoration;
import me.kk47.christmastrees.items.ItemTopper;
import me.kk47.christmastrees.items.ItemTrainset;
import me.kk47.christmastrees.tree.trees.ChristmasTrees;
import me.kk47.modeltrains.items.trains.ItemTrain;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;

public class TileEntityChristmasTree
extends TileEntity
implements IInventory,
ITickable {
    private ItemStack[] inventory;
    private byte nextSync = (byte)20;
    private static final String TOPPER_TAG = "topper";
    private static final String DECORATION_TAG_A = "decorationA";
    private static final String DECORATION_TAG_B = "decorationB";
    private static final String LIGHTS_TAG = "lights";
    private static final String TRAINS_TAG = "trains";

    public TileEntityChristmasTree() {
        this.inventory = new ItemStack[this.func_70302_i_()];
    }

    public boolean func_145818_k_() {
        return true;
    }

    public String func_70005_c_() {
        return "Christmas Tree";
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeSyncableDataToNBT(syncData);
        return syncData;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.readSyncableDataFromNBT(pkt.func_148857_g());
    }

    protected void writeSyncableDataToNBT(NBTTagCompound syncData) {
        if (this.inventory[0] != null) {
            syncData.func_74782_a(TOPPER_TAG, (NBTBase)this.getSyncItemStack(this.inventory[0]));
        }
        if (this.inventory[1] != null) {
            syncData.func_74782_a(DECORATION_TAG_A, (NBTBase)this.getSyncItemStack(this.inventory[1]));
        }
        if (this.inventory[2] != null) {
            syncData.func_74782_a(DECORATION_TAG_B, (NBTBase)this.getSyncItemStack(this.inventory[2]));
        }
        if (this.inventory[3] != null) {
            syncData.func_74782_a(LIGHTS_TAG, (NBTBase)this.getSyncItemStack(this.inventory[3]));
        }
        for (int i = 4; i < 9; ++i) {
            if (this.inventory[i] == null) continue;
            syncData.func_74782_a(TRAINS_TAG + i, (NBTBase)this.getSyncItemStack(this.inventory[i]));
        }
    }

    protected void readSyncableDataFromNBT(NBTTagCompound syncData) {
        if (syncData.func_74764_b(TOPPER_TAG)) {
            this.inventory[0] = this.getItemStackFromNBT(syncData.func_74775_l(TOPPER_TAG));
        }
        if (syncData.func_74764_b(DECORATION_TAG_A)) {
            this.inventory[1] = this.getItemStackFromNBT(syncData.func_74775_l(DECORATION_TAG_A));
        }
        if (syncData.func_74764_b(DECORATION_TAG_B)) {
            this.inventory[2] = this.getItemStackFromNBT(syncData.func_74775_l(DECORATION_TAG_B));
        }
        if (syncData.func_74764_b(LIGHTS_TAG)) {
            this.inventory[3] = this.getItemStackFromNBT(syncData.func_74775_l(LIGHTS_TAG));
        }
        for (int i = 4; i < 9; ++i) {
            if (!syncData.func_74764_b(TRAINS_TAG + i)) continue;
            this.inventory[i] = this.getItemStackFromNBT(syncData.func_74775_l(TRAINS_TAG + i));
        }
    }

    protected ItemStack getItemStackFromNBT(NBTTagCompound nbt) {
        return ItemStack.func_77949_a((NBTTagCompound)nbt);
    }

    protected NBTTagCompound getSyncItemStack(ItemStack is) {
        NBTTagCompound stack = new NBTTagCompound();
        is.func_77955_b(stack);
        return stack;
    }

    private void updateSync() {
        this.nextSync = (byte)(this.nextSync - 1);
        if (this.nextSync == 0) {
            this.field_145850_b.func_184138_a(this.field_174879_c, ChristmasTrees.normal.block.func_176223_P(), ChristmasTrees.normal.block.func_176223_P(), 1);
            this.func_70296_d();
            this.nextSync = (byte)20;
        }
    }

    public int func_70302_i_() {
        return 9;
    }

    public ItemStack func_70301_a(int index) {
        if (index < 0 || index > this.func_70302_i_() - 1) {
            return null;
        }
        return this.inventory[index];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.func_70301_a(index) != null) {
            if (this.func_70301_a((int)index).field_77994_a <= count) {
                ItemStack itemstack = this.func_70301_a(index);
                this.func_70299_a(index, null);
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack = this.func_70301_a(index).func_77979_a(count);
            if (this.func_70301_a((int)index).field_77994_a <= 0) {
                this.func_70299_a(index, null);
            } else {
                this.func_70299_a(index, this.func_70301_a(index));
            }
            this.func_70296_d();
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (index < 0 || index >= this.func_70302_i_()) {
            return;
        }
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        if (stack != null && stack.field_77994_a == 0) {
            stack = null;
        }
        this.inventory[index] = stack;
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public void func_174889_b(EntityPlayer ep) {
    }

    public void func_174886_c(EntityPlayer ep) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return stack.func_77973_b() instanceof ItemTopper;
            }
            case 1: {
                return stack.func_77973_b() instanceof ItemDecoration;
            }
            case 2: {
                return stack.func_77973_b() instanceof ItemDecoration;
            }
            case 3: {
                return stack.func_77973_b() instanceof ItemChristmasLights;
            }
            case 4: {
                return stack.func_77973_b() instanceof ItemTrain;
            }
            case 5: {
                return stack.func_77973_b() instanceof ItemTrain;
            }
            case 6: {
                return stack.func_77973_b() instanceof ItemTrain;
            }
            case 7: {
                return stack.func_77973_b() instanceof ItemTrain;
            }
            case 8: {
                return stack.func_77973_b() instanceof ItemTrainset;
            }
        }
        return false;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
        return nbt;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            int slot = stackTag.func_74771_c("Slot") & 0xFF;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)stackTag));
        }
    }

    public List<ItemStack> getDropableItems() {
        ArrayList<ItemStack> out = new ArrayList<ItemStack>(8);
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            out.add(this.inventory[i]);
        }
        return out;
    }

    public void func_73660_a() {
        this.updateSync();
    }

    public ItemStack func_70304_b(int index) {
        return this.func_70298_a(index, 1);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, null);
        }
    }
}

