/*
 * Decompiled with CFR 0.152.
 */
package me.kk47.christmastrees.tree;

import javax.annotation.Nullable;
import me.kk47.christmastrees.network.TPacketChangeTrainDirection;
import me.kk47.christmastrees.network.TPacketChangeTrainSpeed;
import me.kk47.christmastrees.tree.TileEntityChristmasTree;
import me.kk47.modeltrains.api.IItemModelTrack;
import me.kk47.modeltrains.api.IItemTrain;
import me.kk47.modeltrains.api.ITileEntityTrackContainer;
import me.kk47.modeltrains.api.ITileEntityTrainContainer;
import me.kk47.modeltrains.blocks.ModBlocks;
import me.kk47.modeltrains.items.ModItems;
import me.kk47.modeltrains.math.MathHelper;
import me.kk47.modeltrains.math.Position3F;
import me.kk47.modeltrains.tileentity.TileEntityTrainController;
import me.kk47.modeltrains.train.RollingStock;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;

public class TileEntityChristmasTreeTrains
extends TileEntityChristmasTree
implements ITileEntityTrackContainer,
ITileEntityTrainContainer {
    public static final int BLOCK_OFFSET = 32;
    public static final ItemStack TRACK_NORTH = new ItemStack((Item)ModItems.trackStraight, 1, 0);
    public static final ItemStack TRACK_EAST = new ItemStack((Item)ModItems.trackStraight, 1, 1);
    public static ItemStack[][] TRACKS = new ItemStack[][]{{new ItemStack((Item)ModItems.trackCorner, 1, 2), new ItemStack((Item)ModItems.trackStraight, 1, 0), new ItemStack((Item)ModItems.trackStraight, 1, 0), new ItemStack((Item)ModItems.trackCorner, 1, 3)}, {new ItemStack((Item)ModItems.trackStraight, 1, 1), null, null, new ItemStack((Item)ModItems.trackStraight, 1, 1)}, {new ItemStack((Item)ModItems.trackStraight, 1, 1), null, null, new ItemStack((Item)ModItems.trackStraight, 1, 1)}, {new ItemStack((Item)ModItems.trackCorner, 1, 1), new ItemStack((Item)ModItems.trackStraight, 1, 0), new ItemStack((Item)ModItems.trackStraight, 1, 0), new ItemStack((Item)ModItems.trackCorner, 1, 0)}};
    public static Position3F[] trainStartPoints = new Position3F[]{new Position3F(127.5f, 131.5f, 0.0f), new Position3F(126.5f, 131.5f, 270.0f), new Position3F(125.5f, 131.5f, 270.0f), new Position3F(124.5f, 131.5f, 270.0f)};
    private RollingStock[] trains = new RollingStock[4];
    private boolean forwards = true;
    private byte speed = 1;
    private BlockPos startPos;
    private boolean firstTick = true;
    TPacketChangeTrainSpeed lastPacket;
    TPacketChangeTrainDirection lastDirPacket;

    public TileEntityChristmasTreeTrains() {
        for (int i = 0; i < this.trains.length; ++i) {
            this.trains[i] = new RollingStock(new Position3F(), (ITileEntityTrainContainer)this);
        }
    }

    public int getDirection() {
        if (this.forwards) {
            return 1;
        }
        return -1;
    }

    public boolean getDirectionValue() {
        return this.forwards;
    }

    public float getSpeed() {
        return TileEntityTrainController.speeds[this.speed] * (float)this.getDirection();
    }

    public byte getSpeedValue() {
        return this.speed;
    }

    public void setSpeed(byte speed) {
        this.speed = speed;
    }

    public RollingStock[] getTrains() {
        return this.trains;
    }

    public boolean isTrack(Position3F pos) {
        try {
            int x = 0;
            float spareX = pos.getX();
            while (spareX >= 4.0f) {
                spareX -= 4.0f;
                ++x;
            }
            int y = 0;
            float spareY = pos.getY();
            while (spareY >= 4.0f) {
                spareY -= 4.0f;
                ++y;
            }
            BlockPos check = this.startPos;
            check = check.func_177965_g(x + 1);
            return ((ITileEntityTrackContainer)this.field_145850_b.func_175625_s(check = check.func_177970_e(y))).getInventory()[MathHelper.floorFloat((float)spareX)][MathHelper.floorFloat((float)spareY)] != null && ((ITileEntityTrackContainer)this.field_145850_b.func_175625_s(check)).getInventory()[MathHelper.floorFloat((float)spareX)][MathHelper.floorFloat((float)spareY)].func_77973_b() instanceof IItemModelTrack;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isTrackBlock(Position3F pos) {
        try {
            int x = 0;
            float rand = pos.getX();
            while (rand >= 4.0f) {
                rand -= 4.0f;
                ++x;
            }
            int y = 0;
            rand = pos.getY();
            while (rand >= 4.0f) {
                rand -= 4.0f;
                ++y;
            }
            return this.field_145850_b.func_175625_s(this.startPos.func_177965_g(x + 1).func_177970_e(y)) != null && this.field_145850_b.func_175625_s(this.startPos.func_177965_g(x + 1).func_177970_e(y)).func_145838_q().func_149739_a().equalsIgnoreCase(ModBlocks.trackBed.func_149739_a());
        }
        catch (Exception e) {
            return false;
        }
    }

    public ITileEntityTrackContainer getTrackBedAt(Position3F pos) {
        if (!this.isTrack(pos)) {
            return null;
        }
        int x = 0;
        float rand = pos.getX();
        while (rand >= 4.0f) {
            rand -= 4.0f;
            ++x;
        }
        int y = 0;
        rand = pos.getY();
        while (rand >= 4.0f) {
            rand -= 4.0f;
            ++y;
        }
        return (ITileEntityTrackContainer)this.field_145850_b.func_175625_s(this.startPos.func_177965_g(x + 1).func_177970_e(y));
    }

    public ItemStack getTrackAt(Position3F pos) {
        if (!this.isTrack(pos)) {
            return null;
        }
        int x = 0;
        float spareX = pos.getX();
        while (spareX >= 4.0f) {
            spareX -= 4.0f;
            ++x;
        }
        int y = 0;
        float spareY = pos.getY();
        while (spareY >= 4.0f) {
            spareY -= 4.0f;
            ++y;
        }
        return ((ITileEntityTrackContainer)this.field_145850_b.func_175625_s(this.startPos.func_177965_g(x + 1).func_177970_e(y))).getInventory()[MathHelper.floorFloat((float)spareX)][MathHelper.floorFloat((float)spareY)];
    }

    private Position3F getStartDirections(int index) {
        return trainStartPoints[index].clone();
    }

    private void initTrains() {
        for (int i = 0; i < this.trains.length; ++i) {
            this.trains[i] = new RollingStock(this.getStartDirections(i), (ITileEntityTrainContainer)this);
        }
    }

    private void firstTick() {
        this.startPos = this.field_174879_c.func_177985_f(32).func_177964_d(32);
        this.initTrains();
        this.firstTick = false;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.firstTick) {
            this.firstTick();
        }
        if (!this.hasValidLoco()) {
            this.speed = 0;
        }
        boolean hasTrainWithItem = false;
        for (int i = 0; i < this.trains.length; ++i) {
            RollingStock r = this.trains[i];
            if (this.func_70301_a(7 - i) != null && this.func_70301_a(7 - i).func_77973_b() instanceof IItemTrain) {
                r.setTrainItem((IItemTrain)this.func_70301_a(7 - i).func_77973_b());
                hasTrainWithItem = true;
            } else {
                r.setTrainItem(null);
            }
            r.setSpeed(this.getSpeed());
            r.func_73660_a();
        }
        if (!hasTrainWithItem) {
            this.initTrains();
        }
        this.field_145850_b.func_184138_a(this.field_174879_c, ModBlocks.trackBed.func_176223_P(), ModBlocks.trackBed.func_176223_P(), 1);
        this.func_70296_d();
    }

    public boolean hasTrain() {
        boolean out = false;
        for (int i = 0; i < 4; ++i) {
            if (this.func_70301_a(7 - i) == null) continue;
            out = true;
        }
        return out;
    }

    public synchronized void handleTrainSpeedPacket(TPacketChangeTrainSpeed packet) {
        this.lastPacket = packet;
        ((WorldServer)this.field_145850_b).func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (TileEntityChristmasTreeTrains.this.hasValidLoco()) {
                    TileEntityChristmasTreeTrains.this.func_174885_b(0, TileEntityChristmasTreeTrains.this.lastPacket.getNewSpeed());
                }
            }
        });
    }

    public synchronized void handleTrainDirectionPacket(TPacketChangeTrainDirection message) {
        this.lastDirPacket = message;
        ((WorldServer)this.field_145850_b).func_152344_a(new Runnable(){

            @Override
            public void run() {
                if (TileEntityChristmasTreeTrains.this.speed == 0) {
                    if (TileEntityChristmasTreeTrains.this.lastDirPacket.getNewDirection()) {
                        TileEntityChristmasTreeTrains.this.func_174885_b(1, 1);
                    } else {
                        TileEntityChristmasTreeTrains.this.func_174885_b(1, 0);
                    }
                }
            }
        });
    }

    public boolean hasValidLoco() {
        boolean out = false;
        for (RollingStock r : this.trains) {
            if (r.getTrainItem() == null || !r.getTrainItem().getTrainType().isLocomotive()) continue;
            out = true;
        }
        return out;
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return super.func_189518_D_();
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        NBTTagCompound syncData = super.func_189517_E_();
        this.writeSyncableDataToNBT(syncData);
        return syncData;
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.readSyncableDataFromNBT(pkt.func_148857_g());
    }

    @Override
    public void writeSyncableDataToNBT(NBTTagCompound nbt) {
        super.writeSyncableDataToNBT(nbt);
        if (this.trains[0] != null) {
            for (int i = 0; i < this.trains.length; ++i) {
                nbt.func_74776_a("train" + i + "x", this.trains[i].getPos().getX());
                nbt.func_74776_a("train" + i + "y", this.trains[i].getPos().getY());
                nbt.func_74776_a("train" + i + "yaw", this.trains[i].getPos().getYaw());
            }
        }
        nbt.func_74774_a("speed", this.speed);
        nbt.func_74757_a("forward", this.forwards);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound stackTag = new NBTTagCompound();
            stackTag.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(stackTag);
            list.func_74742_a((NBTBase)stackTag);
        }
        nbt.func_74782_a("Items", (NBTBase)list);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.firstTick) {
            this.writeSyncableDataToNBT(nbt);
        }
        return nbt;
    }

    @Override
    public void readSyncableDataFromNBT(NBTTagCompound nbt) {
        super.readSyncableDataFromNBT(nbt);
        this.forwards = nbt.func_74767_n("forward");
        this.speed = nbt.func_74771_c("speed");
        for (int i = 0; i < this.trains.length; ++i) {
            this.trains[i].setPos(new Position3F(nbt.func_74760_g("train" + i + "x"), nbt.func_74760_g("train" + i + "y"), nbt.func_74760_g("train" + i + "yaw")));
        }
        NBTTagList list = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound stackTag = list.func_150305_b(i);
            int slot = stackTag.func_74771_c("Slot") & 0xFF;
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)stackTag));
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (!this.firstTick) {
            this.readSyncableDataFromNBT(nbt);
        }
    }

    public ItemStack[][] getInventory() {
        return TRACKS;
    }

    @Override
    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.speed;
            }
            case 1: {
                if (this.forwards) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    @Override
    public void func_174885_b(int id, int value) {
        if (id == 0) {
            this.speed = (byte)value;
        } else if (id == 1) {
            this.forwards = value == 0;
        }
    }

    @Override
    public int func_174890_g() {
        return 2;
    }
}

