/*
 * Decompiled with CFR 0.152.
 */
package me.kk47.christmastrees.autoupdate;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import me.kk47.christmastrees.DecoratableChristmasTrees;
import me.kk47.christmastrees.autoupdate.Version;

public final class UpdateChecker {
    private static boolean isUpdateAvailable = false;
    private static Version newUpdate = null;

    public static final boolean isUpdateAvailable() {
        return isUpdateAvailable;
    }

    public static Version getNewUpdate() {
        return newUpdate;
    }

    public static final void checkForUpdates() {
        UpdateChecker.checkForUpdates("https://raw.githubusercontent.com/Zenith08/Mod-auto-update/master/christmasTreesVersion");
    }

    public static final void checkForUpdates(String url) {
        DecoratableChristmasTrees.logger.info("Checking for updates");
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String inputLine;
            URL input = new URL(url);
            BufferedReader in = new BufferedReader(new InputStreamReader(input.openStream()));
            while ((inputLine = in.readLine()) != null) {
                lines.add(inputLine);
            }
            in.close();
        }
        catch (MalformedURLException e) {
            DecoratableChristmasTrees.logger.info("Faild to find file");
            return;
        }
        catch (IOException e) {
            DecoratableChristmasTrees.logger.info("Faild to find file");
            return;
        }
        if (lines.size() != 0) {
            if (((String)lines.get(0)).contains("recommended")) {
                Version check = new Version((String)lines.get(0));
                if (check.isNewerThan(DecoratableChristmasTrees.VVERSION)) {
                    isUpdateAvailable = true;
                    newUpdate = check;
                    DecoratableChristmasTrees.logger.info("New Version " + check.getVersion() + " Is Available. Updating is Recommended");
                } else {
                    DecoratableChristmasTrees.logger.info("You are running the latest version of the mod");
                }
            }
        } else {
            DecoratableChristmasTrees.logger.info("Faild to read the update file");
        }
    }
}

