/*
 * Decompiled with CFR 0.152.
 */
package mod.lucky.util;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityCaveSpider;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntityGiantZombie;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntityMagmaCube;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.monster.EntitySilverfish;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.monster.EntitySnowman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityBat;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.World;

public class LuckyFunction {
    public int XOffset;
    public int ZOffset;
    public static int[] potionEffectList = new int[]{1, 2, 3, 4, 5, 6, 8, 9, 10, 12, 14};
    public static int[] mobEggList = new int[]{50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 65, 66, 90, 91, 92, 93, 94, 95, 96, 98, 100, 120};
    public static int[] mobIDList = new int[]{50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 120};
    public static String[] mobNameList = new String[]{"creeper", "skeleton", "spider", "giant zombie", "zombie", "slime", "ghast", "zombie pigman", "enderman", "cave spider", "silverfish", "blaze", "magma cube", "ender dragon", "wither", "witch", "bat", "pig", "sheep", "cow", "chicken", "squid", "wolf", "mooshroom", "snow golem", "ocelot", "iron golem", "horse", "villager"};

    public static ItemStack getRandomFireworkRocket() {
        Random random = new Random();
        ItemStack firework = new ItemStack(Items.field_151152_bP);
        NBTTagCompound mainTag = new NBTTagCompound();
        NBTTagCompound fireworksTag = new NBTTagCompound();
        NBTTagCompound explosionTag = new NBTTagCompound();
        NBTTagList explosionList = new NBTTagList();
        explosionTag.func_74774_a("Type", (byte)random.nextInt(5));
        explosionTag.func_74757_a("Flicker", random.nextBoolean());
        explosionTag.func_74757_a("Trail", random.nextBoolean());
        int colorAmount = random.nextInt(4) + 1;
        int[] colors = new int[colorAmount];
        for (int a = 0; a < colorAmount; ++a) {
            colors[a] = ItemDye.field_150922_c[random.nextInt(14)];
        }
        explosionTag.func_74783_a("Colors", colors);
        explosionList.func_74742_a((NBTBase)explosionTag);
        fireworksTag.func_74782_a("Explosions", (NBTBase)explosionList);
        fireworksTag.func_74774_a("Flight", (byte)(random.nextInt(2) + 1));
        mainTag.func_74782_a("Fireworks", (NBTBase)fireworksTag);
        firework.func_77982_d(mainTag);
        return firework;
    }

    public static int getRandomPotionDamage() {
        Random random = new Random();
        int effect = LuckyFunction.getRandomPotionEffect();
        int tier = 0;
        int extended = 0;
        int par1 = random.nextInt(3);
        if (par1 == 1) {
            tier = 32;
        }
        if (par1 == 2) {
            extended = 64;
        }
        int splash = random.nextInt(2) == 0 ? 0 : 16384;
        return effect + tier + extended + splash;
    }

    public static int getRandomPotionEffect() {
        Random random = new Random();
        return potionEffectList[random.nextInt(potionEffectList.length)];
    }

    @Deprecated
    public static EntityLiving getMobByNameOrId(World world, String name, int id) {
        if (name.equals(mobNameList[0]) || id == mobIDList[0]) {
            return new EntityCreeper(world);
        }
        if (name.equals(mobNameList[1]) || id == mobIDList[1]) {
            return new EntitySkeleton(world);
        }
        if (name.equals(mobNameList[2]) || id == mobIDList[2]) {
            return new EntitySpider(world);
        }
        if (name.equals(mobNameList[3]) || id == mobIDList[3]) {
            return new EntityGiantZombie(world);
        }
        if (name.equals(mobNameList[4]) || id == mobIDList[4]) {
            return new EntityZombie(world);
        }
        if (name.equals(mobNameList[5]) || id == mobIDList[5]) {
            return new EntitySlime(world);
        }
        if (name.equals(mobNameList[6]) || id == mobIDList[6]) {
            return new EntityGhast(world);
        }
        if (name.equals(mobNameList[7]) || id == mobIDList[7]) {
            return new EntityPigZombie(world);
        }
        if (name.equals(mobNameList[8]) || id == mobIDList[8]) {
            return new EntityEnderman(world);
        }
        if (name.equals(mobNameList[9]) || id == mobIDList[9]) {
            return new EntityCaveSpider(world);
        }
        if (name.equals(mobNameList[10]) || id == mobIDList[10]) {
            return new EntitySilverfish(world);
        }
        if (name.equals(mobNameList[11]) || id == mobIDList[11]) {
            return new EntityBlaze(world);
        }
        if (name.equals(mobNameList[12]) || id == mobIDList[12]) {
            return new EntityMagmaCube(world);
        }
        if (name.equals(mobNameList[13]) || id == mobIDList[13]) {
            return new EntityDragon(world);
        }
        if (name.equals(mobNameList[14]) || id == mobIDList[14]) {
            return new EntityWither(world);
        }
        if (name.equals(mobNameList[15]) || id == mobIDList[15]) {
            return new EntityWitch(world);
        }
        if (name.equals(mobNameList[16]) || id == mobIDList[16]) {
            return new EntityBat(world);
        }
        if (name.equals(mobNameList[17]) || id == mobIDList[17]) {
            return new EntityPig(world);
        }
        if (name.equals(mobNameList[18]) || id == mobIDList[18]) {
            return new EntitySheep(world);
        }
        if (name.equals(mobNameList[19]) || id == mobIDList[19]) {
            return new EntityCow(world);
        }
        if (name.equals(mobNameList[20]) || id == mobIDList[20]) {
            return new EntityChicken(world);
        }
        if (name.equals(mobNameList[21]) || id == mobIDList[21]) {
            return new EntitySquid(world);
        }
        if (name.equals(mobNameList[22]) || id == mobIDList[22]) {
            return new EntityWolf(world);
        }
        if (name.equals(mobNameList[23]) || id == mobIDList[23]) {
            return new EntityMooshroom(world);
        }
        if (name.equals(mobNameList[24]) || id == mobIDList[24]) {
            return new EntitySnowman(world);
        }
        if (name.equals(mobNameList[25]) || id == mobIDList[25]) {
            return new EntityOcelot(world);
        }
        if (name.equals(mobNameList[26]) || id == mobIDList[26]) {
            return new EntityIronGolem(world);
        }
        if (name.equals(mobNameList[27]) || id == mobIDList[27]) {
            return new EntityHorse(world);
        }
        if (name.equals(mobNameList[28]) || id == mobIDList[28]) {
            return new EntityVillager(world);
        }
        return null;
    }

    public static Entity getEntity(World world, int id, String name) {
        if (!EntityList.field_75627_a.containsKey(id)) {
            return EntityList.func_75620_a((String)name, (World)world);
        }
        return EntityList.func_75616_a((int)id, (World)world);
    }

    public static int getRandomMobEgg() {
        Random random = new Random();
        return mobEggList[random.nextInt(mobEggList.length)];
    }

    public void setOffset(int min, int max) {
        Random random = new Random();
        int tries = 0;
        while (true) {
            int currXOffset = max - random.nextInt(max * 2 + 1);
            int currZOffset = max - random.nextInt(max * 2 + 1);
            if (currXOffset >= min || currXOffset <= min * -1 || currZOffset >= min || currZOffset <= min * -1) {
                this.XOffset = currXOffset;
                this.ZOffset = currZOffset;
                break;
            }
            if (tries > 1000) {
                this.XOffset = max;
                this.ZOffset = 0;
                break;
            }
            ++tries;
        }
    }

    public int getXOffset() {
        return this.XOffset;
    }

    public int getZOffset() {
        return this.ZOffset;
    }

    public static int getPlayerDirection(EntityPlayer player, int accuracy) {
        int yaw = (int)player.field_70177_z;
        accuracy = 360 / accuracy;
        if (yaw < 0) {
            yaw += 360;
        }
        yaw += accuracy / 2;
        int facing = (yaw %= 360) / accuracy;
        return facing;
    }

    public static int adjustHeight(World world, int height, int posX, int posY, int posZ) {
        boolean wasHeightAdjusted = false;
        int newPosY = posY;
        int airCount = 0;
        for (int a = posY; a < posY + 16; ++a) {
            if (world.func_147439_a(posX, a, posZ).func_149662_c()) {
                airCount = 0;
                newPosY = a + 1;
            } else {
                ++airCount;
            }
            if (airCount != height) continue;
            wasHeightAdjusted = true;
            break;
        }
        if (wasHeightAdjusted) {
            return newPosY;
        }
        return -1;
    }

    public static String[] splitBracketString(String line, char seperator) {
        char[] lineChar = line.toCharArray();
        int[] point = new int[1024];
        int pointCount = 1;
        int bracketTier = 0;
        boolean inQuotes = false;
        point[0] = -1;
        for (int a = 0; a < lineChar.length; ++a) {
            if (lineChar[a] == '\"') {
                boolean quoteCanceled;
                boolean bl = quoteCanceled = a > 0 && lineChar[a - 1] == '\\';
                if (!quoteCanceled) {
                    boolean bl2 = inQuotes = !inQuotes;
                }
            }
            if (!(lineChar[a] != '(' && lineChar[a] != '[' && lineChar[a] != '{' || inQuotes)) {
                ++bracketTier;
            }
            if (!(lineChar[a] != ')' && lineChar[a] != ']' && lineChar[a] != '}' || inQuotes)) {
                --bracketTier;
            }
            if (lineChar[a] != seperator || bracketTier != 0 || inQuotes) continue;
            point[pointCount] = a;
            ++pointCount;
        }
        point[pointCount] = line.length();
        String[] contents = new String[pointCount];
        for (int a = 0; a < contents.length; ++a) {
            contents[a] = line.substring(point[a] + 1, point[a + 1]);
        }
        return contents;
    }

    public static NBTTagList getNBTTagListFromArray(String[] array) {
        NBTTagList nbttagList = new NBTTagList();
        for (String element : array) {
            nbttagList.func_74742_a((NBTBase)new NBTTagString(element));
        }
        return nbttagList;
    }

    public static String[] getArrayFromNBTTagList(NBTTagList nbttagList) {
        String[] array = new String[nbttagList == null ? 0 : nbttagList.func_74745_c()];
        for (int a = 0; a < array.length; ++a) {
            array[a] = nbttagList.func_150307_f(a);
        }
        return array;
    }
}

