/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore;

import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscationUtils;
import com.spacechase0.minecraft.spacecore.block.Blocks;
import com.spacechase0.minecraft.spacecore.item.Items;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.LanguageRegistry;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public abstract class BaseMod {
    protected final String mod;
    private Configuration config;
    private Blocks blocks;
    private Items items;

    public BaseMod(String theMod) {
        this.mod = theMod;
        this.init("Blocks");
        this.init("Items");
        this.setSubClassField("blocks");
        this.setSubClassField("items");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.config.load();
        this.setSubClassField("config");
        if (this.blocks != null) {
            this.blocks.register(this, this.config);
        }
        if (this.items != null) {
            this.items.register(this, this.config);
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.registerLanguage();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        this.config.save();
    }

    public boolean isExperimentalEnabled() {
        Property prop = this.config.get("general", "experimental", false);
        prop.comment = "USE WITH CAUTION! BACKUP YOUR WORLDS! Disabled by default for a reason.";
        return ObfuscationUtils.isRuntimeDeobfuscated() ? prop.getBoolean(false) : true;
    }

    private void init(String str) {
        String singular = str.substring(0, str.length() - 1);
        String singularLower = singular.toLowerCase();
        try {
            Class<?> c = this.getClass();
            String pkg = c.getName().substring(0, c.getName().lastIndexOf(46));
            Class<?> objClass = Class.forName(pkg + "." + singularLower + "." + (this.mod.equals("spacecore") ? "Core" : "") + str);
            Object obj = objClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            BaseMod.class.getDeclaredField(str.toLowerCase()).set(this, obj);
        }
        catch (ClassNotFoundException exception) {
        }
        catch (InstantiationException exception) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void setSubClassField(String str) {
        try {
            Field thisField = BaseMod.class.getDeclaredField(str);
            Object obj = thisField.get(this);
            if (obj != null) {
                Field otherField = this.getClass().getDeclaredField(str);
                otherField.set(this, obj);
            }
        }
        catch (NoSuchFieldException exception) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void registerLanguage() {
        try {
            String line;
            String path = "/assets/" + this.mod + "/lang/lang.txt";
            InputStream stream = this.getClass().getResourceAsStream(path);
            InputStreamReader reader = new InputStreamReader(stream);
            BufferedReader buffer = new BufferedReader(reader);
            while ((line = buffer.readLine()) != null) {
                this.registerLanguage(line);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void registerLanguage(String lang) {
        String path = "/assets/" + this.mod + "/lang/" + lang + ".lang";
        LanguageRegistry.instance().loadLocalization(path, lang, false);
    }
}

