/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.asm.network;

import com.spacechase0.minecraft.spacecore.asm.SpaceCoreLog;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscatedMethod;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscatedType;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscationUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class PacketInterceptTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        ObfuscatedType netMan = null;
        ObfuscatedType obfClass = ObfuscatedType.fromObf(classNode.superName);
        if (!obfClass.deobfName.equals("net/minecraft/network/Packet")) {
            for (String obj : classNode.interfaces) {
                obfClass = ObfuscatedType.fromObf(classNode.superName);
                if (!obfClass.deobfName.equals("net/minecraft/network/NetworkManager")) continue;
                netMan = obfClass;
                break;
            }
            if (netMan == null) {
                return bytes;
            }
        }
        SpaceCoreLog.fine("Examining class " + transformedName + "...");
        for (MethodNode method : classNode.methods) {
            ObfuscatedMethod obfMethod = ObfuscatedMethod.fromObf(name, method.name, method.desc);
            String mappedProcessFunc = ObfuscatedMethod.fromSrg((String)"net/minecraft/network/Packet", (String)"func_148833_a", (String)"(Lnet/minecraft/network/INetHandler;)V").obfName;
            String mappedSendFunc = ObfuscatedMethod.fromSrg((String)"net/minecraft/network/NetworkManager", (String)"func_150725_a", (String)"(Lnet/minecraft/network/Packet;[Lio/netty/util/concurrent/GenericFutureListener;)V").obfName;
            if (netMan == null && obfMethod.obfName.equals(mappedProcessFunc) && obfMethod.deobfDesc.equals("(Lnet/minecraft/network/INetHandler;)V")) {
                SpaceCoreLog.fine("Found processPacket(...) for " + transformedName);
                this.injectProcessInterceptor(method, classNode.superName, name, method.desc.substring(method.desc.indexOf(76) + 1, method.desc.indexOf(59)));
                continue;
            }
            if (netMan == null || !obfMethod.obfName.equals(mappedSendFunc) || !obfMethod.deobfDesc.equals("(Lnet/minecraft/network/packet/Packet;)V")) continue;
            SpaceCoreLog.fine("Found addToSendQueue(...) for " + transformedName);
            this.injectSendInterceptor(method, netMan.obfName, method.desc.substring(method.desc.indexOf(76) + 1, method.desc.indexOf(59)));
        }
        ClassWriter writer = new ClassWriter(3);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void injectProcessInterceptor(MethodNode method, String parent, String realName, String methodParam) {
        SpaceCoreLog.fine("Injecting at beginning of method....");
        String realParent = ObfuscationUtils.asmify(parent);
        String realClass = ObfuscationUtils.asmify(realName);
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new TypeInsnNode(192, realParent));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/spacechase0/minecraft/spacecore/network/PacketInterceptor", "intercept", "(L" + methodParam + ";L" + realParent + ";)V"));
        method.instructions.insertBefore(method.instructions.get(0), instructions);
    }

    private void injectSendInterceptor(MethodNode method, String parent, String methodParam) {
        SpaceCoreLog.fine("Injecting at beginning of method....");
        String realParent = ObfuscationUtils.asmify(parent);
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new TypeInsnNode(192, realParent));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/spacechase0/minecraft/spacecore/network/PacketInterceptor", "intercept", "(L" + realParent + ";L" + methodParam + ";)V"));
        method.instructions.insertBefore(method.instructions.get(0), instructions);
    }
}

