/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.asm.render;

import com.spacechase0.minecraft.spacecore.asm.SpaceCoreLog;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscatedMethod;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscatedType;
import com.spacechase0.minecraft.spacecore.asm.obf.ObfuscationUtils;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class TextureInterceptTransformer
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (!transformedName.equals("net.minecraft.client.renderer.texture.TextureManager")) {
            return bytes;
        }
        SpaceCoreLog.fine("Found TextureManager.");
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode method : classNode.methods) {
            String obfType;
            ObfuscatedMethod bindTexture;
            ObfuscatedMethod obfMethod = ObfuscatedMethod.fromObf(name, method.name, method.desc);
            if (!obfMethod.equals(bindTexture = ObfuscatedMethod.fromMcp(obfType = ObfuscationUtils.asmify(transformedName), "bindTexture", "(Lnet/minecraft/util/ResourceLocation;)V"))) continue;
            SpaceCoreLog.fine("Found TextureManager.bindTexture(...).");
            this.injectInterceptor(method, name);
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private void injectInterceptor(MethodNode method, String realName) {
        SpaceCoreLog.fine("Injecting into beginning of method.");
        String stackClass = ObfuscationUtils.asmify(realName);
        ObfuscatedType resLoc = ObfuscatedType.fromDeobf("net/minecraft/util/ResourceLocation");
        InsnList instructions = new InsnList();
        instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        instructions.add((AbstractInsnNode)new MethodInsnNode(184, "com/spacechase0/minecraft/spacecore/client/render/TextureOverrides", "intercept", "(L" + resLoc.obfName + ";)L" + resLoc.obfName + ";"));
        instructions.add((AbstractInsnNode)new VarInsnNode(58, 1));
        method.instructions.insertBefore(method.instructions.getFirst(), instructions);
    }
}

