/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.block;

import com.spacechase0.minecraft.spacecore.tileentity.CustomSmelterTileEntity;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFurnace;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public abstract class CustomSmelterBlock
extends BlockFurnace {
    protected final boolean active;
    protected IIcon mainIcon;

    public CustomSmelterBlock(boolean theActive) {
        super(theActive);
        this.active = theActive;
    }

    public abstract String getIconBase();

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        this.mainIcon = register.func_94245_a(this.getIconBase() + ":" + this.func_149739_a().substring(5) + (this.active ? "Active" : "Idle"));
    }

    public IIcon func_149691_a(int side, int meta) {
        return side != meta ? this.field_149761_L : this.mainIcon;
    }

    public Item func_149650_a(int par1, Random par2Random, int par3) {
        return Item.func_150898_a((Block)this.getIdleBlock());
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int par6, float par7, float par8, float par9) {
        if (world.field_72995_K) {
            return true;
        }
        this.openGui(world, x, y, z, player);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        CustomSmelterTileEntity smelter = (CustomSmelterTileEntity)world.func_147438_o(x, y, z);
        if (smelter == null || CustomSmelterBlock.getKeepFurnaceInventory()) {
            return;
        }
        for (int i = 0; i < smelter.func_70302_i_(); ++i) {
            ItemStack stack = smelter.func_70301_a(i);
            if (stack == null) continue;
            Random rand = new Random();
            float fx = rand.nextFloat() * 0.8f + 0.1f;
            float fy = rand.nextFloat() * 0.8f + 0.1f;
            float fz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entity = new EntityItem(world, (double)((float)x + fx), (double)((float)y + fy), (double)((float)z + fz), stack.func_77946_l());
            float f3 = 0.05f;
            entity.field_70159_w = (float)rand.nextGaussian() * f3;
            entity.field_70181_x = (float)rand.nextGaussian() * f3 + 0.2f;
            entity.field_70179_y = (float)rand.nextGaussian() * f3;
            world.func_72838_d((Entity)entity);
            smelter.func_70298_a(i, stack.field_77994_a);
        }
        world.func_147475_p(x, y, z);
    }

    public abstract TileEntity createNewTileEntity(World var1);

    public static void updateBlockState(boolean burning, World world, int x, int y, int z) {
        int meta = world.func_72805_g(x, y, z);
        TileEntity entity = world.func_147438_o(x, y, z);
        CustomSmelterBlock.setKeepFurnaceInventory(true);
        CustomSmelterBlock block = (CustomSmelterBlock)world.func_147439_a(x, y, z);
        if (block.getActiveBlock() == block.getIdleBlock()) {
            CustomSmelterBlock.setKeepFurnaceInventory(false);
            return;
        }
        if (burning) {
            world.func_147449_b(x, y, z, block.getActiveBlock());
        } else {
            world.func_147449_b(x, y, z, block.getIdleBlock());
        }
        CustomSmelterBlock.setKeepFurnaceInventory(false);
        world.func_72921_c(x, y, z, meta, 2);
        if (entity != null) {
            entity.func_145829_t();
            world.func_147455_a(x, y, z, entity);
        }
    }

    private static boolean getKeepFurnaceInventory() {
        try {
            Class<BlockFurnace> c = BlockFurnace.class;
            Field field = c.getDeclaredFields()[2];
            field.setAccessible(true);
            return (Boolean)field.get(null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private static void setKeepFurnaceInventory(boolean keep) {
        try {
            Class<BlockFurnace> c = BlockFurnace.class;
            Field field = c.getDeclaredFields()[2];
            field.setAccessible(true);
            field.setBoolean(null, keep);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected abstract void openGui(World var1, int var2, int var3, int var4, EntityPlayer var5);

    protected abstract Block getActiveBlock();

    protected abstract Block getIdleBlock();
}

