/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.client.render.block;

import com.spacechase0.minecraft.spacecore.block.ConnectedBlock;
import com.spacechase0.minecraft.spacecore.client.render.block.GenericConnectedRenderer;
import java.lang.reflect.Method;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class ConnectedPaneRenderer
extends GenericConnectedRenderer {
    public ConnectedPaneRenderer(String theMod, Block theBlock) {
        super(theMod, theBlock);
    }

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks render) {
        super.renderInventoryBlock(block, metadata, modelId, render);
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks render) {
        super.renderWorldBlock(world, x, y, z, block, modelId, render);
        this.renderBlockPane((BlockPane)block, world, x, y, z, render);
        return true;
    }

    private void renderBlockPane(BlockPane pane, IBlockAccess world, int x, int y, int z, RenderBlocks render) {
        IIcon[] icons;
        boolean connU = pane.canPaneConnectTo(world, x, y + 1, z, ForgeDirection.UP);
        boolean connD = pane.canPaneConnectTo(world, x, y - 1, z, ForgeDirection.DOWN);
        boolean connN = pane.canPaneConnectTo(world, x, y, z - 1, ForgeDirection.NORTH);
        boolean connS = pane.canPaneConnectTo(world, x, y, z + 1, ForgeDirection.SOUTH);
        boolean connW = pane.canPaneConnectTo(world, x - 1, y, z, ForgeDirection.WEST);
        boolean connE = pane.canPaneConnectTo(world, x + 1, y, z, ForgeDirection.EAST);
        float vStart = 0.0f;
        float vEnd = 1.0f;
        float hStart = 0.0f;
        float hEnd = 1.0f;
        if (connN || connS || connW || connE) {
            hEnd = -1.0f;
            hStart = -1.0f;
            vEnd = -1.0f;
            vStart = -1.0f;
            if (connN) {
                vStart = 0.0f;
                if (!connS) {
                    vEnd = 0.5675f;
                }
            }
            if (connS) {
                vEnd = 1.0f;
                if (!connN) {
                    vStart = 0.4375f;
                }
            }
            if (connW) {
                hStart = 0.0f;
                if (!connE) {
                    hEnd = 0.5675f;
                }
            }
            if (connE) {
                hEnd = 1.0f;
                if (!connW) {
                    hStart = 0.4375f;
                }
            }
        }
        Tessellator tess = Tessellator.field_78398_a;
        int meta = world.func_72805_g(x, y, z);
        IIcon paneTop = ((ConnectedBlock)pane).getBorderIcon(meta);
        if (vStart >= 0.0f && vEnd >= 0.0f) {
            icons = new IIcon[]{paneTop, paneTop, paneTop, paneTop, pane.func_149691_a(ForgeDirection.WEST.ordinal(), 0), pane.func_149691_a(ForgeDirection.EAST.ordinal(), 0)};
            this.renderStrip(icons, x, y, z, new boolean[]{!connD, !connU, !connN, !connS, true, true}, 4, render, vStart, vEnd);
        }
        if (hStart >= 0.0f && hEnd >= 0.0f) {
            icons = new IIcon[]{paneTop, paneTop, pane.func_149691_a(ForgeDirection.NORTH.ordinal(), 0), pane.func_149691_a(ForgeDirection.SOUTH.ordinal(), 0), paneTop, paneTop};
            this.renderStrip(icons, x, y, z, new boolean[]{!connD, !connU, true, true, !connW, !connE}, 2, render, hStart, hEnd);
        }
    }

    private void renderStrip(IIcon[] icons, float x, float y, float z, boolean[] render, int dirIndex, RenderBlocks blocks, float primStart, float primEnd) {
        int i;
        Tessellator tess = Tessellator.field_78398_a;
        float rx = 0.0f;
        float ry = 0.0f;
        float rz = 0.0f;
        float rw = 1.0f;
        float rh = 1.0f;
        float rd = 1.0f;
        if (dirIndex == 2) {
            rz += 0.4375f;
            rd = 0.125f;
            rx = primStart;
            rw = primEnd - primStart;
            blocks.field_147865_v = 1;
            blocks.field_147867_u = 1;
        } else if (dirIndex == 4) {
            rx += 0.4375f;
            rw = 0.125f;
            rz = primStart;
            rd = primEnd - primStart;
        }
        blocks.func_147782_a((double)rx, (double)ry, (double)rz, (double)(rx + rw), (double)(ry + rh), (double)(rz + rd));
        String[] funcs = new String[]{"func_147768_a", "func_147806_b", "func_147761_c", "func_147734_d", "func_147798_e", "func_147764_f"};
        FaceRenderer[] faces = new FaceRenderer[funcs.length];
        for (i = 0; i < faces.length; ++i) {
            faces[i] = new FaceRenderer(funcs[i], i);
        }
        FaceRenderer.block = (Block)this.block;
        FaceRenderer.render = blocks;
        tess.func_78378_d(-1);
        for (i = 0; i < 6; ++i) {
            if (!render[i]) continue;
            faces[i].render(x, y, z, icons[i]);
        }
        if (dirIndex == 2) {
            blocks.field_147865_v = 0;
            blocks.field_147867_u = 0;
        }
    }

    private static class FaceRenderer {
        private Method method;
        private int side;
        public static RenderBlocks render;
        public static Block block;

        public FaceRenderer(String theMethod, int theSide) {
            try {
                Class<RenderBlocks> c = RenderBlocks.class;
                this.method = c.getDeclaredMethod(theMethod, Block.class, Double.TYPE, Double.TYPE, Double.TYPE, IIcon.class);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.method = null;
            }
            this.side = theSide;
        }

        public void render(double x, double y, double z, IIcon icon) {
            try {
                this.method.invoke((Object)render, block, x, y, z, icon);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

