/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.client.render.block;

import com.spacechase0.minecraft.spacecore.block.ConnectedBlock;
import com.spacechase0.minecraft.spacecore.client.render.block.GenericBlockRenderer;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class GenericConnectedRenderer
extends GenericBlockRenderer {
    private final String mod;
    protected final ConnectedBlock block;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int UP = 4;
    private static final int DOWN = 8;

    public GenericConnectedRenderer(String theMod, Block theBlock) {
        this.mod = theMod;
        this.block = (ConnectedBlock)theBlock;
    }

    @Override
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks render) {
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.block.setIconArray(this.block.getDefaultIconArray(metadata));
        super.renderInventoryBlock(block, metadata, modelId, render);
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks render) {
        this.block.setIconArray(new IIcon[]{this.getIconForSide(world, x, y, z, ForgeDirection.DOWN), this.getIconForSide(world, x, y, z, ForgeDirection.UP), this.getIconForSide(world, x, y, z, ForgeDirection.NORTH), this.getIconForSide(world, x, y, z, ForgeDirection.SOUTH), this.getIconForSide(world, x, y, z, ForgeDirection.WEST), this.getIconForSide(world, x, y, z, ForgeDirection.EAST)});
        return false;
    }

    protected IIcon getIconForSide(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return this.block.getConnectedIcon(world.func_72805_g(x, y, z), this.getIndexForSide(world, x, y, z, dir));
    }

    private int getIndexForSide(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        int[] upDirs = new int[]{2, 2, 1, 1, 1, 1};
        int[] leftDirs = new int[]{4, 4, 5, 4, 2, 3};
        leftDirs[2] = ForgeDirection.getOrientation((int)leftDirs[2]).getOpposite().ordinal();
        leftDirs[5] = ForgeDirection.getOrientation((int)leftDirs[5]).getOpposite().ordinal();
        ForgeDirection up = ForgeDirection.getOrientation((int)upDirs[dir.ordinal()]);
        ForgeDirection down = up.getOpposite();
        ForgeDirection left = ForgeDirection.getOrientation((int)leftDirs[dir.ordinal()]);
        ForgeDirection right = left.getOpposite();
        int texIndex = 0;
        if (world.func_147439_a(x + up.offsetX, y + up.offsetY, z + up.offsetZ) == this.block) {
            texIndex |= 4;
        }
        if (world.func_147439_a(x + down.offsetX, y + down.offsetY, z + down.offsetZ) == this.block) {
            texIndex |= 8;
        }
        if (world.func_147439_a(x + left.offsetX, y + left.offsetY, z + left.offsetZ) == this.block) {
            texIndex |= 1;
        }
        if (world.func_147439_a(x + right.offsetX, y + right.offsetY, z + right.offsetZ) == this.block) {
            texIndex |= 2;
        }
        return texIndex;
    }
}

