/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.craftableenchantmentbooks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class EnchantedBookRecipes
implements IRecipe {
    private static List<Recipe> recipes = new ArrayList<Recipe>();

    public boolean func_77569_a(InventoryCrafting inv, World world) {
        return this.findMatchingRecipe(inv) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        return this.findMatchingRecipe(inv);
    }

    public int func_77570_a() {
        return 3;
    }

    public ItemStack func_77571_b() {
        return null;
    }

    private ItemStack findMatchingRecipe(InventoryCrafting inv) {
        for (int r = 0; r < recipes.size(); ++r) {
            Recipe recipe = recipes.get(r);
            boolean hasBook = false;
            boolean[] matches = new boolean[recipe.recipe.length];
            for (int i = 0; i < recipe.recipe.length; ++i) {
                matches[i] = recipe.recipe[i] == null;
            }
            boolean stop = false;
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null) continue;
                if (!hasBook && recipe.in == null && stack.func_77973_b() == Items.field_151122_aG) {
                    hasBook = true;
                    continue;
                }
                if (!hasBook && stack.func_77973_b() == Items.field_151134_bR && recipe.in != null) {
                    ItemStack in = Items.field_151134_bR.func_92111_a(recipe.in);
                    NBTTagList inTag = (NBTTagList)in.func_77978_p().func_74781_a("StoredEnchantments");
                    if (!stack.func_77969_a(in) || !stack.func_77978_p().func_74781_a("StoredEnchantments").equals((Object)inTag)) continue;
                    hasBook = true;
                    continue;
                }
                boolean matched = false;
                for (int m = 0; m < recipe.recipe.length; ++m) {
                    ItemStack mat = recipe.recipe[m];
                    if (mat == null || matches[m] || !stack.func_77969_a(mat)) continue;
                    matches[m] = true;
                    matched = true;
                    break;
                }
                if (matched) continue;
                stop = true;
                break;
            }
            if (stop) continue;
            boolean found = hasBook;
            for (int i = 0; i < matches.length; ++i) {
                found = found && matches[i];
            }
            if (!found) continue;
            return Items.field_151134_bR.func_92111_a(recipe.out);
        }
        return null;
    }

    public static void addEnchantmentRecipe(ItemStack[] items, EnchantmentData out, EnchantmentData in) {
        if (items.length > 8) {
            throw new IllegalArgumentException("8 itemstacks must be provided!");
        }
        if (out == null) {
            throw new IllegalArgumentException("Enchantment must be provided for output!");
        }
        Recipe r = new Recipe();
        r.out = out;
        r.in = in;
        r.recipe = items;
        if (items.length < 8) {
            ItemStack[] newItems = new ItemStack[8];
            int i = 0;
            while (i < items.length) {
                newItems[i] = items[i++];
            }
            r.recipe = newItems;
        }
        recipes.add(r);
    }

    private static class Recipe {
        public EnchantmentData out;
        public EnchantmentData in;
        public ItemStack[] recipe = new ItemStack[8];

        private Recipe() {
        }
    }
}

