/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.network;

import com.spacechase0.minecraft.spacecore.network.Packet;
import com.spacechase0.minecraft.spacecore.network.PacketProcesser;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.EnumMap;
import net.minecraft.entity.player.EntityPlayerMP;

public abstract class PacketCodec
extends FMLIndexedMessageToMessageCodec<Packet>
implements ChannelHandler {
    private EnumMap<Side, FMLEmbeddedChannel> channels = NetworkRegistry.INSTANCE.newChannel(Loader.instance().activeModContainer().getModId(), new ChannelHandler[]{this, new PacketProcesser(this)});

    public void encodeInto(ChannelHandlerContext context, Packet packet, ByteBuf buffer) throws Exception {
        packet.write(buffer);
    }

    public void decodeInto(ChannelHandlerContext context, ByteBuf buffer, Packet packet) {
        packet.read(buffer);
    }

    public void sendToAll(Packet packet) {
        Channel channel = (Channel)this.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        channel.writeAndFlush((Object)packet);
    }

    public void sendToPlayer(EntityPlayerMP player, Packet packet) {
        Channel channel = (Channel)this.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        channel.writeAndFlush((Object)packet);
    }

    public void sendToNearby(NetworkRegistry.TargetPoint pos, Packet packet) {
        Channel channel = (Channel)this.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)pos);
        channel.writeAndFlush((Object)packet);
    }

    public void sendToDimension(int dim, Packet packet) {
        Channel channel = (Channel)this.channels.get(Side.SERVER);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dim);
        channel.writeAndFlush((Object)packet);
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer(Packet packet) {
        System.out.println("wake up!");
        Channel channel = (Channel)this.channels.get(Side.CLIENT);
        channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        channel.writeAndFlush((Object)packet);
    }

    protected void addPacket(Packet packet) {
        this.addDiscriminator(packet.getId(), packet.getClass());
    }
}

