/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.recipe;

import com.spacechase0.minecraft.spacecore.SpaceCore;
import com.spacechase0.minecraft.spacecore.asm.SpaceCoreLog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class RecipeSimplifier {
    public static void handleRecipe(List<DisplayStack> items, IRecipe curr, int craftLeft, int craftTop) {
        if (curr instanceof ShapedRecipes) {
            ShapedRecipes recipe = (ShapedRecipes)curr;
            RecipeSimplifier.handleShaped(items, recipe, craftLeft, craftTop);
        } else if (curr instanceof ShapelessRecipes) {
            ShapelessRecipes recipe = (ShapelessRecipes)curr;
            RecipeSimplifier.handleShapeless(items, recipe, craftLeft, craftTop);
        } else if (curr instanceof ShapelessOreRecipe) {
            ShapelessOreRecipe recipe = (ShapelessOreRecipe)curr;
            RecipeSimplifier.handleShapelessOre(items, recipe, craftLeft, craftTop);
        } else if (curr instanceof ShapedOreRecipe) {
            ShapedOreRecipe recipe = (ShapedOreRecipe)curr;
            RecipeSimplifier.handleShapedOre(items, recipe, craftLeft, craftTop);
        }
    }

    private static void handleShaped(List<DisplayStack> items, ShapedRecipes recipe, int craftLeft, int craftTop) {
        for (int ix = 0; ix < recipe.field_77576_b; ++ix) {
            for (int iy = 0; iy < recipe.field_77577_c; ++iy) {
                ItemStack stack = recipe.field_77574_d[ix + iy * recipe.field_77576_b];
                if (stack == null) continue;
                ItemStack[] displayItems = RecipeSimplifier.getAliases(stack);
                int x = craftLeft + 1 + ix * 18;
                int y = craftTop + 1 + iy * 18;
                items.add(new DisplayStack(x, y, displayItems));
            }
        }
        items.add(new DisplayStack(craftLeft + 18 - 4 + 5, craftTop + 90 + 5, recipe.func_77571_b()));
    }

    private static void handleShapeless(List<DisplayStack> items, ShapelessRecipes recipe, int craftLeft, int craftTop) {
        for (int i = 0; i < recipe.field_77579_b.size(); ++i) {
            int ix = i % 3;
            int iy = i / 3;
            ItemStack stack = (ItemStack)recipe.field_77579_b.get(i);
            if (stack == null) continue;
            ItemStack[] displayItems = RecipeSimplifier.getAliases(stack);
            int x = craftLeft + 1 + ix * 18;
            int y = craftTop + 1 + iy * 18;
            items.add(new DisplayStack(x, y, stack));
        }
        items.add(new DisplayStack(craftLeft + 18 - 4 + 5, craftTop + 90 + 5, recipe.func_77571_b()));
    }

    private static void handleShapedOre(List<DisplayStack> items, ShapedOreRecipe recipe, int craftLeft, int craftTop) {
        int width = -1;
        int height = -1;
        Class<ShapedOreRecipe> c = ShapedOreRecipe.class;
        Field f1 = c.getDeclaredFields()[4];
        f1.setAccessible(true);
        Field f2 = c.getDeclaredFields()[5];
        f2.setAccessible(true);
        try {
            width = (Integer)f1.get(recipe);
            height = (Integer)f2.get(recipe);
        }
        catch (IllegalAccessException exception) {
            // empty catch block
        }
        for (int ix = 0; ix < width; ++ix) {
            for (int iy = 0; iy < height; ++iy) {
                Object obj = recipe.getInput()[ix + iy * width];
                if (obj == null) continue;
                ItemStack[] stack = RecipeSimplifier.getAliases(obj);
                int x = craftLeft + 1 + ix * 18;
                int y = craftTop + 1 + iy * 18;
                items.add(new DisplayStack(x, y, stack));
            }
        }
        items.add(new DisplayStack(craftLeft + 18 - 4 + 5, craftTop + 90 + 5, recipe.func_77571_b()));
    }

    private static void handleShapelessOre(List<DisplayStack> items, ShapelessOreRecipe recipe, int craftLeft, int craftTop) {
        for (int i = 0; i < recipe.getInput().size(); ++i) {
            int ix = i % 3;
            int iy = i / 3;
            Object obj = recipe.getInput().get(i);
            ItemStack[] stack = RecipeSimplifier.getAliases(obj);
            int x = craftLeft + 1 + ix * 18;
            int y = craftTop + 1 + iy * 18;
            items.add(new DisplayStack(x, y, stack));
        }
        items.add(new DisplayStack(craftLeft + 18 - 4 + 5, craftTop + 90 + 5, recipe.func_77571_b()));
    }

    public static ItemStack[] getAliases(Object obj) {
        ItemStack[] stack = null;
        if (obj instanceof ItemStack) {
            ItemStack s = (ItemStack)obj;
            if (s.func_77960_j() == Short.MAX_VALUE) {
                ArrayList<ItemStack> results = new ArrayList<ItemStack>();
                if (SpaceCore.proxy.isClient()) {
                    RecipeSimplifier.addSubItems(results, s);
                }
                results.add(s);
                stack = results.toArray(new ItemStack[0]);
            } else {
                stack = new ItemStack[]{s};
            }
        } else if (obj instanceof Item || obj instanceof Block) {
            Item item = null;
            item = obj instanceof Item ? (Item)obj : new ItemStack((Block)obj).func_77973_b();
            ArrayList<ItemStack> list = new ArrayList<ItemStack>();
            if (SpaceCore.proxy.isClient()) {
                RecipeSimplifier.addSubItems(list, new ItemStack(item));
            }
            list.add(new ItemStack(item, 1, Short.MAX_VALUE));
            stack = list.toArray(new ItemStack[0]);
        } else if (obj instanceof ArrayList) {
            ArrayList<ItemStack> results = new ArrayList<ItemStack>();
            for (Object o : (ArrayList)obj) {
                ItemStack tmp = (ItemStack)o;
                Item item = tmp.func_77973_b();
                if (tmp.func_77960_j() == Short.MAX_VALUE) {
                    if (SpaceCore.proxy.isClient()) {
                        RecipeSimplifier.addSubItems(results, tmp);
                    }
                    results.add(tmp);
                    continue;
                }
                results.add(tmp);
            }
            stack = results.toArray(new ItemStack[0]);
        } else {
            if (obj instanceof String) {
                return RecipeSimplifier.getAliases(OreDictionary.getOres((String)((String)obj)));
            }
            throw new IllegalArgumentException("Bad item? " + obj.getClass() + " " + obj);
        }
        if (stack.length <= 0) {
            SpaceCoreLog.severe("EMPTY ALIASES! " + obj);
        }
        return stack;
    }

    public static boolean isOre(String type, ItemStack stack) {
        ArrayList stacks = OreDictionary.getOres((String)type);
        for (ItemStack ore : stacks) {
            if (ore.func_77973_b() != stack.func_77973_b()) continue;
            if (ore.func_77960_j() == Short.MAX_VALUE) {
                return true;
            }
            if (ore.func_77960_j() != stack.func_77960_j()) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(ItemStack a, ItemStack b) {
        if (a.func_77973_b() == b.func_77973_b()) {
            if (a.func_77960_j() == Short.MAX_VALUE) {
                return true;
            }
            return a.func_77960_j() == b.func_77960_j();
        }
        return false;
    }

    private static void addSubItems(List list, ItemStack stack) {
        stack.func_77973_b().func_150895_a(stack.func_77973_b(), RecipeSimplifier.getCreativeTab(stack.func_77973_b()), list);
    }

    private static CreativeTabs getCreativeTab(Item item) {
        try {
            Field f = Item.class.getDeclaredFields()[2];
            return (CreativeTabs)f.get(item);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static class DisplayStack {
        public int x;
        public int y;
        public int z = 0;
        public ItemStack[] stack;

        public DisplayStack(int theX, int theY, ItemStack theStack) {
            this.x = theX;
            this.y = theY;
            this.stack = new ItemStack[]{theStack};
        }

        public DisplayStack(int theX, int theY, ItemStack ... theStack) {
            this.x = theX;
            this.y = theY;
            this.stack = theStack;
            if (this.stack.length == 0) {
                throw new IllegalArgumentException("There must be at least one item to display.");
            }
        }

        public ItemStack getCurrent() {
            int displayIndex = (int)(System.currentTimeMillis() / 1000L % (long)this.stack.length);
            return this.stack[displayIndex];
        }

        public String toString() {
            return "DisplayStack{x=" + this.x + " y=" + this.y + " stack=" + this.stack + "}";
        }
    }
}

