/*
 * Decompiled with CFR 0.152.
 */
package com.spacechase0.minecraft.spacecore.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class CsvFile {
    private List<List<String>> rows = new ArrayList<List<String>>();

    public CsvFile(InputStream stream) throws IOException {
        this.loadFromStream(stream);
    }

    public void loadFromStream(InputStream stream) throws IOException {
        String line;
        InputStreamReader reader = new InputStreamReader(stream);
        BufferedReader buffer = new BufferedReader(reader);
        while ((line = buffer.readLine()) != null) {
            if (line.length() == 0) {
                this.rows.add(new ArrayList());
            }
            ArrayList<String> cells = new ArrayList<String>();
            String data = "";
            boolean escaped = false;
            boolean quoted = false;
            for (int ic = 0; ic < line.length(); ++ic) {
                char c = line.charAt(ic);
                if (c == '\\') {
                    escaped = !escaped;
                    data = data + c;
                    continue;
                }
                if (c == '\"' && !escaped) {
                    quoted = !quoted;
                    continue;
                }
                if (c == ',' && !quoted) {
                    cells.add(data);
                    data = "";
                    continue;
                }
                data = data + c;
            }
            cells.add(data);
            this.rows.add(cells);
        }
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getCellCount(int row) {
        return this.rows.get(row).size();
    }

    public String getCell(int row, int cell) {
        return this.rows.get(row).get(cell);
    }
}

