/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap;

import com.thevoxelbox.voxelmap.MapSettingsManager;
import com.thevoxelbox.voxelmap.interfaces.IColorManager;
import com.thevoxelbox.voxelmap.interfaces.IVoxelMap;
import com.thevoxelbox.voxelmap.util.BlockIDRepository;
import com.thevoxelbox.voxelmap.util.GLUtils;
import com.thevoxelbox.voxelmap.util.ImageUtils;
import com.thevoxelbox.voxelmap.util.ReflectionUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class ColorManager
implements IColorManager {
    private IVoxelMap master;
    private MapSettingsManager options = null;
    azd game = null;
    private List packs = null;
    private BufferedImage terrainBuff = null;
    private BufferedImage colorPicker;
    private int mapImageInt = -1;
    private int[] blockColors = new int[86016];
    private int[] blockColorsWithDefaultTint = new int[86016];
    private static int COLOR_NOT_LOADED = -65281;
    private Set<Integer> biomeTintsAvailable = new HashSet<Integer>();
    private boolean hdInstalled = false;
    private boolean optifineInstalled = false;
    private HashMap<String, Integer[]> blockTintTables = new HashMap();
    private Set<Integer> biomeTextureAvailable = new HashSet<Integer>();
    private HashMap<String, Integer> blockBiomeSpecificColors = new HashMap();
    private String renderPassThreeBlendMode;
    private final Object tpLoadLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColorManager(IVoxelMap master) {
        this.master = master;
        this.options = master.getMapOptions();
        this.game = azd.A();
        this.optifineInstalled = false;
        Field ofProfiler = null;
        try {
            ofProfiler = azw.class.getDeclaredField("ofProfiler");
        }
        catch (SecurityException ex) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        finally {
            if (ofProfiler != null) {
                this.optifineInstalled = true;
            }
        }
        this.hdInstalled = ReflectionUtils.classExists("com.prupe.mcpatcher.ctm.CTMUtils");
    }

    @Override
    public int getMapImageInt() {
        return this.mapImageInt;
    }

    @Override
    public int getAirColor() {
        return this.blockColors[BlockIDRepository.airID];
    }

    @Override
    public Set<Integer> getBiomeTintsAvailable() {
        return this.biomeTintsAvailable;
    }

    @Override
    public boolean isOptifineInstalled() {
        return this.optifineInstalled;
    }

    @Override
    public HashMap<String, Integer[]> getBlockTintTables() {
        return this.blockTintTables;
    }

    @Override
    public BufferedImage getColorPicker() {
        return this.colorPicker;
    }

    @Override
    public boolean checkForChanges() {
        if (this.packs == null || !this.packs.equals(this.game.u.l)) {
            this.loadColors();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadColors() {
        this.packs = new ArrayList(this.game.u.l);
        BlockIDRepository.getIDs();
        this.loadColorPicker();
        this.loadMapImage();
        this.loadTexturePackTerrainImage();
        Object object = this.tpLoadLock;
        synchronized (object) {
            try {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Arrays.fill(ColorManager.this.blockColors, COLOR_NOT_LOADED);
                        Arrays.fill(ColorManager.this.blockColorsWithDefaultTint, COLOR_NOT_LOADED);
                        ColorManager.this.loadSpecialColors();
                        ColorManager.this.biomeTintsAvailable.clear();
                        ColorManager.this.biomeTextureAvailable.clear();
                        ColorManager.this.blockBiomeSpecificColors.clear();
                        if (ColorManager.this.hdInstalled || ColorManager.this.optifineInstalled) {
                            try {
                                ColorManager.this.processCTM();
                            }
                            catch (Exception e) {
                                System.err.println("error loading CTM " + e.getLocalizedMessage());
                                e.printStackTrace();
                            }
                        }
                        try {
                            ColorManager.this.loadBiomeColors(((ColorManager)ColorManager.this).options.biomes);
                        }
                        catch (Exception e) {
                            System.err.println("error setting default biome shading " + e.getLocalizedMessage());
                        }
                        if (ColorManager.this.hdInstalled || ColorManager.this.optifineInstalled) {
                            ColorManager.this.blockTintTables.clear();
                            try {
                                ColorManager.this.processColorProperties();
                                if (ColorManager.this.optifineInstalled) {
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/water.png"), "" + BlockIDRepository.flowingWaterID + " " + BlockIDRepository.waterID);
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/watercolor.png"), "" + BlockIDRepository.flowingWaterID + " " + BlockIDRepository.waterID);
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/watercolorX.png"), "" + BlockIDRepository.flowingWaterID + " " + BlockIDRepository.waterID);
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/swampgrass.png"), "" + BlockIDRepository.grassID + " " + BlockIDRepository.tallGrassID + ":1,2" + " " + BlockIDRepository.tallFlowerID + ":2,3");
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/swampgrasscolor.png"), "" + BlockIDRepository.grassID + " " + BlockIDRepository.tallGrassID + ":1,2" + " " + BlockIDRepository.tallFlowerID + ":2,3");
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/swampfoliage.png"), "" + BlockIDRepository.leavesID + ":0,4,8,12" + " " + BlockIDRepository.vineID);
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/swampfoliagecolor.png"), "" + BlockIDRepository.leavesID + ":0,4,8,12" + " " + BlockIDRepository.vineID);
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/pine.png"), "" + BlockIDRepository.leavesID + ":1,5,9,13");
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/pinecolor.png"), "" + BlockIDRepository.leavesID + ":1,5,9,13");
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/birch.png"), "" + BlockIDRepository.leavesID + ":2,6,10,14");
                                    ColorManager.this.processColorProperty(new bqo("mcpatcher/colormap/birchcolor.png"), "" + BlockIDRepository.leavesID + ":2,6,10,14");
                                }
                            }
                            catch (Exception e) {
                                System.err.println("error loading custom color properties " + e.getLocalizedMessage());
                                e.printStackTrace();
                            }
                        }
                        ColorManager.this.master.getMap().forceFullRender(true);
                    }
                }, "Voxelmap Load Resourcepack Thread").start();
            }
            catch (Exception e) {
                System.err.println("error loading pack");
                e.printStackTrace();
            }
        }
        if (this.master.getRadar() != null) {
            this.master.getRadar().loadTexturePackIcons();
        }
    }

    @Override
    public final BufferedImage getBlockImage(int blockID, int metadata) {
        try {
            ps icon = ((ahu)ahu.c.a(blockID)).a(3, metadata);
            int left = (int)(icon.c() * (float)this.terrainBuff.getWidth());
            int right = (int)(icon.d() * (float)this.terrainBuff.getWidth());
            int top = (int)(icon.e() * (float)this.terrainBuff.getHeight());
            int bottom = (int)(icon.f() * (float)this.terrainBuff.getHeight());
            BufferedImage blockImage = this.terrainBuff.getSubimage(left, top, right - left, bottom - top);
            return blockImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void loadColorPicker() {
        try {
            InputStream is = this.game.O().a(new bqo("voxelmap", "images/colorPicker.png")).b();
            BufferedImage picker = ImageIO.read(is);
            is.close();
            this.colorPicker = new BufferedImage(((Image)picker).getWidth(null), ((Image)picker).getHeight(null), 2);
            Graphics2D gfx = this.colorPicker.createGraphics();
            gfx.drawImage((Image)picker, 0, 0, null);
            gfx.dispose();
        }
        catch (Exception e) {
            System.err.println("Error loading color picker: " + e.getLocalizedMessage());
        }
    }

    private void loadMapImage() {
        if (this.mapImageInt != -1) {
            GLUtils.glah(this.mapImageInt);
        }
        try {
            InputStream is = this.game.O().a(new bqo("voxelmap", "images/squaremap.png")).b();
            BufferedImage tpMap = ImageIO.read(is);
            BufferedImage mapImage = new BufferedImage(((Image)tpMap).getWidth(null), ((Image)tpMap).getHeight(null), 2);
            Graphics2D gfx = mapImage.createGraphics();
            gfx.drawImage((Image)tpMap, 0, 0, null);
            this.mapImageInt = GLUtils.tex(mapImage);
        }
        catch (Exception e) {
            try {
                InputStream is = this.game.O().a(new bqo("textures/map/map_background.png")).b();
                BufferedImage tpMap = ImageIO.read(is);
                is.close();
                BufferedImage mapImage = new BufferedImage(((Image)tpMap).getWidth(null), ((Image)tpMap).getHeight(null), 2);
                Graphics2D gfx = mapImage.createGraphics();
                if (!GLUtils.fboEnabled && !GLUtils.hasAlphaBits) {
                    gfx.setColor(Color.DARK_GRAY);
                    gfx.fillRect(0, 0, mapImage.getWidth(), mapImage.getHeight());
                }
                gfx.drawImage((Image)tpMap, 0, 0, null);
                int border = mapImage.getWidth() * 8 / 128;
                gfx.setComposite(AlphaComposite.Clear);
                gfx.fillRect(border, border, mapImage.getWidth() - border * 2, mapImage.getHeight() - border * 2);
                gfx.dispose();
                this.mapImageInt = GLUtils.tex(mapImage);
            }
            catch (Exception f) {
                System.err.println("Error loading texture pack's map image: " + f.getLocalizedMessage());
            }
        }
    }

    @Override
    public void setSkyColor(int skyColor) {
        for (int t = 0; t < 16; ++t) {
            this.blockColors[this.blockColorID((int)BlockIDRepository.airID, (int)t)] = skyColor;
        }
    }

    private void loadTexturePackTerrainImage() {
        try {
            bpx textureManager = this.game.N();
            textureManager.a(textureManager.a(0));
            BufferedImage terrainStitched = ImageUtils.createBufferedImageFromCurrentGLImage();
            this.terrainBuff = new BufferedImage(terrainStitched.getWidth(null), terrainStitched.getHeight(null), 6);
            Graphics2D gfx = this.terrainBuff.createGraphics();
            gfx.drawImage((Image)terrainStitched, 0, 0, null);
            gfx.dispose();
        }
        catch (Exception e) {
            System.err.println("Error processing new resource pack: " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private void loadSpecialColors() {
        this.blockColors[this.blockColorID((int)BlockIDRepository.tallGrassID, (int)0)] = this.colorMultiplier(this.getColor(BlockIDRepository.tallGrassID, 0), -1);
        for (int t = 0; t < 16; ++t) {
            this.blockColors[this.blockColorID((int)BlockIDRepository.cobwebID, (int)t)] = this.getColor(BlockIDRepository.cobwebID, t, false);
        }
        VoxelMapProtectedFieldsHelper.setLightOpacity(ahu.b((String)"minecraft:flowing_lava"), 1);
        VoxelMapProtectedFieldsHelper.setLightOpacity(ahu.b((String)"minecraft:lava"), 1);
    }

    private void loadBiomeColors(boolean biomes) {
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.grassID, (int)0)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.grassID, 0), afm.a((double)0.7, (double)0.8) | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)0)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 0), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)1)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 1), afj.a() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)2)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 2), afj.b() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)3)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 3), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)4)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 4), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)5)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 5), afj.a() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)6)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 6), afj.b() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)7)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 7), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)8)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 8), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)9)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 9), afj.a() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)10)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 10), afj.b() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)11)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 11), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)12)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 12), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)13)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 13), afj.a() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)14)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 14), afj.b() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leavesID, (int)15)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leavesID, 15), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leaves2ID, (int)0)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leaves2ID, 0), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leaves2ID, (int)1)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leaves2ID, 1), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leaves2ID, (int)4)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leaves2ID, 4), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.leaves2ID, (int)5)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.leaves2ID, 5), afj.c() | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.tallGrassID, (int)1)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.tallGrassID, 1), afm.a((double)0.7, (double)0.8) | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.tallGrassID, (int)2)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.tallGrassID, 2), afm.a((double)0.7, (double)0.8) | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.tallFlowerID, (int)2)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.tallFlowerID, 2), afm.a((double)0.7, (double)0.8) | 0xFF000000);
        this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.tallFlowerID, (int)3)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.tallFlowerID, 3), afm.a((double)0.7, (double)0.8) | 0xFF000000);
        for (int t = 0; t < 16; ++t) {
            this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.reedsID, (int)0)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.reedsID, 0), afm.a((double)0.7, (double)0.8) | 0xFF000000);
            this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.vineID, (int)t)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.vineID, t), afj.a((double)0.7, (double)0.8) | 0xFF000000);
        }
        this.loadWaterColor(biomes);
    }

    private void loadWaterColor(boolean biomes) {
        int waterRGB = -1;
        waterRGB = this.getBlockColor(BlockIDRepository.waterID, 0);
        InputStream is = null;
        int waterMult = -1;
        BufferedImage waterColorBuff = null;
        try {
            is = this.game.O().a(new bqo("mcpatcher/colormap/water.png")).b();
        }
        catch (IOException e) {
            is = null;
        }
        if (is != null) {
            try {
                BufferedImage waterColor = ImageIO.read(is);
                is.close();
                waterColorBuff = new BufferedImage(((Image)waterColor).getWidth(null), ((Image)waterColor).getHeight(null), 1);
                Graphics2D gfx = waterColorBuff.createGraphics();
                gfx.drawImage((Image)waterColor, 0, 0, null);
                gfx.dispose();
                agg genBase = agg.s;
                double var1 = ou.a((float)genBase.a(0, 64, 0), (float)0.0f, (float)1.0f);
                double var2 = ou.a((float)genBase.i(), (float)0.0f, (float)1.0f);
                var2 *= var1;
                var1 = 1.0 - var1;
                var2 = 1.0 - var2;
                waterMult = waterColorBuff.getRGB((int)((double)(waterColorBuff.getWidth() - 1) * var1), (int)((double)(waterColorBuff.getHeight() - 1) * var2)) & 0xFFFFFF;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        waterRGB = waterMult != -1 && waterMult != 0 ? this.colorMultiplier(waterRGB, waterMult | 0xFF000000) : this.colorMultiplier(waterRGB, agg.s.aq | 0xFF000000);
        for (int t = 0; t < 16; ++t) {
            this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.flowingWaterID, (int)t)] = waterRGB;
            this.blockColorsWithDefaultTint[this.blockColorID((int)BlockIDRepository.waterID, (int)t)] = waterRGB;
        }
    }

    private final int blockColorID(int blockid, int meta) {
        return blockid | meta << 12;
    }

    @Override
    public final int getBlockColorWithDefaultTint(int blockID, int metadata, int biomeID) {
        int col = this.blockColorsWithDefaultTint[this.blockColorID(blockID, metadata)];
        if (col != COLOR_NOT_LOADED) {
            return col;
        }
        return this.getBlockColor(blockID, metadata);
    }

    @Override
    public final int getBlockColor(int blockID, int metadata, int biomeID) {
        Integer col;
        if ((this.hdInstalled || this.optifineInstalled) && this.biomeTextureAvailable.contains(blockID) && (col = this.blockBiomeSpecificColors.get("" + this.blockColorID(blockID, metadata) + " " + biomeID)) != null) {
            return col;
        }
        return this.getBlockColor(blockID, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int getBlockColor(int blockID, int metadata) {
        Object object = this.tpLoadLock;
        synchronized (object) {
            try {
                int col;
                if (this.blockColors[this.blockColorID(blockID, metadata)] == COLOR_NOT_LOADED) {
                    this.blockColors[this.blockColorID((int)blockID, (int)metadata)] = this.getColor(blockID, metadata);
                }
                if ((col = this.blockColors[this.blockColorID(blockID, metadata)]) != -65025) {
                    return col;
                }
                if (this.blockColors[this.blockColorID(blockID, 0)] == COLOR_NOT_LOADED) {
                    this.blockColors[this.blockColorID((int)blockID, (int)0)] = this.getColor(blockID, 0);
                }
                if ((col = this.blockColors[this.blockColorID(blockID, 0)]) != -65025) {
                    return col;
                }
                return 0;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return -65025;
            }
        }
    }

    private int getColor(int blockID, int metadata, boolean retainTransparency) {
        int color = this.getColor(blockID, metadata);
        if (!retainTransparency) {
            color |= 0xFF000000;
        }
        return color;
    }

    private int getColor(int blockID, int metadata) {
        try {
            int tint;
            ps icon = null;
            if (blockID == BlockIDRepository.redstoneID) {
                return 0x19000000 | (30 + metadata * 15 & 0xFF) << 16 | 0 | 0;
            }
            icon = ahu.e((int)blockID).a(1, metadata);
            int color = this.iconToColor(icon, this.terrainBuff);
            if (Arrays.asList(BlockIDRepository.shapedIDS).contains(blockID)) {
                color = this.applyShape(blockID, metadata, color);
            }
            if ((color >> 24 & 0xFF) < 27) {
                color |= 0x1B000000;
            }
            if (blockID != BlockIDRepository.grassID && blockID != BlockIDRepository.leavesID && blockID != BlockIDRepository.leaves2ID && blockID != BlockIDRepository.tallGrassID && blockID != BlockIDRepository.reedsID && blockID != BlockIDRepository.vineID && blockID != BlockIDRepository.tallFlowerID && blockID != BlockIDRepository.waterID && blockID != BlockIDRepository.flowingWaterID && (tint = ahu.e((int)blockID).d((afx)this.game.f, this.game.h.ca, 78, (int)this.game.h.v) | 0xFF000000) != 0xFFFFFF && tint != -1) {
                this.biomeTintsAvailable.add(blockID);
                this.blockColorsWithDefaultTint[this.blockColorID((int)blockID, (int)metadata)] = this.colorMultiplier(color, tint);
            }
            return color;
        }
        catch (Exception e) {
            System.err.println("failed getting color: " + blockID + " " + metadata);
            e.printStackTrace();
            return -65025;
        }
    }

    private int iconToColor(ps icon, BufferedImage imageBuff) {
        int color = 0;
        if (icon != null) {
            int left = (int)(icon.c() * (float)imageBuff.getWidth());
            int right = (int)(icon.d() * (float)imageBuff.getWidth());
            int top = (int)(icon.e() * (float)imageBuff.getHeight());
            int bottom = (int)(icon.f() * (float)imageBuff.getHeight());
            BufferedImage blockTexture = imageBuff.getSubimage(left, top, right - left, bottom - top);
            Image singlePixel = blockTexture.getScaledInstance(1, 1, 4);
            BufferedImage singlePixelBuff = new BufferedImage(1, 1, imageBuff.getType());
            Graphics2D gfx = singlePixelBuff.createGraphics();
            gfx.drawImage(singlePixel, 0, 0, null);
            gfx.dispose();
            color = singlePixelBuff.getRGB(0, 0);
        }
        return color;
    }

    private int applyShape(int blockID, int metadata, int color) {
        int alpha = color >> 24 & 0xFF;
        int red = color >> 16 & 0xFF;
        int green = color >> 8 & 0xFF;
        int blue = color >> 0 & 0xFF;
        if (blockID == BlockIDRepository.signID || blockID == BlockIDRepository.wallSignID) {
            alpha = 31;
        } else if (blockID == BlockIDRepository.woodDoorID || blockID == BlockIDRepository.ironDoorID) {
            alpha = 47;
        } else if (blockID == BlockIDRepository.ladderID || blockID == BlockIDRepository.vineID) {
            alpha = 15;
        } else if (blockID == BlockIDRepository.stoneButtonID || blockID == BlockIDRepository.woodButtonID) {
            alpha = 11;
        } else if (blockID == BlockIDRepository.fenceID || blockID == BlockIDRepository.netherFenceID) {
            alpha = 95;
        } else if (blockID == BlockIDRepository.fenceGateID) {
            alpha = 92;
        } else if (blockID == BlockIDRepository.cobbleWallID) {
            alpha = 153;
        }
        color = (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
        return color;
    }

    @Override
    public int colorMultiplier(int color1, int color2) {
        int alpha1 = color1 >> 24 & 0xFF;
        int red1 = color1 >> 16 & 0xFF;
        int green1 = color1 >> 8 & 0xFF;
        int blue1 = color1 >> 0 & 0xFF;
        int alpha2 = color2 >> 24 & 0xFF;
        int red2 = color2 >> 16 & 0xFF;
        int green2 = color2 >> 8 & 0xFF;
        int blue2 = color2 >> 0 & 0xFF;
        int alpha = alpha1 * alpha2 / 255;
        int red = red1 * red2 / 255;
        int green = green1 * green2 / 255;
        int blue = blue1 * blue2 / 255;
        return (alpha & 0xFF) << 24 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
    }

    @Override
    public int colorAdder(int color1, int color2) {
        float topAlpha = (float)(color1 >> 24 & 0xFF) / 255.0f;
        float red1 = (float)(color1 >> 16 & 0xFF) * topAlpha;
        float green1 = (float)(color1 >> 8 & 0xFF) * topAlpha;
        float blue1 = (float)(color1 >> 0 & 0xFF) * topAlpha;
        float bottomAlpha = (float)(color2 >> 24 & 0xFF) / 255.0f;
        float red2 = (float)(color2 >> 16 & 0xFF) * bottomAlpha * (1.0f - topAlpha);
        float green2 = (float)(color2 >> 8 & 0xFF) * bottomAlpha * (1.0f - topAlpha);
        float blue2 = (float)(color2 >> 0 & 0xFF) * bottomAlpha * (1.0f - topAlpha);
        float alpha = topAlpha + bottomAlpha * (1.0f - topAlpha);
        float red = (red1 + red2) / alpha;
        float green = (green1 + green2) / alpha;
        float blue = (blue1 + blue2) / alpha;
        return ((int)(alpha * 255.0f) & 0xFF) << 24 | ((int)red & 0xFF) << 16 | ((int)green & 0xFF) << 8 | (int)blue & 0xFF;
    }

    private void processCTM() {
        this.renderPassThreeBlendMode = "alpha";
        Properties properties = new Properties();
        bqo propertiesFile = new bqo("minecraft", "mcpatcher/renderpass.properties");
        try {
            InputStream input = this.game.O().a(propertiesFile).b();
            if (input != null) {
                properties.load(input);
                input.close();
                this.renderPassThreeBlendMode = properties.getProperty("blend.3");
            }
        }
        catch (IOException e) {
            this.renderPassThreeBlendMode = "alpha";
        }
        String namespace = "minecraft";
        for (bqo s : this.findResources(namespace, "/mcpatcher/ctm", ".properties", true, false, true)) {
            try {
                this.loadCTM(s);
            }
            catch (NumberFormatException e) {
            }
            catch (IllegalArgumentException e) {}
        }
        for (int t = 0; t < this.blockColors.length; ++t) {
            if (this.blockColors[t] == -65025) continue;
            if (this.blockColors[t] == COLOR_NOT_LOADED || (this.blockColors[t] >> 24 & 0xFF) >= 27) continue;
            this.blockColors[t] = this.blockColors[t] | 0x1B000000;
        }
    }

    private void loadCTM(bqo propertiesFile) {
        int s;
        if (propertiesFile == null) {
            return;
        }
        Properties properties = new Properties();
        try {
            InputStream input = this.game.O().a(propertiesFile).b();
            if (input != null) {
                properties.load(input);
                input.close();
            }
        }
        catch (IOException e) {
            return;
        }
        ble renderBlocks = new ble();
        String filePath = propertiesFile.a();
        String method = properties.getProperty("method", "").trim().toLowerCase();
        String faces = properties.getProperty("faces", "").trim().toLowerCase();
        String matchBlocks = properties.getProperty("matchBlocks", "").trim().toLowerCase();
        String matchTiles = properties.getProperty("matchTiles", "").trim().toLowerCase();
        String metadata = properties.getProperty("metadata", "").trim().toLowerCase();
        String tiles = properties.getProperty("tiles", "").trim();
        String biomes = properties.getProperty("biomes", "").trim().toLowerCase();
        String renderPass = properties.getProperty("renderPass", "").trim().toLowerCase();
        String[] blockNames = this.parseStringList(matchBlocks);
        int[] blockInts = new int[blockNames.length];
        for (int t = 0; t < blockNames.length; ++t) {
            blockInts[t] = this.parseBlockName(blockNames[t]);
        }
        int[] metadataInts = this.parseIntegerList(metadata, 0, 255);
        String directory = filePath.substring(0, filePath.lastIndexOf("/") + 1);
        String[] tilesParsed = this.parseStringList(tiles);
        String tilePath = directory + "0";
        if (tilesParsed.length > 0) {
            tilePath = tilesParsed[0].trim();
        }
        if (!(tilePath = tilePath.startsWith("~") ? tilePath.replace("~", "mcpatcher") : directory + tilePath).toLowerCase().endsWith(".png")) {
            tilePath = tilePath + ".png";
        }
        String[] biomesArray = biomes.split(" ");
        if (blockInts.length == 0) {
            int blockID = -1;
            Pattern pattern = Pattern.compile(".*/block([\\d]+)[a-zA-Z]*.properties");
            Matcher matcher = pattern.matcher(filePath);
            if (matcher.find()) {
                blockID = Integer.parseInt(matcher.group(1));
            } else {
                String tileNameToMatch = filePath.substring(filePath.lastIndexOf("/") + 1, filePath.lastIndexOf(".properties"));
                for (int t = 0; t < 4096; ++t) {
                    ahu block = (ahu)ahu.c.a(t);
                    if (block == null) continue;
                    String tileNameOfBlock = "";
                    if (metadataInts.length > 0) {
                        for (s = 0; s < metadataInts.length; ++s) {
                            try {
                                tileNameOfBlock = renderBlocks.a(block, 1, metadataInts[s]).g();
                            }
                            catch (Exception e) {
                                tileNameOfBlock = "";
                            }
                            if (!tileNameOfBlock.equals(tileNameToMatch)) continue;
                            blockID = t;
                        }
                        continue;
                    }
                    ArrayList<Integer> tmpList = new ArrayList<Integer>();
                    for (int s2 = 0; s2 < 16; ++s2) {
                        try {
                            tileNameOfBlock = renderBlocks.a(block, 1, s2).g();
                        }
                        catch (Exception e) {
                            tileNameOfBlock = "";
                        }
                        if (!tileNameOfBlock.equals(tileNameToMatch)) continue;
                        blockID = t;
                        tmpList.add(s2);
                    }
                    metadataInts = new int[tmpList.size()];
                    for (int i = 0; i < metadataInts.length; ++i) {
                        metadataInts[i] = (Integer)tmpList.get(i);
                    }
                }
            }
            if (blockID != -1) {
                blockInts = new int[]{blockID};
            }
        }
        if (metadataInts.length == 0) {
            metadataInts = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
        }
        if (blockInts.length == 0) {
            return;
        }
        if (!method.equals("horizontal") && (method.equals("sandstone") || method.equals("top") || faces.contains("top") || faces.contains("all") || faces.length() == 0)) {
            try {
                for (int t = 0; t < blockInts.length; ++t) {
                    bqo pngResource = new bqo(propertiesFile.b(), tilePath);
                    InputStream is = this.game.O().a(pngResource).b();
                    Image top = ImageIO.read(is);
                    is.close();
                    top = top.getScaledInstance(1, 1, 4);
                    BufferedImage topBuff = new BufferedImage(top.getWidth(null), top.getHeight(null), 6);
                    Graphics2D gfx = topBuff.createGraphics();
                    gfx.drawImage(top, 0, 0, null);
                    gfx.dispose();
                    int topRGB = topBuff.getRGB(0, 0);
                    if (blockInts[t] == BlockIDRepository.cobwebID) {
                        topRGB |= 0xFF000000;
                    }
                    if (renderPass.equals("3")) {
                        topRGB = this.processRenderPassThree(topRGB);
                        int baseRGB = this.blockColors[this.blockColorID(blockInts[t], metadataInts[0])];
                        if (baseRGB != -65025) {
                            if (baseRGB != COLOR_NOT_LOADED) {
                                topRGB = this.colorMultiplier(baseRGB, topRGB);
                            }
                        }
                    }
                    if (Arrays.asList(BlockIDRepository.shapedIDS).contains(blockInts[t])) {
                        topRGB = this.applyShape(blockInts[t], metadataInts[0], topRGB);
                    }
                    for (s = 0; s < metadataInts.length; ++s) {
                        try {
                            if (!biomes.equals("")) {
                                this.biomeTextureAvailable.add(blockInts[t]);
                                for (int r = 0; r < biomesArray.length; ++r) {
                                    int biomeInt = this.parseBiomeName(biomesArray[r]);
                                    if (biomeInt == -1) continue;
                                    this.blockBiomeSpecificColors.put("" + this.blockColorID(blockInts[t], metadataInts[s]) + " " + biomeInt, topRGB);
                                }
                                continue;
                            }
                            this.blockColors[this.blockColorID((int)blockInts[t], (int)metadataInts[s])] = topRGB;
                            continue;
                        }
                        catch (Exception e) {
                            System.err.println("blockID + metadata (" + blockInts[t] + ", " + metadataInts[s] + ") out of range");
                        }
                    }
                }
            }
            catch (IOException e) {
                System.err.println("error getting CTM block: " + filePath + " " + blockInts[0] + " " + metadataInts[0] + " " + tilePath);
            }
        }
    }

    private int processRenderPassThree(int rgb) {
        if (this.renderPassThreeBlendMode.equals("color") || this.renderPassThreeBlendMode.equals("overlay")) {
            int alpha = rgb >> 24 & 0xFF;
            int red = rgb >> 16 & 0xFF;
            int green = rgb >> 8 & 0xFF;
            int blue = rgb >> 0 & 0xFF;
            float colorAverage = (float)(red + blue + green) / 3.0f;
            float lighteningFactor = (colorAverage - 127.5f) * 2.0f;
            red += (int)((float)red * (lighteningFactor / 255.0f));
            int newAlpha = (int)Math.abs(lighteningFactor);
            rgb = newAlpha << 24 | (red & 0xFF) << 16 | ((green += (int)((float)red * (lighteningFactor / 255.0f))) & 0xFF) << 8 | (blue += (int)((float)red * (lighteningFactor / 255.0f))) & 0xFF;
        }
        return rgb;
    }

    private int[] parseIntegerList(String list, int minValue, int maxValue) {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        for (String token : list.replace(',', ' ').split("\\s+")) {
            token = token.trim();
            try {
                String[] t;
                if (token.matches("^\\d+$")) {
                    tmpList.add(Integer.parseInt(token));
                    continue;
                }
                if (token.matches("^\\d+-\\d+$")) {
                    t = token.split("-");
                    int min = Integer.parseInt(t[0]);
                    int max = Integer.parseInt(t[1]);
                    for (int i = min; i <= max; ++i) {
                        tmpList.add(i);
                    }
                    continue;
                }
                if (!token.matches("^\\d+:\\d+$")) continue;
                t = token.split(":");
                int id = Integer.parseInt(t[0]);
                int metadata = Integer.parseInt(t[1]);
                tmpList.add(id);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (minValue <= maxValue) {
            int i = 0;
            while (i < tmpList.size()) {
                if ((Integer)tmpList.get(i) < minValue || (Integer)tmpList.get(i) > maxValue) {
                    tmpList.remove(i);
                    continue;
                }
                ++i;
            }
        }
        int[] a = new int[tmpList.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (Integer)tmpList.get(i);
        }
        return a;
    }

    private String[] parseStringList(String list) {
        ArrayList<String> tmpList = new ArrayList<String>();
        for (String token : list.replace(',', ' ').split("\\s+")) {
            token = token.trim();
            try {
                if (token.matches("^\\d+$")) {
                    tmpList.add("" + Integer.parseInt(token));
                    continue;
                }
                if (token.matches("^\\d+-\\d+$")) {
                    String[] t = token.split("-");
                    int min = Integer.parseInt(t[0]);
                    int max = Integer.parseInt(t[1]);
                    for (int i = min; i <= max; ++i) {
                        tmpList.add("" + i);
                    }
                    continue;
                }
                if (token == null || token == "") continue;
                tmpList.add(token);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        String[] a = new String[tmpList.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (String)tmpList.get(i);
        }
        return a;
    }

    private int parseBiomeName(String name) {
        if (name.matches("^\\d+$")) {
            return Integer.parseInt(name);
        }
        for (int t = 0; t < agg.n().length; ++t) {
            if (agg.n()[t] == null || !agg.n()[t].af.toLowerCase().replace(" ", "").equalsIgnoreCase(name)) continue;
            return t;
        }
        return -1;
    }

    private List<bqr> getResourcePacks(String namespace) {
        ArrayList<bqr> list = new ArrayList<bqr>();
        bqp superResourceManager = this.game.O();
        if (superResourceManager instanceof bqx) {
            Map nameSpaceToResourceManager = null;
            Object nameSpaceToResourceManagerObj = ReflectionUtils.getPrivateFieldValueByType(superResourceManager, bqx.class, Map.class);
            if (nameSpaceToResourceManagerObj == null) {
                return list;
            }
            nameSpaceToResourceManager = (Map)nameSpaceToResourceManagerObj;
            for (Map.Entry entry : nameSpaceToResourceManager.entrySet()) {
                if (namespace != null && !namespace.equals(entry.getKey())) continue;
                bqh resourceManager = (bqh)entry.getValue();
                List resourcePacks = null;
                Object resourcePacksObj = ReflectionUtils.getPrivateFieldValueByType(resourceManager, bqh.class, List.class);
                if (resourcePacksObj == null) {
                    return list;
                }
                resourcePacks = (List)resourcePacksObj;
                list.addAll(resourcePacks);
            }
        }
        Collections.reverse(list);
        return list;
    }

    private List<bqo> findResources(String namespace, String directory, String suffix, boolean recursive, boolean directories, boolean sortByFilename) {
        if (directory == null) {
            directory = "";
        }
        if (directory.startsWith("/")) {
            directory = directory.substring(1);
        }
        if (suffix == null) {
            suffix = "";
        }
        ArrayList<bqo> resources = new ArrayList<bqo>();
        for (bqr resourcePack : this.getResourcePacks(namespace)) {
            if (resourcePack instanceof bqg) continue;
            if (resourcePack instanceof bqi) {
                Object zipFileObj = ReflectionUtils.getPrivateFieldValueByType(resourcePack, bqi.class, ZipFile.class);
                if (zipFileObj == null) {
                    return resources;
                }
                ZipFile zipFile = (ZipFile)zipFileObj;
                if (zipFile == null) continue;
                this.findResourcesZip(zipFile, namespace, "assets/" + namespace, directory, suffix, recursive, directories, resources);
                continue;
            }
            if (!(resourcePack instanceof bqf)) continue;
            Object baseObj = ReflectionUtils.getPrivateFieldValueByType(resourcePack, bqf.class, File.class);
            if (baseObj == null) {
                return resources;
            }
            File base = (File)baseObj;
            if (base == null || !base.isDirectory() || !(base = new File(base, "assets/" + namespace)).isDirectory()) continue;
            ColorManager.findResourcesDirectory(base, namespace, directory, suffix, recursive, directories, resources);
        }
        if (sortByFilename) {
            Collections.sort(resources, new Comparator<bqo>(){

                @Override
                public int compare(bqo o1, bqo o2) {
                    String f2;
                    String f1 = o1.a().replaceAll(".*/", "").replaceFirst("\\.properties", "");
                    int result = f1.compareTo(f2 = o2.a().replaceAll(".*/", "").replaceFirst("\\.properties", ""));
                    if (result != 0) {
                        return result;
                    }
                    return o1.a().compareTo(o2.a());
                }
            });
        } else {
            Collections.sort(resources, new Comparator<bqo>(){

                @Override
                public int compare(bqo o1, bqo o2) {
                    return o1.a().compareTo(o2.a());
                }
            });
        }
        return resources;
    }

    private void findResourcesZip(ZipFile zipFile, String namespace, String root, String directory, String suffix, boolean recursive, boolean directories, Collection<bqo> resources) {
        String base = root + "/" + directory;
        for (ZipEntry zipEntry : Collections.list(zipFile.entries())) {
            String name;
            if (zipEntry.isDirectory() != directories || !(name = zipEntry.getName().replaceFirst("^/", "")).startsWith(base) || !name.endsWith(suffix)) continue;
            if (directory.equals("")) {
                if (!recursive && name.contains("/")) continue;
                resources.add(new bqo(namespace, name));
                continue;
            }
            String subpath = name.substring(base.length());
            if (!subpath.equals("") && !subpath.startsWith("/") || !recursive && !subpath.equals("") && subpath.substring(1).contains("/")) continue;
            resources.add(new bqo(namespace, name.substring(root.length() + 1)));
        }
    }

    private static void findResourcesDirectory(File base, String namespace, String directory, String suffix, boolean recursive, boolean directories, Collection<bqo> resources) {
        File subdirectory = new File(base, directory);
        String[] list = subdirectory.list();
        if (list != null) {
            String pathComponent = directory.equals("") ? "" : directory + "/";
            for (String s : list) {
                File entry = new File(subdirectory, s);
                String resourceName = pathComponent + s;
                if (entry.isDirectory()) {
                    if (directories && s.endsWith(suffix)) {
                        resources.add(new bqo(namespace, resourceName));
                    }
                    if (!recursive) continue;
                    ColorManager.findResourcesDirectory(base, namespace, pathComponent + s, suffix, recursive, directories, resources);
                    continue;
                }
                if (!s.endsWith(suffix) || directories) continue;
                resources.add(new bqo(namespace, resourceName));
            }
        }
    }

    private void processColorProperties() {
        ArrayList<bqo> unusedPNGs = new ArrayList<bqo>();
        unusedPNGs.addAll(this.findResources("minecraft", "/mcpatcher/colormap/blocks", ".png", true, false, true));
        Properties properties = new Properties();
        try {
            InputStream input = this.game.O().a(new bqo("mcpatcher/color.properties")).b();
            if (input != null) {
                properties.load(input);
                input.close();
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        int lilypadMultiplier = 2129968;
        String lilypadMultiplierString = properties.getProperty("lilypad");
        if (lilypadMultiplierString != null) {
            lilypadMultiplier = Integer.parseInt(lilypadMultiplierString, 16);
        }
        for (int t = 0; t < 16; ++t) {
            this.blockColors[this.blockColorID((int)BlockIDRepository.lilypadID, (int)t)] = this.colorMultiplier(this.getBlockColor(BlockIDRepository.lilypadID, t), lilypadMultiplier | 0xFF000000);
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (!key.startsWith("palette.block")) continue;
            String filename = key.substring("palette.block.".length());
            filename = filename.replace("~", "mcpatcher");
            this.processColorProperty(new bqo(filename), properties.getProperty(key));
        }
        for (bqo resource : this.findResources("minecraft", "/mcpatcher/colormap/blocks", ".properties", true, false, true)) {
            Properties colorProperties;
            block10: {
                colorProperties = new Properties();
                try {
                    InputStream input = this.game.O().a(resource).b();
                    if (input == null) break block10;
                    properties.load(input);
                    input.close();
                }
                catch (IOException e2) {
                    break;
                }
            }
            String names = colorProperties.getProperty("blocks");
            bqo resourcePNG = new bqo(resource.b(), resource.a().replace(".properties", ".png"));
            unusedPNGs.remove(resourcePNG);
            this.processColorProperty(resourcePNG, names);
        }
        for (bqo resource : unusedPNGs) {
            String name = resource.a();
            System.out.println("processing name: " + name);
            name = name.substring(name.lastIndexOf("/") + 1, name.lastIndexOf(".png"));
            System.out.println("processed name: " + name);
            this.processColorProperty(resource, "minecraft:" + name);
        }
    }

    private void processColorProperty(bqo resource, String list) {
        Integer[] tints = new Integer[agg.n().length];
        boolean swamp = resource.a().contains("/swampgrass") || resource.a().contains("/swampfoliage");
        BufferedImage tintColors = null;
        try {
            InputStream is = this.game.O().a(resource).b();
            tintColors = ImageIO.read(is);
            is.close();
        }
        catch (IOException e) {
            return;
        }
        for (int t = 0; t < agg.n().length; ++t) {
            tints[t] = -1;
        }
        BufferedImage tintColorsBuff = new BufferedImage(((Image)tintColors).getWidth(null), ((Image)tintColors).getHeight(null), 1);
        Graphics2D gfx = tintColorsBuff.createGraphics();
        gfx.drawImage((Image)tintColors, 0, 0, null);
        gfx.dispose();
        for (int t = 0; t < agg.n().length; ++t) {
            if (agg.n()[t] == null) continue;
            agg genBase = agg.n()[t];
            double var1 = ou.a((float)genBase.a(0, 64, 0), (float)0.0f, (float)1.0f);
            double var2 = ou.a((float)genBase.i(), (float)0.0f, (float)1.0f);
            var2 *= var1;
            var1 = 1.0 - var1;
            var2 = 1.0 - var2;
            int tintMult = tintColorsBuff.getRGB((int)((double)(tintColorsBuff.getWidth() - 1) * var1), (int)((double)(tintColorsBuff.getHeight() - 1) * var2)) & 0xFFFFFF;
            if (tintMult == 0 || swamp && t != agg.u.ay) continue;
            tints[t] = tintMult;
        }
        for (String token : list.split("\\s+")) {
            token = token.trim();
            String metadataString = "";
            int id = -1;
            int[] metadata = new int[]{};
            try {
                String name;
                if (token.matches(".*:[-0-9, ]+")) {
                    int pos = token.lastIndexOf(58);
                    metadataString = token.substring(pos + 1);
                    name = token.substring(0, pos);
                } else {
                    name = token;
                }
                id = this.parseBlockName(name);
                if (id <= 0) continue;
                this.biomeTintsAvailable.add(id);
                metadata = this.parseIntegerList(metadataString, 0, 15);
                if (metadata.length == 0) {
                    metadata = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
                }
                for (int t = 0; t < metadata.length; ++t) {
                    Integer[] previousTints = this.blockTintTables.get(id + " " + metadata[t]);
                    if (swamp && previousTints == null) {
                        bqo defaultResource = resource.a().endsWith("/swampgrass.png") ? new bqo("textures/colormap/grass.png") : new bqo("textures/colormap/foliage.png");
                        this.processColorProperty(defaultResource, "" + id + ":" + metadata[t]);
                        previousTints = this.blockTintTables.get(id + " " + metadata[t]);
                    }
                    if (previousTints != null) {
                        for (int s = 0; s < agg.n().length; ++s) {
                            if (tints[s] != -1) continue;
                            tints[s] = previousTints[s];
                        }
                    }
                    this.blockColorsWithDefaultTint[this.blockColorID((int)id, (int)metadata[t])] = this.colorMultiplier(this.getBlockColor(id, metadata[t]), (int)(tints[4] | 0xFF000000));
                    this.blockTintTables.put(id + " " + metadata[t], tints);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
    }

    private int parseBlockName(String name) {
        ahu block = ahu.b((String)name);
        if (block != null) {
            return ahu.b((ahu)block);
        }
        return -1;
    }
}

