/*
 * Decompiled with CFR 0.152.
 */
package com.thevoxelbox.voxelmap;

import com.prupe.mcpatcher.mob.MobRandomizer;
import com.thevoxelbox.voxelmap.MapSettingsManager;
import com.thevoxelbox.voxelmap.RadarSettingsManager;
import com.thevoxelbox.voxelmap.interfaces.IRadar;
import com.thevoxelbox.voxelmap.interfaces.IVoxelMap;
import com.thevoxelbox.voxelmap.util.Contact;
import com.thevoxelbox.voxelmap.util.CustomMob;
import com.thevoxelbox.voxelmap.util.CustomMobsManager;
import com.thevoxelbox.voxelmap.util.EnumMobs;
import com.thevoxelbox.voxelmap.util.GLUtils;
import com.thevoxelbox.voxelmap.util.GameVariableAccessShim;
import com.thevoxelbox.voxelmap.util.ImageUtils;
import com.thevoxelbox.voxelmap.util.LayoutVariables;
import com.thevoxelbox.voxelmap.util.ReflectionUtils;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import org.lwjgl.opengl.GL11;

public class Radar
implements IRadar {
    private azd game;
    private IVoxelMap master = null;
    private LayoutVariables layoutVariables = null;
    public MapSettingsManager minimapOptions = null;
    public RadarSettingsManager options = null;
    boolean textureManagerLoaded = false;
    private bag fontRenderer;
    private boolean enabled = true;
    private boolean completedLoading = false;
    private int timer = 500;
    private float direction = 0.0f;
    private ArrayList<Contact> contacts = new ArrayList(40);
    public HashMap<String, Integer> mpContacts = new HashMap();
    public HashMap<String, Integer> mpContactsSkinGetTries = new HashMap();
    private BufferedImage[][] icons = new BufferedImage[EnumMobs.values().length - 3][2];
    private int[][] imageRef = new int[EnumMobs.values().length - 3][2];
    public HashMap<String, Integer> imageRefCustomType = new HashMap();
    public HashMap<String, Integer> imageRefAutoType = new HashMap();
    public HashMap<Integer, Integer> imageSizeCustomOrAutoType = new HashMap();
    public static final int BLOCK = -1;
    public static final int CLOTH = 0;
    public static final int CHAIN = 4;
    public static final int IRON = 6;
    public static final int GOLD = 8;
    public static final int DIAMOND = 10;
    public static final int UNKNOWN = EnumMobs.UNKNOWN.ordinal();
    public static final int CUSTOM = EnumMobs.CUSTOM.ordinal();
    private BufferedImage[][] armorIcons = new BufferedImage[12][2];
    private int[][] armorImageRef = new int[12][2];
    public HashMap<String, Integer> armorImageRefCustomType = new HashMap();
    public HashMap<String, Integer> armorImageSizeCustomType = new HashMap();
    private BufferedImage crown = null;
    private int crownRef = -1;
    public boolean randomobsInstalled = false;
    Method getEntityTexture = null;
    public boolean randomobsOptifine = false;
    Method getEntityTextureOptifine = null;
    public HashMap<String, Integer> randomobRef = new HashMap();
    private boolean lastOutlines = true;

    public Radar(IVoxelMap master) {
        int t;
        Class[] argClasses;
        Method m;
        this.master = master;
        this.minimapOptions = master.getMapOptions();
        this.options = master.getRadarOptions();
        this.game = azd.A();
        this.textureManagerLoaded = GLUtils.textureManager != null;
        this.randomobsInstalled = ReflectionUtils.classExists("com.prupe.mcpatcher.mob.MobRandomizer");
        if (this.randomobsInstalled) {
            m = null;
            try {
                argClasses = new Class[]{rh.class, bqo.class};
                m = MobRandomizer.class.getMethod("randomTexture", argClasses);
            }
            catch (Exception e) {
                System.err.println("can't get MCPatcher randomobs method");
                e.printStackTrace();
            }
            if (m == null) {
                this.randomobsInstalled = false;
            } else {
                this.getEntityTexture = m;
            }
        }
        this.randomobsOptifine = ReflectionUtils.classExists("RandomMobs");
        if (this.randomobsOptifine) {
            m = null;
            try {
                argClasses = new Class[]{bqo.class, Integer.TYPE};
                m = RandomMobs.class.getDeclaredMethod("getTextureLocation", argClasses);
            }
            catch (Exception e) {
                System.err.println("can't get Optifine randomobs method");
                e.printStackTrace();
            }
            if (m == null) {
                this.randomobsOptifine = false;
            } else {
                m.setAccessible(true);
                this.getEntityTextureOptifine = m;
            }
        }
        for (t = 0; t < this.icons.length; ++t) {
            this.imageRef[t][0] = -1;
            this.imageRef[t][1] = -1;
        }
        for (t = 0; t < this.armorIcons.length; ++t) {
            this.armorImageRef[t][0] = -1;
            this.armorImageRef[t][1] = -1;
        }
    }

    public void outlinesChanged() {
        for (Map.Entry<String, Integer> entry : this.mpContacts.entrySet()) {
            GLUtils.glah(entry.getValue());
        }
        this.mpContacts.clear();
        this.mpContactsSkinGetTries.clear();
        this.loadTexturePackIcons();
    }

    @Override
    public void loadTexturePackIcons() {
        try {
            int oldGenericPlayerRef0 = this.imageRef[EnumMobs.PLAYER.ordinal()][0];
            int oldGenericPlayerRef1 = this.imageRef[EnumMobs.PLAYER.ordinal()][1];
            for (Map.Entry<String, Integer> entry : this.randomobRef.entrySet()) {
                if (entry.getValue().equals(-1)) continue;
                GLUtils.glah(entry.getValue());
            }
            this.randomobRef.clear();
            for (Map.Entry<String, Integer> entry : this.imageRefCustomType.entrySet()) {
                if (entry.getValue().equals(-1)) continue;
                GLUtils.glah(entry.getValue());
            }
            this.imageRefCustomType.clear();
            for (Map.Entry<String, Integer> entry : this.imageRefAutoType.entrySet()) {
                if (entry.getValue().equals(-1)) continue;
                GLUtils.glah(entry.getValue());
            }
            this.imageRefAutoType.clear();
            this.imageSizeCustomOrAutoType.clear();
            EnumMobs.MOOSHROOM.secondaryResourceLocation = ReflectionUtils.classExists("com.prupe.mcpatcher.mob.MobOverlay") && ImageUtils.loadImage(new bqo("mcpatcher/mob/cow/mooshroom_overlay.png"), 0, 0, 1, 1) != null ? new bqo("mcpatcher/mob/cow/mooshroom_overlay.png") : new bqo("textures/blocks/mushroom_red.png");
            for (int t = 0; t < this.icons.length; ++t) {
                BufferedImage image = null;
                image = this.createImageFromTypeAndResourceLocations(EnumMobs.values()[t], EnumMobs.values()[t].resourceLocation, EnumMobs.values()[t].secondaryResourceLocation);
                if (image == null) {
                    System.err.println("Failed getting mob " + t);
                    image = new BufferedImage(2, 2, 6);
                }
                float scale = (float)image.getWidth() / (float)EnumMobs.values()[t].expectedWidth;
                this.icons[t][1] = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(image, 2.0f / scale)), this.options.outlines);
                this.icons[t][0] = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(image, 1.0f / scale)), this.options.outlines);
                if (GLUtils.textureManager != null) {
                    this.imageRef[t][0] = GLUtils.tex(this.icons[t][0]);
                    this.imageRef[t][1] = GLUtils.tex(this.icons[t][1]);
                    this.randomobRef.put(EnumMobs.values()[t].resourceLocation.toString() + (EnumMobs.values()[t].secondaryResourceLocation != null ? EnumMobs.values()[t].secondaryResourceLocation.toString() : "") + "0", this.imageRef[t][0]);
                    this.randomobRef.put(EnumMobs.values()[t].resourceLocation.toString() + (EnumMobs.values()[t].secondaryResourceLocation != null ? EnumMobs.values()[t].secondaryResourceLocation.toString() : "") + "1", this.imageRef[t][1]);
                    continue;
                }
                this.imageRef[t][0] = -1;
                this.imageRef[t][1] = -1;
            }
            int newGenericPlayerRef0 = this.imageRef[EnumMobs.PLAYER.ordinal()][0];
            this.replaceGenericPlayerRefs(oldGenericPlayerRef0, newGenericPlayerRef0);
            int newGenericPlayerRef1 = this.imageRef[EnumMobs.PLAYER.ordinal()][1];
            this.replaceGenericPlayerRefs(oldGenericPlayerRef1, newGenericPlayerRef1);
            for (Map.Entry<String, Integer> entry : this.armorImageRefCustomType.entrySet()) {
                if (entry.getValue().equals(-1)) continue;
                GLUtils.glah(entry.getValue());
            }
            this.armorImageRefCustomType.clear();
            this.armorIcons[0][0] = ImageUtils.loadImage(new bqo("textures/models/armor/leather_layer_1.png"), 8, 8, 8, 8);
            this.armorIcons[1][0] = ImageUtils.loadImage(new bqo("textures/models/armor/leather_layer_1.png"), 40, 8, 8, 8);
            this.armorIcons[2][0] = ImageUtils.loadImage(new bqo("textures/models/armor/leather_layer_1_overlay.png"), 8, 8, 8, 8);
            this.armorIcons[3][0] = ImageUtils.loadImage(new bqo("textures/models/armor/leather_layer_1_overlay.png"), 40, 8, 8, 8);
            this.armorIcons[4][0] = ImageUtils.addImages(ImageUtils.loadImage(new bqo("textures/models/armor/chainmail_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new bqo("textures/models/armor/chainmail_layer_1.png"), 40, 8, 8, 8), 0.0f, 0, 8, 8);
            this.armorIcons[6][0] = ImageUtils.addImages(ImageUtils.loadImage(new bqo("textures/models/armor/iron_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new bqo("textures/models/armor/iron_layer_1.png"), 40, 8, 8, 8), 0.0f, 0, 8, 8);
            this.armorIcons[8][0] = ImageUtils.addImages(ImageUtils.loadImage(new bqo("textures/models/armor/gold_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new bqo("textures/models/armor/gold_layer_1.png"), 40, 8, 8, 8), 0.0f, 0, 8, 8);
            this.armorIcons[10][0] = ImageUtils.addImages(ImageUtils.loadImage(new bqo("textures/models/armor/diamond_layer_1.png"), 8, 8, 8, 8), ImageUtils.loadImage(new bqo("textures/models/armor/diamond_layer_1.png"), 40, 8, 8, 8), 0.0f, 0, 8, 8);
            this.armorIcons[5][0] = this.icons[EnumMobs.BLANK.ordinal()][0];
            this.armorIcons[7][0] = this.icons[EnumMobs.BLANK.ordinal()][0];
            this.armorIcons[9][0] = this.icons[EnumMobs.BLANK.ordinal()][0];
            this.armorIcons[11][0] = this.icons[EnumMobs.BLANK.ordinal()][0];
            for (int t = 0; t < this.armorIcons.length; ++t) {
                if (this.armorImageRef[t][0] != -1) {
                    GLUtils.glah(this.armorImageRef[t][0]);
                }
                if (this.armorImageRef[t][1] != -1) {
                    GLUtils.glah(this.armorImageRef[t][1]);
                }
                float scale = (float)this.armorIcons[t][0].getWidth() / 8.0f;
                this.armorIcons[t][1] = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(this.armorIcons[t][0], 2.0f / scale)), this.options.outlines, true, false, t);
                this.armorIcons[t][0] = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(this.armorIcons[t][0], 1.0f / scale)), this.options.outlines, true, false, t);
                if (GLUtils.textureManager != null) {
                    this.armorImageRef[t][0] = GLUtils.tex(this.armorIcons[t][0]);
                    this.armorImageRef[t][1] = GLUtils.tex(this.armorIcons[t][1]);
                    continue;
                }
                this.armorImageRef[t][0] = -1;
                this.armorImageRef[t][1] = -1;
            }
            this.crown = ImageUtils.loadImage(new bqo("voxelmap", "images/crown.png"), 0, 0, 16, 16, 16, 16);
            this.crown = ImageUtils.fillOutline(this.crown, this.options.outlines, true, false, -10);
            if (this.crownRef != -1) {
                GLUtils.glah(this.crownRef);
            }
            this.crownRef = GLUtils.textureManager != null ? GLUtils.tex(this.crown) : -1;
            this.completedLoading = true;
        }
        catch (Exception e) {
            System.err.println("Failed getting mobs " + e.getLocalizedMessage());
            e.printStackTrace();
        }
    }

    private BufferedImage createImageFromTypeAndResourceLocations(EnumMobs type, bqo resourceLocation, bqo resourceLocationSecondary) {
        BufferedImage mobImage = null;
        BufferedImage mobImageSecondary = null;
        try {
            InputStream is = this.game.O().a(resourceLocation).b();
            mobImage = ImageIO.read(is);
            is.close();
            if (resourceLocationSecondary != null) {
                is = this.game.O().a(resourceLocationSecondary).b();
                mobImageSecondary = ImageIO.read(is);
                is.close();
            }
            return this.createImageFromTypeAndImages(type, mobImage, mobImageSecondary);
        }
        catch (Exception e) {
            return null;
        }
    }

    private BufferedImage createImageFromTypeAndImages(EnumMobs type, BufferedImage mobImage, BufferedImage mobImageSecondary) {
        BufferedImage image = null;
        switch (type) {
            case BLANK: {
                image = ImageUtils.blankImage(mobImage, 2, 2);
                break;
            }
            case BLANKHOSTILE: {
                image = ImageUtils.addCharacter(ImageUtils.blankImage(mobImage, 8, 8, 255, 0, 0, 255), "?");
                break;
            }
            case BLANKNEUTRAL: {
                image = ImageUtils.addCharacter(ImageUtils.blankImage(mobImage, 8, 8, 85, 100, 255, 255), "?");
                break;
            }
            case BLANKTAME: {
                image = ImageUtils.addCharacter(ImageUtils.blankImage(mobImage, 8, 8, 0, 255, 0, 255), "?");
                break;
            }
            case BAT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 64, 64), ImageUtils.loadImage(mobImage, 25, 1, 3, 4), 0.0f, 0, 8, 12), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 25, 1, 3, 4)), 5.0f, 0, 8, 12), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 3, 8, 12);
                break;
            }
            case BLAZE: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8);
                break;
            }
            case CAT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 5, 5), ImageUtils.loadImage(mobImage, 5, 5, 5, 4), 0.0f, 1, 5, 5), ImageUtils.loadImage(mobImage, 2, 26, 3, 2), 1.0f, 3, 5, 5), ImageUtils.loadImage(mobImage, 2, 12, 1, 1), 1.0f, 0, 5, 5), ImageUtils.loadImage(mobImage, 8, 12, 1, 1), 3.0f, 0, 5, 5);
                break;
            }
            case CAVESPIDER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 1, 8, 8), ImageUtils.loadImage(mobImage, 40, 12, 8, 8), 0.0f, 0, 8, 8);
                break;
            }
            case CHICKEN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 2, 3, 6, 6), ImageUtils.loadImage(mobImage, 16, 2, 4, 2), 1.0f, 2, 6, 6), ImageUtils.loadImage(mobImage, 16, 6, 2, 2), 2.0f, 4, 6, 6);
                break;
            }
            case COW: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 10), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 1.0f, 1, 10, 10), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 0.0f, 0, 10, 10), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 9.0f, 0, 10, 10);
                break;
            }
            case CREEPER: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8);
                break;
            }
            case ENDERDRAGON: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 20, 256, 256), ImageUtils.loadImage(mobImage, 128, 46, 16, 16, 256, 256), 0.0f, 4, 16, 16), ImageUtils.loadImage(mobImage, 192, 60, 12, 5, 256, 256), 2.0f, 11, 16, 16), ImageUtils.loadImage(mobImage, 192, 81, 12, 4, 256, 256), 2.0f, 16, 16, 16), ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256), 3.0f, 0, 16, 16), ImageUtils.flipHorizontal(ImageUtils.loadImage(mobImage, 6, 6, 2, 4, 256, 256)), 11.0f, 0, 16, 16);
                break;
            }
            case ENDERMAN: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 8, 24, 8, 8), 0.0f, 0, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0, 8, 8), ImageUtils.loadImage(mobImage, 8, 12, 8, 1), 0.0f, 4, 8, 8);
                break;
            }
            case GHAST: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case HORSE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 16, 24, 128, 128), ImageUtils.loadImage(mobImage, 58, 4, 4, 15, 128, 128), 0.0f, 5, 16, 24), ImageUtils.loadImage(mobImage, 0, 20, 8, 13, 128, 128), 3.0f, 9, 16, 24), ImageUtils.loadImage(mobImage, 0, 7, 7, 5, 128, 128), 3.0f, 7, 16, 24), ImageUtils.loadImage(mobImage, 24, 24, 6, 3, 128, 128), 10.0f, 7, 16, 24), ImageUtils.loadImage(mobImage, 24, 32, 5, 2, 128, 128), 10.0f, 10, 16, 24), ImageUtils.loadImage(mobImage, 0, 1, 1, 3, 128, 128), 4.0f, 4, 16, 24), ImageUtils.loadImage(mobImage, 0, 13, 1, 7, 128, 128), 4.0f, 0, 16, 24);
                break;
            }
            case GHASTATTACKING: {
                image = ImageUtils.loadImage(mobImage, 16, 16, 16, 16);
                break;
            }
            case IRONGOLEM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 128, 128), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 128, 128), 0.0f, 1, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 128, 128), 3.0f, 8, 8, 12);
                break;
            }
            case MAGMA: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 32, 18, 8, 1), 0.0f, 3, 8, 8), ImageUtils.loadImage(mobImage, 32, 27, 8, 1), 0.0f, 4, 8, 8);
                break;
            }
            case MOOSHROOM: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 40, 40), ImageUtils.loadImage(mobImage, 6, 6, 8, 8), 16.0f, 16, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 15.0f, 15, 40, 40), ImageUtils.loadImage(mobImage, 23, 1, 1, 3), 24.0f, 15, 40, 40);
                if (mobImageSecondary == null) break;
                BufferedImage mushroomImage = mobImageSecondary.getWidth() != mobImageSecondary.getHeight() ? ImageUtils.loadImage(mobImageSecondary, 32, 0, 16, 16, 48, 16) : ImageUtils.loadImage(mobImageSecondary, 0, 0, 16, 16, 16, 16);
                float ratio = (float)image.getWidth() / (float)mushroomImage.getWidth();
                if ((double)ratio < 2.5) {
                    image = ImageUtils.scaleImage(image, 2.5f / ratio);
                } else if ((double)ratio > 2.5) {
                    mushroomImage = ImageUtils.scaleImage(mushroomImage, ratio / 2.5f);
                }
                image = ImageUtils.addImages(image, mushroomImage, 12.0f, 0, 40, 40);
                break;
            }
            case OCELOT: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 5, 5), ImageUtils.loadImage(mobImage, 5, 5, 5, 4), 0.0f, 1, 5, 5), ImageUtils.loadImage(mobImage, 2, 26, 3, 2), 1.0f, 3, 5, 5), ImageUtils.loadImage(mobImage, 2, 12, 1, 1), 1.0f, 0, 5, 5), ImageUtils.loadImage(mobImage, 8, 12, 1, 1), 3.0f, 0, 5, 5);
                break;
            }
            case PIG: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 16, 17, 6, 3), 1.0f, 4, 8, 8);
                break;
            }
            case PIGZOMBIE: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0, 8, 8);
                break;
            }
            case PLAYER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0, 8, 8);
                break;
            }
            case SHEEP: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 6, 6);
                break;
            }
            case SILVERFISH: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 22, 20, 6, 6), ImageUtils.loadImage(mobImage, 2, 2, 3, 2), 2.0f, 2, 6, 6);
                break;
            }
            case SKELETON: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0, 8, 8);
                break;
            }
            case SKELETONWITHER: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0, 8, 8);
                break;
            }
            case SLIME: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 22, 6, 6), 1.0f, 1, 8, 8), ImageUtils.loadImage(mobImage, 34, 6, 2, 2), 5.0f, 2, 8, 8), ImageUtils.loadImage(mobImage, 34, 2, 2, 2), 1.0f, 2, 8, 8), ImageUtils.loadImage(mobImage, 33, 9, 1, 1), 4.0f, 5, 8, 8), ImageUtils.loadImage(mobImage, 8, 8, 8, 8), 0.0f, 0, 8, 8);
                break;
            }
            case SNOWGOLEM: {
                image = ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64);
                break;
            }
            case SPIDER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 8), ImageUtils.loadImage(mobImage, 6, 6, 6, 6), 1.0f, 1, 8, 8), ImageUtils.loadImage(mobImage, 40, 12, 8, 8), 0.0f, 0, 8, 8);
                break;
            }
            case SPIDERJOCKEY: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 16), ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0, 8, 8), 0.0f, 0, 8, 16), ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImageSecondary, 8, 8), ImageUtils.loadImage(mobImageSecondary, 6, 6, 6, 6), 1.0f, 1, 8, 8), ImageUtils.loadImage(mobImageSecondary, 40, 12, 8, 8), 0.0f, 0, 8, 8), 0.0f, 8, 8, 16);
                break;
            }
            case SPIDERJOCKEYWITHER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 16), ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8), ImageUtils.loadImage(mobImage, 40, 8, 8, 8), 0.0f, 0, 8, 8), 0.0f, 0, 8, 16), ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImageSecondary, 8, 8), ImageUtils.loadImage(mobImageSecondary, 6, 6, 6, 6), 1.0f, 1, 8, 8), ImageUtils.loadImage(mobImageSecondary, 40, 12, 8, 8), 0.0f, 0, 8, 8), 0.0f, 8, 8, 16);
                break;
            }
            case SQUID: {
                image = ImageUtils.scaleImage(ImageUtils.loadImage(mobImage, 12, 12, 12, 16), 0.5f);
                break;
            }
            case VILLAGER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 64), 0.0f, 1, 8, 12), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 64), 3.0f, 8, 8, 12);
                break;
            }
            case WITCH: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 10, 16, 64, 128), ImageUtils.loadImage(mobImage, 8, 8, 8, 10, 64, 128), 1.0f, 5, 10, 16), ImageUtils.loadImage(mobImage, 26, 2, 2, 4, 64, 128), 4.0f, 12, 10, 16), ImageUtils.loadImage(mobImage, 10, 74, 10, 3, 64, 128), 0.0f, 4, 10, 16), ImageUtils.loadImage(mobImage, 7, 83, 7, 4, 64, 128), 1.5f, 0, 10, 16), ImageUtils.loadImage(mobImage, 1, 1, 1, 1, 64, 128), 5.0f, 14, 10, 16);
                break;
            }
            case WITHER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2, 24, 10);
                break;
            }
            case WITHERINVULNERABLE: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 24, 10, 64, 64), ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), 8.0f, 0, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 0.0f, 2, 24, 10), ImageUtils.loadImage(mobImage, 38, 6, 6, 6, 64, 64), 18.0f, 2, 24, 10);
                break;
            }
            case WOLF: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 6, 8), ImageUtils.loadImage(mobImage, 4, 4, 6, 6), 0.0f, 2, 6, 8), ImageUtils.loadImage(mobImage, 4, 14, 3, 3), 1.5f, 5, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 0.0f, 0, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 4.0f, 0, 6, 8);
                break;
            }
            case WOLFANGRY: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 6, 8), ImageUtils.loadImage(mobImage, 4, 4, 6, 6), 0.0f, 2, 6, 8), ImageUtils.loadImage(mobImage, 4, 14, 3, 3), 1.5f, 5, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 0.0f, 0, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 4.0f, 0, 6, 8);
                break;
            }
            case WOLFTAME: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 6, 8), ImageUtils.loadImage(mobImage, 4, 4, 6, 6), 0.0f, 2, 6, 8), ImageUtils.loadImage(mobImage, 4, 14, 3, 3), 1.5f, 5, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 0.0f, 0, 6, 8), ImageUtils.loadImage(mobImage, 17, 15, 2, 2), 4.0f, 0, 6, 8);
                break;
            }
            case ZOMBIE: {
                image = ImageUtils.addImages(ImageUtils.loadImage(mobImage, 8, 8, 8, 8, 64, 64), ImageUtils.loadImage(mobImage, 40, 8, 8, 8, 64, 64), 0.0f, 0, 8, 8);
                break;
            }
            case ZOMBIEVILLAGER: {
                image = ImageUtils.addImages(ImageUtils.addImages(ImageUtils.blankImage(mobImage, 8, 12, 64, 64), ImageUtils.loadImage(mobImage, 8, 40, 8, 10, 64, 64), 0.0f, 1, 8, 12), ImageUtils.loadImage(mobImage, 26, 34, 2, 4, 64, 64), 3.0f, 8, 8, 12);
                break;
            }
            default: {
                throw new IllegalArgumentException("New mob type: " + type.name + ". Need to construct icon for it!");
            }
        }
        return image;
    }

    private void replaceGenericPlayerRefs(int oldRef, int newRef) {
        for (Map.Entry<String, Integer> entry : this.mpContacts.entrySet()) {
            if (!entry.getValue().equals(oldRef)) continue;
            entry.setValue(newRef);
        }
    }

    @Override
    public void OnTickInGame(azd mc, LayoutVariables layoutVariables) {
        int guiScale;
        if (this.game == null) {
            this.game = mc;
        }
        this.layoutVariables = layoutVariables;
        if (this.fontRenderer == null) {
            this.fontRenderer = this.game.l;
        }
        if (!this.textureManagerLoaded && this.completedLoading && GLUtils.textureManager != null) {
            int t;
            this.textureManagerLoaded = true;
            for (t = 0; t < this.icons.length; ++t) {
                this.imageRef[t][0] = GLUtils.tex(this.icons[t][0]);
                this.imageRef[t][1] = GLUtils.tex(this.icons[t][1]);
                this.randomobRef.put(EnumMobs.values()[t].resourceLocation.toString() + (EnumMobs.values()[t].secondaryResourceLocation != null ? EnumMobs.values()[t].secondaryResourceLocation.toString() : "") + "0", this.imageRef[t][0]);
                this.randomobRef.put(EnumMobs.values()[t].resourceLocation.toString() + (EnumMobs.values()[t].secondaryResourceLocation != null ? EnumMobs.values()[t].secondaryResourceLocation.toString() : "") + "1", this.imageRef[t][1]);
            }
            for (t = 0; t < this.armorIcons.length; ++t) {
                this.armorImageRef[t][0] = GLUtils.tex(this.armorIcons[t][0]);
                this.armorImageRef[t][1] = GLUtils.tex(this.armorIcons[t][1]);
            }
            this.crownRef = GLUtils.tex(this.crown);
        }
        if (this.options.isChanged()) {
            this.timer = 500;
            if (this.options.outlines != this.lastOutlines) {
                this.lastOutlines = this.options.outlines;
                this.outlinesChanged();
            }
        }
        guiScale = (guiScale = layoutVariables.scScale) >= 4 ? 1 : 0;
        this.direction = this.game.h.z + 180.0f;
        while (this.direction >= 360.0f) {
            this.direction -= 360.0f;
        }
        while (this.direction < 0.0f) {
            this.direction += 360.0f;
        }
        if (this.enabled && this.options.show) {
            if (this.timer > 95 && GLUtils.textureManager != null) {
                this.calculateMobs();
                this.timer = 0;
            }
            ++this.timer;
            if (this.completedLoading) {
                this.renderMapMobs(this.layoutVariables.mapX, this.layoutVariables.mapY, guiScale);
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private int chkLen(String paramStr) {
        return this.fontRenderer.a(paramStr);
    }

    private void write(String paramStr, int paramInt1, int paramInt2, int paramInt3) {
        this.fontRenderer.a(paramStr, paramInt1, paramInt2, paramInt3);
    }

    public void calculateMobs() {
        this.contacts.clear();
        double max = Math.pow(2.0, this.layoutVariables.zoom) * 16.0 - 0.0;
        List entities = this.game.f.C();
        for (int j = 0; j < entities.size(); ++j) {
            qn entity = (qn)entities.get(j);
            try {
                if (entity.ap() || !(this.options.showHostiles && this.isHostile(entity) || this.options.showPlayers && this.isPlayer(entity)) && (!this.options.showNeutrals || !this.isNeutral(entity))) continue;
                int wayX = GameVariableAccessShim.xCoord() - (int)entity.t;
                int wayZ = GameVariableAccessShim.zCoord() - (int)entity.v;
                int wayY = GameVariableAccessShim.yCoord() - (int)entity.u;
                double hypot = wayX * wayX + wayZ * wayZ + wayY * wayY;
                if (!((hypot /= Math.pow(2.0, this.layoutVariables.zoom) / 2.0 * (Math.pow(2.0, this.layoutVariables.zoom) / 2.0)) < 961.0)) continue;
                Contact contact = new Contact(entity, this.getContactTypeStrict(entity));
                contact.updateLocation();
                if (contact.type != EnumMobs.UNKNOWN) {
                    contact.refs = new int[]{this.imageRef[contact.type.ordinal()][0], this.imageRef[contact.type.ordinal()][1]};
                }
                if (contact.type == EnumMobs.PLAYER) {
                    this.handleMPplayer(contact);
                }
                if (contact.type == EnumMobs.UNKNOWN) {
                    this.tryCustomIcon(contact);
                }
                if (contact.type == EnumMobs.UNKNOWN) {
                    this.tryAutoIcon(contact);
                }
                if (contact.type == EnumMobs.UNKNOWN) {
                    this.tryFallbackType(contact);
                }
                if (contact.type != EnumMobs.CUSTOM && contact.type != EnumMobs.UNKNOWN && contact.type != EnumMobs.BLANK && this.options.randomobs) {
                    contact.refs = this.getRefsForRandomob(contact);
                }
                if (this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER) {
                    this.getArmor(contact, entity);
                }
                if (contact.type == EnumMobs.UNKNOWN || contact.type == EnumMobs.CUSTOM || contact.type == EnumMobs.AUTO) {
                    String name = qt.b((qn)entity);
                    CustomMob customMob = CustomMobsManager.getCustomMobByName(name);
                    if (customMob != null && !customMob.enabled) continue;
                    this.contacts.add(contact);
                    continue;
                }
                if (!contact.type.enabled) continue;
                this.contacts.add(contact);
                continue;
            }
            catch (Exception e) {
                System.err.println(e.getLocalizedMessage());
                e.printStackTrace();
            }
        }
        Collections.sort(this.contacts, new Comparator<Contact>(){

            @Override
            public int compare(Contact contact1, Contact contact2) {
                return contact1.y - contact2.y;
            }
        });
    }

    private void tryCustomIcon(Contact contact) {
        block30: {
            Integer ref = this.imageRefCustomType.get(contact.entity.getClass().getName() + 0);
            if (ref == null) {
                boolean isHostile = this.isHostile(contact.entity);
                CustomMobsManager.add(qt.b((qn)contact.entity), isHostile, !isHostile);
                try {
                    int intendedSize = 8;
                    String fullPath = "textures/icons/" + contact.entity.getClass().getName() + ".png";
                    InputStream is = null;
                    try {
                        is = this.game.O().a(new bqo(fullPath)).b();
                    }
                    catch (IOException e) {
                        is = null;
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + contact.entity.getClass().getSimpleName() + ".png";
                        try {
                            is = this.game.O().a(new bqo(fullPath)).b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + contact.entity.getClass().getName() + "8.png";
                        try {
                            is = this.game.O().a(new bqo(fullPath)).b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + contact.entity.getClass().getSimpleName() + "8.png";
                        try {
                            is = this.game.O().a(new bqo(fullPath)).b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        intendedSize = 16;
                        fullPath = "textures/icons/" + contact.entity.getClass().getName() + "16.png";
                        try {
                            is = this.game.O().a(new bqo(fullPath)).b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + contact.entity.getClass().getSimpleName() + "16.png";
                        try {
                            is = this.game.O().a(new bqo(fullPath)).b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        intendedSize = 32;
                        fullPath = "textures/icons/" + contact.entity.getClass().getName() + "32.png";
                        try {
                            is = this.game.O().a(new bqo(fullPath)).b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is == null) {
                        fullPath = "textures/icons/" + contact.entity.getClass().getSimpleName() + "32.png";
                        try {
                            is = this.game.O().a(new bqo(fullPath)).b();
                        }
                        catch (IOException e) {
                            is = null;
                        }
                    }
                    if (is != null) {
                        BufferedImage mobSkin = ImageIO.read(is);
                        is.close();
                        mobSkin = ImageUtils.loadImage(mobSkin, 0, 0, mobSkin.getWidth(), mobSkin.getHeight(), mobSkin.getWidth(), mobSkin.getHeight());
                        float scale = (float)mobSkin.getWidth() / (float)intendedSize;
                        BufferedImage mobSkin0 = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(mobSkin, 1.0f / scale)), this.options.outlines);
                        BufferedImage mobSkin1 = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(mobSkin, 2.0f / scale)), this.options.outlines);
                        int ref0 = GLUtils.tex(mobSkin0);
                        int ref1 = GLUtils.tex(mobSkin1);
                        this.imageRefCustomType.put(contact.entity.getClass().getName() + 0, ref0);
                        this.imageRefCustomType.put(contact.entity.getClass().getName() + 1, ref1);
                        this.imageSizeCustomOrAutoType.put(ref0, intendedSize * 2);
                        this.imageSizeCustomOrAutoType.put(ref1, intendedSize * 2);
                        contact.refs = new int[]{ref0, ref1};
                        contact.type = EnumMobs.CUSTOM;
                        break block30;
                    }
                    this.imageRefCustomType.put(contact.entity.getClass().getName() + 0, -1);
                }
                catch (IOException e) {
                    this.imageRefCustomType.put(contact.entity.getClass().getName() + 0, -1);
                }
            } else if (ref != -1) {
                contact.type = EnumMobs.CUSTOM;
                contact.refs = new int[]{ref, this.imageRefCustomType.get(contact.entity.getClass().getName() + 1)};
            } else {
                contact.type = EnumMobs.UNKNOWN;
            }
        }
    }

    private void tryAutoIcon(Contact contact) {
        Integer ref = this.imageRefAutoType.get(contact.entity.getClass().getName() + 0);
        if (ref == null) {
            bqo resourceLocation;
            bng render = bnf.a.a(contact.entity);
            BufferedImage mobImage = this.createAutoIconImageFromResourceLocation(contact, render, resourceLocation = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity));
            if (mobImage != null) {
                try {
                    contact.type = EnumMobs.AUTO;
                    contact.refs = this.createRefsFromImage(contact, mobImage);
                    this.imageRefAutoType.put(contact.entity.getClass().getName() + 0, contact.refs[0]);
                    this.imageRefAutoType.put(contact.entity.getClass().getName() + 1, contact.refs[1]);
                    this.randomobRef.put((resourceLocation != null ? resourceLocation.toString() : "") + "0", contact.refs[0]);
                    this.randomobRef.put((resourceLocation != null ? resourceLocation.toString() : "") + "1", contact.refs[1]);
                }
                catch (Exception e) {
                    contact.type = EnumMobs.UNKNOWN;
                    this.imageRefAutoType.put(contact.entity.getClass().getName() + 0, -1);
                }
            } else {
                this.imageRefAutoType.put(contact.entity.getClass().getName() + 0, -1);
            }
        } else if (ref != -1) {
            contact.type = EnumMobs.AUTO;
            contact.refs = new int[]{ref, this.imageRefAutoType.get(contact.entity.getClass().getName() + 1)};
        } else {
            contact.type = EnumMobs.UNKNOWN;
        }
    }

    private BufferedImage createAutoIconImageFromResourceLocation(Contact contact, bng render, bqo resourceLocation) {
        BufferedImage headImage = null;
        if (GLUtils.fboEnabled) {
            try {
                bhl model = VoxelMapProtectedFieldsHelper.getRendersModel((bnz)render);
                ArrayList<Field> submodels = ReflectionUtils.getFieldsByType(model, bhl.class, bir.class);
                bir[] headBits = null;
                if (model instanceof bgw) {
                    headBits = new bir[]{(bir)ReflectionUtils.getPrivateFieldValueByType(model, bgw.class, bir.class)};
                } else if (model instanceof bhg) {
                    headBits = new bir[]{((bhg)model).c, ((bhg)model).d};
                } else if (model instanceof bgx) {
                    headBits = new bir[]{(bir)ReflectionUtils.getPrivateFieldValueByType(model, bgx.class, bir.class, 1)};
                } else if (model instanceof bhb) {
                    headBits = new bir[]{((bhb)model).a};
                } else if (model instanceof bhc) {
                    headBits = new bir[]{((bhc)model).a};
                } else if (model instanceof bhd) {
                    headBits = new bir[]{((bhd)model).a};
                } else if (model instanceof bik) {
                    headBits = new bir[]{(bir)ReflectionUtils.getPrivateFieldValueByType(model, bik.class, bir.class)};
                } else if (model instanceof bhf) {
                    headBits = new bir[]{(bir)ReflectionUtils.getPrivateFieldValueByType(model, bhf.class, bir.class)};
                } else if (model instanceof bhm) {
                    headBits = new bir[]{(bir)ReflectionUtils.getPrivateFieldValueByType(model, bhm.class, bir.class)};
                } else if (model instanceof bid) {
                    headBits = new bir[]{((bid)model).a};
                } else if (model instanceof bhn) {
                    headBits = new bir[]{(bir)ReflectionUtils.getPrivateFieldValueByType(model, bhn.class, bir.class, 6)};
                } else if (model instanceof bho) {
                    headBits = new bir[]{((bho)model).a};
                } else if (model instanceof bhq) {
                    headBits = new bir[]{((bhq)model).a};
                } else if (model instanceof bhu) {
                    headBits = new bir[]{(bir)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, bhu.class, bir[].class))[0], (bir)((Object[])ReflectionUtils.getPrivateFieldValueByType(model, bhu.class, bir[].class))[1]};
                } else if (model instanceof bhy) {
                    bhl modelOuter = VoxelMapProtectedFieldsHelper.getRendersPassModel(render, contact.entity);
                    headBits = new bir[]{(bir)ReflectionUtils.getPrivateFieldValueByType(model, bhy.class, bir.class, 0), (bir)ReflectionUtils.getPrivateFieldValueByType(model, bhy.class, bir.class, 1), (bir)ReflectionUtils.getPrivateFieldValueByType(model, bhy.class, bir.class, 2), (bir)ReflectionUtils.getPrivateFieldValueByType(model, bhy.class, bir.class, 3), (bir)ReflectionUtils.getPrivateFieldValueByType(modelOuter, bhy.class, bir.class, 0)};
                } else if (model instanceof bhz) {
                    headBits = new bir[]{((bhz)model).c};
                } else if (model instanceof bia) {
                    headBits = new bir[]{((bia)model).a};
                } else if (model instanceof bib) {
                    headBits = new bir[]{(bir)ReflectionUtils.getPrivateFieldValueByType(model, bib.class, bir.class)};
                } else if (model instanceof bie) {
                    headBits = new bir[]{((bie)model).a};
                } else if (model instanceof bii) {
                    headBits = new bir[]{((bii)model).a};
                } else {
                    ArrayList<bir> headPartsArrayList = new ArrayList<bir>();
                    ArrayList purge = new ArrayList();
                    for (Field submodel : submodels) {
                        String name = submodel.getName().toLowerCase();
                        String nameS = submodel.getName();
                        if (!(name.contains("head") | name.contains("eye") | name.contains("mouth") | name.contains("teeth") | name.contains("tooth") | name.contains("tusk") | name.contains("jaw") | name.contains("nose") | name.contains("beak") | name.contains("snout") | name.contains("muzzle") | (!name.contains("rear") && name.contains("ear")) | name.contains("trunk") | name.contains("mane") | name.contains("horn") | name.contains("antler") | nameS.equals("REar") | nameS.equals("Trout")) || !(!nameS.equals("LeftSmallEar") & !nameS.equals("RightSmallEar") & !nameS.equals("BHead") & !nameS.equals("BSnout") & !nameS.equals("BMouth") & !nameS.equals("BMouthOpen") & !nameS.equals("BLEar") & !nameS.equals("BREar") & !nameS.equals("CHead") & !nameS.equals("CSnout") & !nameS.equals("CMouth") & !nameS.equals("CMouthOpen") & !nameS.equals("CLEar") & !nameS.equals("CREar")) || submodel.get(model) == null) continue;
                        headPartsArrayList.add((bir)submodel.get(model));
                    }
                    for (bir bit : headPartsArrayList) {
                        if (bit.m == null) continue;
                        purge.addAll(bit.m);
                    }
                    headPartsArrayList.removeAll(purge);
                    headBits = headPartsArrayList.toArray(new bir[headPartsArrayList.size()]);
                }
                if (contact.entity != null && model != null && headBits.length > 0 && resourceLocation != null) {
                    this.drawModel(32, 1000, (rh)contact.entity, model, resourceLocation, headBits);
                    headImage = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
                }
            }
            catch (Exception e) {
                headImage = null;
            }
        }
        return headImage;
    }

    private void drawModel(int size, int captureDepth, rh par5EntityLivingBase, bhl model, bqo resourceLocation, bir ... headBits) {
        int t;
        GL11.glBindTexture((int)3553, (int)GLUtils.fboTextureID);
        int width = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        GL11.glBindTexture((int)3553, (int)0);
        GL11.glPushAttrib((int)22528);
        GL11.glViewport((int)0, (int)0, (int)width, (int)height);
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)width, (double)height, (double)0.0, (double)1000.0, (double)3000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)(-3000.0f + (float)captureDepth));
        GLUtils.bindFrameBuffer();
        float offsetByY = 0.0f;
        float maxY = 0.0f;
        float minY = 0.0f;
        for (t = 0; t < headBits.length; ++t) {
            if (headBits[t].d < minY) {
                minY = headBits[t].d;
            }
            if (!(headBits[t].d > maxY)) continue;
            maxY = headBits[t].d;
        }
        if (minY < -25.0f) {
            offsetByY = -25.0f - minY;
        } else if (maxY > 25.0f) {
            offsetByY = 25.0f - maxY;
        }
        if (captureDepth == 2) {
            offsetByY = 4.0f;
        }
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2929);
        GL11.glEnable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2977);
        GL11.glDisable((int)2884);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16640);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)(width / 2), (float)(height / 2), (float)0.0f);
        GL11.glScalef((float)size, (float)size, (float)size);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GLUtils.img(resourceLocation);
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)500.0f, (float)500.0f, (float)0.0f);
        model.a((qn)par5EntityLivingBase, 0.0f, 0.0f, 163.0f, 360.0f, 0.0f, 0.0625f);
        GL11.glTranslatef((float)-500.0f, (float)-500.0f, (float)0.0f);
        for (t = 0; t < headBits.length; ++t) {
            float y2 = headBits[t].d;
            headBits[t].d += offsetByY;
            headBits[t].a(0.0625f);
            headBits[t].d = y2;
        }
        GL11.glPopMatrix();
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2929);
        GL11.glDepthMask((boolean)false);
        GLUtils.unbindFrameBuffer();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glPopAttrib();
    }

    private void tryFallbackType(Contact contact) {
        contact.type = this.getContactType(contact.entity);
        if (contact.type == EnumMobs.UNKNOWN) {
            contact.type = this.getUnknownMobNeutrality(contact.entity);
        }
        contact.refs = new int[]{this.imageRef[contact.type.ordinal()][0], this.imageRef[contact.type.ordinal()][1]};
    }

    private int[] getRefsForRandomob(Contact contact) {
        Integer refInteger;
        if (contact.type == EnumMobs.PLAYER && contact.refs[0] != this.imageRef[EnumMobs.PLAYER.ordinal()][0]) {
            return contact.refs;
        }
        bqo resourceLocation = null;
        bng render = bnf.a.a(contact.entity);
        resourceLocation = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity);
        try {
            if (this.getEntityTexture != null) {
                resourceLocation = (bqo)this.getEntityTexture.invoke(MobRandomizer.class, (rh)contact.entity, resourceLocation);
            } else if (this.getEntityTextureOptifine != null) {
                long uuidLow = contact.entity.aB().getLeastSignificantBits();
                int id = (int)(uuidLow & Integer.MAX_VALUE);
                resourceLocation = (bqo)this.getEntityTextureOptifine.invoke(RandomMobs.class, resourceLocation, id);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        bqo resourceLocationSecondary = null;
        if (contact.type.secondaryResourceLocation != null) {
            if (contact.type == EnumMobs.MOOSHROOM) {
                resourceLocationSecondary = !((uy)contact.entity).f() ? EnumMobs.MOOSHROOM.secondaryResourceLocation : null;
            } else if (contact.type == EnumMobs.SPIDERJOCKEY || contact.type == EnumMobs.SPIDERJOCKEYWITHER) {
                render = bnf.a.a(((wx)contact.entity).n);
                resourceLocationSecondary = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, ((wx)contact.entity).n);
            }
            try {
                if (this.getEntityTexture != null) {
                    if (contact.type == EnumMobs.MOOSHROOM) {
                        resourceLocationSecondary = (bqo)this.getEntityTexture.invoke(MobRandomizer.class, (rh)contact.entity, resourceLocationSecondary);
                    } else if (contact.type == EnumMobs.SPIDERJOCKEY || contact.type == EnumMobs.SPIDERJOCKEYWITHER) {
                        resourceLocationSecondary = (bqo)this.getEntityTexture.invoke(MobRandomizer.class, (rh)((wx)contact.entity).n, resourceLocationSecondary);
                    }
                } else if (this.getEntityTextureOptifine != null) {
                    long uuidLow = 0L;
                    if (contact.type == EnumMobs.MOOSHROOM) {
                        uuidLow = ((uy)contact.entity).aB().getLeastSignificantBits();
                    } else if (contact.type == EnumMobs.SPIDERJOCKEY || contact.type == EnumMobs.SPIDERJOCKEYWITHER) {
                        uuidLow = ((wx)contact.entity).n.aB().getLeastSignificantBits();
                    }
                    int id = (int)(uuidLow & Integer.MAX_VALUE);
                    resourceLocationSecondary = (bqo)this.getEntityTextureOptifine.invoke(RandomMobs.class, resourceLocationSecondary, id);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((refInteger = this.randomobRef.get((resourceLocation != null ? resourceLocation.toString() : "") + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "") + 0)) == null) {
            BufferedImage mobImage = null;
            if (contact.type == EnumMobs.HORSE && ((uu)contact.entity).cv()) {
                bpz textureObject = GLUtils.textureManager.b(resourceLocation);
                mobImage = ImageUtils.createBufferedImageFromGLID(textureObject.b());
                mobImage = this.createImageFromTypeAndImages(contact.type, mobImage, null);
            } else if (contact.type != EnumMobs.AUTO) {
                mobImage = this.createImageFromTypeAndResourceLocations(contact.type, resourceLocation, resourceLocationSecondary);
            } else if (contact.type == EnumMobs.AUTO) {
                mobImage = this.createAutoIconImageFromResourceLocation(contact, render, resourceLocation);
            }
            if (mobImage == null) {
                return contact.refs;
            }
            int[] refs = this.createRefsFromImage(contact, mobImage);
            this.randomobRef.put((resourceLocation != null ? resourceLocation.toString() : "") + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "") + "0", refs[0]);
            this.randomobRef.put((resourceLocation != null ? resourceLocation.toString() : "") + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "") + "1", refs[1]);
            return refs;
        }
        return new int[]{refInteger, this.randomobRef.get((resourceLocation != null ? resourceLocation.toString() : "") + (resourceLocationSecondary != null ? resourceLocationSecondary.toString() : "") + 1)};
    }

    private int[] createRefsFromImage(Contact contact, BufferedImage image) {
        if (contact.type == EnumMobs.AUTO) {
            image = ImageUtils.trim(image);
            double acceptableMax = 32.0;
            if (ImageUtils.percentageOfEdgePixelsThatAreSolid(image) < 30.0f) {
                acceptableMax = 64.0;
            }
            int maxDimension = Math.max(image.getWidth(), image.getHeight());
            float scale = (float)(1.0 / Math.ceil((double)maxDimension / acceptableMax));
            BufferedImage image0 = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(image, scale / 2.0f)), this.options.outlines);
            BufferedImage image1 = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(image, scale)), this.options.outlines);
            int ref0 = -1;
            int ref1 = -1;
            if (GLUtils.textureManager != null) {
                ref0 = GLUtils.tex(image0);
                ref1 = GLUtils.tex(image1);
                this.imageSizeCustomOrAutoType.put(ref0, image0.getWidth());
                this.imageSizeCustomOrAutoType.put(ref1, image1.getWidth() / 2);
            }
            return new int[]{ref0, ref1};
        }
        float scale = (float)image.getWidth() / (float)contact.type.expectedWidth;
        BufferedImage image0 = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(image, 1.0f / scale)), this.options.outlines);
        BufferedImage image1 = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(image, 2.0f / scale)), this.options.outlines);
        int ref0 = -1;
        int ref1 = -1;
        if (GLUtils.textureManager != null) {
            ref0 = GLUtils.tex(image0);
            ref1 = GLUtils.tex(image1);
        }
        return new int[]{ref0, ref1};
    }

    private void handleMPplayer(Contact contact) {
        String playerName = this.scrubCodes(((bld)contact.entity).bH().getName());
        contact.setName(playerName);
        Integer ref0 = this.mpContacts.get(playerName + 0);
        Integer ref1 = -1;
        Integer checkCount = 0;
        if (ref0 == null) {
            this.mpContactsSkinGetTries.put(playerName, 0);
            checkCount = 0;
        } else if ((ref0 == this.imageRef[EnumMobs.PLAYER.ordinal()][0] || ref0 == this.imageRef[EnumMobs.PLAYER.ordinal()][1]) && (checkCount = this.mpContactsSkinGetTries.get(playerName)) < 5) {
            ref0 = null;
        }
        if (ref0 == null) {
            bpj imageData = null;
            try {
                imageData = ((bld)contact.entity).r();
                BufferedImage skinImage = ImageUtils.createBufferedImageFromGLID(imageData.b());
                if (imageData == null || !imageData.a() || skinImage == null) {
                    ref0 = this.imageRef[EnumMobs.PLAYER.ordinal()][0];
                    ref1 = this.imageRef[EnumMobs.PLAYER.ordinal()][1];
                } else {
                    skinImage = ImageUtils.addImages(ImageUtils.loadImage(skinImage, 8, 8, 8, 8), ImageUtils.loadImage(skinImage, 40, 8, 8, 8), 0.0f, 0, 8, 8);
                    float scale = (float)skinImage.getWidth() / 8.0f;
                    BufferedImage skinImageSmall = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(skinImage, 1.0f / scale)), this.options.outlines);
                    BufferedImage skinImageLarge = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(skinImage, 2.0f / scale)), this.options.outlines);
                    ref0 = GLUtils.tex(skinImageSmall);
                    ref1 = GLUtils.tex(skinImageLarge);
                }
            }
            catch (Exception e) {
                ref0 = this.imageRef[EnumMobs.PLAYER.ordinal()][0];
                ref1 = this.imageRef[EnumMobs.PLAYER.ordinal()][1];
            }
            this.mpContacts.put(playerName + 0, ref0);
            this.mpContacts.put(playerName + 1, ref1);
            if (ref0.equals(this.imageRef[EnumMobs.PLAYER.ordinal()][0])) {
                Integer n = checkCount;
                Integer n2 = checkCount = Integer.valueOf(checkCount + 1);
                this.mpContactsSkinGetTries.put(playerName, checkCount);
            } else {
                this.mpContactsSkinGetTries.remove(playerName);
            }
            contact.refs = new int[]{ref0, ref1};
        } else {
            contact.refs = new int[]{ref0, this.mpContacts.get(playerName + 1)};
        }
    }

    private void getArmor(Contact contact, qn entity) {
        abp stack = ((rh)entity).q(4);
        abn helmet = null;
        if (stack != null && stack.b > 0) {
            helmet = stack.b();
        }
        if (helmet != null) {
            if (helmet instanceof zn) {
                zn helmetArmor = (zn)helmet;
                contact.setArmor(this.getArmorType(helmetArmor));
                if (contact.armorValue == 0) {
                    contact.setArmorColor(helmetArmor.a(stack, 0));
                } else if (contact.armorValue == UNKNOWN) {
                    Integer ref = this.armorImageRefCustomType.get("" + helmet.a() + 0);
                    if (ref == null) {
                        this.createUnknownArmorRef(contact, stack, helmet);
                    } else if (ref == -1) {
                        contact.armorValue = UNKNOWN;
                    } else {
                        contact.armorValue = CUSTOM;
                        contact.helmet = helmet;
                    }
                }
            } else {
                int id = abn.b((abn)helmet);
                if (id < 256) {
                    contact.setBlockOnHead(id);
                    contact.setBlockOnHeadMetadata(stack.k());
                } else if (helmet == abn.e.a("skull")) {
                    contact.setBlockOnHead(id);
                    contact.setBlockOnHeadMetadata(stack.k());
                }
            }
        }
    }

    private void createUnknownArmorRef(Contact contact, abp stack, abn helmet) {
        Method m = null;
        try {
            m = bno.class.getMethod("getArmorResource", qn.class, abp.class, Integer.TYPE, String.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        Method getResourceLocation = m;
        bqo resourceLocation = null;
        try {
            if (getResourceLocation != null) {
                resourceLocation = (bqo)getResourceLocation.invoke(null, contact.entity, stack, 3, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        m = null;
        try {
            Class<?> c = Class.forName("net.minecraftforge.client.ForgeHooksClient");
            m = c.getMethod("getArmorModel", rh.class, abp.class, Integer.TYPE, bhg.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        Method getModel = m;
        bhg modelBiped = null;
        try {
            if (getModel != null) {
                modelBiped = (bhg)getModel.invoke(null, contact.entity, stack, 0, null);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (modelBiped != null && resourceLocation != null) {
            bir[] headBits = new bir[]{modelBiped.c, modelBiped.d};
            this.drawModel(32, 2, (rh)contact.entity, (bhl)modelBiped, resourceLocation, headBits);
            BufferedImage armorTexture = ImageUtils.createBufferedImageFromGLID(GLUtils.fboTextureID);
            armorTexture = armorTexture.getSubimage(100, 100, 56, 56);
            float scale = 2.0f;
            BufferedImage armorImage0 = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(armorTexture, 1.0f / scale)), this.options.outlines, true, true, 0);
            BufferedImage armorImage1 = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(armorTexture, 2.0f / scale)), this.options.outlines, true, true, 0);
            this.armorImageRefCustomType.put("" + helmet.a() + 0, GLUtils.tex(armorImage0));
            this.armorImageRefCustomType.put("" + helmet.a() + 1, GLUtils.tex(armorImage1));
            this.armorImageSizeCustomType.put("" + helmet.a(), 64);
            return;
        }
        if (resourceLocation != null) {
            try {
                InputStream is = null;
                try {
                    is = this.game.O().a(resourceLocation).b();
                }
                catch (IOException e) {
                    is = null;
                }
                if (is != null) {
                    BufferedImage armorTexture = ImageIO.read(is);
                    is.close();
                    armorTexture = ImageUtils.addImages(ImageUtils.loadImage(armorTexture, 8, 8, 8, 8), ImageUtils.loadImage(armorTexture, 40, 8, 8, 8), 0.0f, 0, 8, 8);
                    float scale = (float)armorTexture.getWidth() / 8.0f;
                    BufferedImage armorImage0 = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(armorTexture, 1.0f / scale)), this.options.outlines, true, false, 0);
                    BufferedImage armorImage1 = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(armorTexture, 2.0f / scale)), this.options.outlines, true, false, 0);
                    this.armorImageRefCustomType.put("" + helmet.a() + 0, GLUtils.tex(armorImage0));
                    this.armorImageRefCustomType.put("" + helmet.a() + 1, GLUtils.tex(armorImage1));
                    this.armorImageSizeCustomType.put("" + helmet.a(), 20);
                    contact.armorValue = CUSTOM;
                    contact.helmet = helmet;
                    return;
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        System.out.println("can't get texture for custom armor type: " + helmet.getClass());
        this.armorImageRefCustomType.put("" + helmet.a() + 0, -1);
    }

    private String scrubCodes(String string) {
        string = string.replaceAll("(\\xA7.)", "");
        return string;
    }

    private EnumMobs getContactTypeStrict(qn entity) {
        Class<?> entityClass = entity.getClass();
        if (entityClass.equals(uq.class)) {
            return EnumMobs.BAT;
        }
        if (entityClass.equals(wj.class)) {
            return EnumMobs.BLAZE;
        }
        if (entityClass.equals(wk.class)) {
            return EnumMobs.CAVESPIDER;
        }
        if (entityClass.equals(us.class)) {
            return EnumMobs.CHICKEN;
        }
        if (entityClass.equals(uy.class)) {
            return EnumMobs.MOOSHROOM;
        }
        if (entityClass.equals(ut.class)) {
            return EnumMobs.COW;
        }
        if (entityClass.equals(wl.class)) {
            return EnumMobs.CREEPER;
        }
        if (entityClass.equals(vm.class)) {
            return EnumMobs.ENDERDRAGON;
        }
        if (entityClass.equals(wm.class)) {
            return EnumMobs.ENDERMAN;
        }
        if (entityClass.equals(wp.class)) {
            return EnumMobs.GHAST;
        }
        if (entityClass.equals(uu.class)) {
            return EnumMobs.HORSE;
        }
        if (entityClass.equals(vf.class)) {
            return EnumMobs.IRONGOLEM;
        }
        if (entityClass.equals(wr.class)) {
            return EnumMobs.MAGMA;
        }
        if (entityClass.equals(uz.class)) {
            bng render = bnf.a.a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, entity).a();
            return path.endsWith("ocelot.png") ? EnumMobs.OCELOT : EnumMobs.CAT;
        }
        if (entityClass.equals(va.class)) {
            return EnumMobs.PIG;
        }
        if (entityClass.equals(wt.class)) {
            return EnumMobs.PIGZOMBIE;
        }
        if (entity instanceof bld) {
            return EnumMobs.PLAYER;
        }
        if (entityClass.equals(vb.class)) {
            return EnumMobs.SHEEP;
        }
        if (entityClass.equals(ww.class)) {
            return EnumMobs.SILVERFISH;
        }
        if (entityClass.equals(wx.class)) {
            bng render = bnf.a.a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, entity).a();
            if (((wx)entity).n == null) {
                return path.endsWith("wither_skeleton.png") ? EnumMobs.SKELETONWITHER : EnumMobs.SKELETON;
            }
            return path.endsWith("wither_skeleton.png") ? EnumMobs.SPIDERJOCKEYWITHER : EnumMobs.SPIDERJOCKEY;
        }
        if (entityClass.equals(wy.class)) {
            return EnumMobs.SLIME;
        }
        if (entityClass.equals(vd.class)) {
            return EnumMobs.SNOWGOLEM;
        }
        if (entityClass.equals(wz.class)) {
            return ((wz)entity).m != null ? EnumMobs.BLANK : EnumMobs.SPIDER;
        }
        if (entityClass.equals(ve.class)) {
            return EnumMobs.SQUID;
        }
        if (entityClass.equals(xh.class)) {
            return EnumMobs.VILLAGER;
        }
        if (entityClass.equals(xb.class)) {
            return EnumMobs.WITCH;
        }
        if (entityClass.equals(vo.class)) {
            return EnumMobs.WITHER;
        }
        if (entityClass.equals(vh.class)) {
            bng render = bnf.a.a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, entity).a();
            return path.endsWith("wolf_tame.png") ? EnumMobs.WOLFTAME : (path.endsWith("wolf_angry.png") ? EnumMobs.WOLFANGRY : EnumMobs.WOLF);
        }
        if (entityClass.equals(xc.class)) {
            bng render = bnf.a.a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, entity).a();
            return path.endsWith("zombie_villager.png") ? EnumMobs.ZOMBIEVILLAGER : EnumMobs.ZOMBIE;
        }
        return EnumMobs.UNKNOWN;
    }

    private EnumMobs getContactType(qn entity) {
        if (entity instanceof uq) {
            return EnumMobs.BAT;
        }
        if (entity instanceof wj) {
            return EnumMobs.BLAZE;
        }
        if (entity instanceof wk) {
            return EnumMobs.CAVESPIDER;
        }
        if (entity instanceof us) {
            return EnumMobs.CHICKEN;
        }
        if (entity instanceof uy) {
            return EnumMobs.MOOSHROOM;
        }
        if (entity instanceof ut) {
            return EnumMobs.COW;
        }
        if (entity instanceof wl) {
            return EnumMobs.CREEPER;
        }
        if (entity instanceof vm) {
            return EnumMobs.ENDERDRAGON;
        }
        if (entity instanceof wm) {
            return EnumMobs.ENDERMAN;
        }
        if (entity instanceof wp) {
            return EnumMobs.GHAST;
        }
        if (entity instanceof uu) {
            return EnumMobs.HORSE;
        }
        if (entity instanceof vf) {
            return EnumMobs.IRONGOLEM;
        }
        if (entity instanceof wr) {
            return EnumMobs.MAGMA;
        }
        if (entity instanceof uz) {
            bng render = bnf.a.a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, entity).a();
            return path.endsWith("ocelot.png") ? EnumMobs.OCELOT : EnumMobs.CAT;
        }
        if (entity instanceof va) {
            return EnumMobs.PIG;
        }
        if (entity instanceof wt) {
            return EnumMobs.PIGZOMBIE;
        }
        if (entity instanceof bld) {
            return EnumMobs.PLAYER;
        }
        if (entity instanceof vb) {
            return EnumMobs.SHEEP;
        }
        if (entity instanceof ww) {
            return EnumMobs.SILVERFISH;
        }
        if (entity instanceof wx) {
            bng render = bnf.a.a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, entity).a();
            if (((wx)entity).n == null) {
                return path.endsWith("wither_skeleton.png") ? EnumMobs.SKELETONWITHER : EnumMobs.SKELETON;
            }
            return path.endsWith("wither_skeleton.png") ? EnumMobs.SPIDERJOCKEYWITHER : EnumMobs.SPIDERJOCKEY;
        }
        if (entity instanceof wy) {
            return EnumMobs.SLIME;
        }
        if (entity instanceof vd) {
            return EnumMobs.SNOWGOLEM;
        }
        if (entity instanceof wz) {
            return ((wz)entity).m != null ? EnumMobs.BLANK : EnumMobs.SPIDER;
        }
        if (entity instanceof ve) {
            return EnumMobs.SQUID;
        }
        if (entity instanceof xh) {
            return EnumMobs.VILLAGER;
        }
        if (entity instanceof xb) {
            return EnumMobs.WITCH;
        }
        if (entity instanceof vo) {
            return EnumMobs.WITHER;
        }
        if (entity instanceof vh) {
            bng render = bnf.a.a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, entity).a();
            return path.endsWith("wolf_tame.png") ? EnumMobs.WOLFTAME : (path.endsWith("wolf_angry.png") ? EnumMobs.WOLFANGRY : EnumMobs.WOLF);
        }
        if (entity instanceof xc) {
            bng render = bnf.a.a(entity);
            String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, entity).a();
            return path.endsWith("zombie_villager.png") ? EnumMobs.ZOMBIEVILLAGER : EnumMobs.ZOMBIE;
        }
        return EnumMobs.UNKNOWN;
    }

    private EnumMobs getUnknownMobNeutrality(qn entity) {
        if (this.isHostile(entity)) {
            return EnumMobs.BLANKHOSTILE;
        }
        if (entity instanceof rs && ((rs)entity).bX() && (this.game.F() || ((rs)entity).b().equals(this.game.h.bH().getName()))) {
            return EnumMobs.BLANKTAME;
        }
        return EnumMobs.BLANKNEUTRAL;
    }

    private int getArmorType(zn helmet) {
        if (helmet.a().equals("item.helmetCloth")) {
            return 0;
        }
        if (helmet.a().equals("item.helmetChain")) {
            return 4;
        }
        if (helmet.a().equals("item.helmetIron")) {
            return 6;
        }
        if (helmet.a().equals("item.helmetGold")) {
            return 8;
        }
        if (helmet.a().equals("item.helmetDiamond")) {
            return 10;
        }
        return UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderMapMobs(int x, int y2, int guiScale) {
        double max = Math.pow(2.0, this.layoutVariables.zoom) * 16.0 - 0.0;
        for (int j = 0; j < this.contacts.size(); ++j) {
            Contact contact = this.contacts.get(j);
            contact.updateLocation();
            double contactX = contact.x;
            double contactZ = contact.z;
            int contactY = contact.y;
            double wayX = GameVariableAccessShim.xCoordDouble() - contactX;
            double wayZ = GameVariableAccessShim.zCoordDouble() - contactZ;
            int wayY = GameVariableAccessShim.yCoord() - contactY;
            double adjustedDiff = max - (double)Math.max(Math.abs(wayY) - 0, 0);
            contact.brightness = (float)Math.max(adjustedDiff / max, 0.0);
            contact.brightness *= contact.brightness;
            contact.angle = (float)Math.toDegrees(Math.atan2(wayX, wayZ));
            contact.distance = Math.sqrt(wayX * wayX + wayZ * wayZ) / (Math.pow(2.0, this.layoutVariables.zoom) / 2.0);
            GL11.glBlendFunc((int)770, (int)771);
            if (wayY < 0) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)contact.brightness);
            } else {
                GL11.glColor3f((float)(1.0f * contact.brightness), (float)(1.0f * contact.brightness), (float)(1.0f * contact.brightness));
            }
            if (!(this.minimapOptions.squareMap && Math.abs(wayX) / (Math.pow(2.0, this.layoutVariables.zoom) / 2.0) <= 28.5 && Math.abs(wayZ) / (Math.pow(2.0, this.layoutVariables.zoom) / 2.0) <= 28.5) && (this.minimapOptions.squareMap || !(contact.distance < 31.0))) continue;
            try {
                int northRotate;
                GL11.glPushMatrix();
                int n = northRotate = this.minimapOptions.oldNorth ? 90 : 0;
                if (this.options.filtering) {
                    int mobSpecificRotationFactor = contact.type == EnumMobs.HORSE ? 45 : 0;
                    GL11.glTranslatef((float)x, (float)y2, (float)0.0f);
                    GL11.glRotatef((float)(-contact.angle + (this.minimapOptions.squareMap ? (float)northRotate : -this.direction)), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslated((double)0.0, (double)(-contact.distance), (double)0.0);
                    GL11.glRotatef((float)(-(-contact.angle + (this.minimapOptions.squareMap ? (float)northRotate : -this.direction)) + (float)mobSpecificRotationFactor), (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)(-x), (float)(-y2), (float)0.0f);
                } else {
                    wayX = Math.sin(Math.toRadians(-(-contact.angle + (this.minimapOptions.squareMap ? (float)northRotate : -this.direction)))) * contact.distance;
                    wayZ = Math.cos(Math.toRadians(-(-contact.angle + (this.minimapOptions.squareMap ? (float)northRotate : -this.direction)))) * contact.distance;
                    if (this.options.filtering) {
                        GL11.glTranslated((double)(-wayX), (double)(-wayZ), (double)0.0);
                    } else {
                        GL11.glTranslated((double)((double)Math.round(-wayX * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale), (double)((double)Math.round(-wayZ * (double)this.layoutVariables.scScale) / (double)this.layoutVariables.scScale), (double)0.0);
                    }
                }
                if (contact.type == EnumMobs.PLAYER && contact.name.equals("MamiyaOtaru")) {
                    GLUtils.img(new bqo("voxelmap", "images/glow.png"));
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(x, y2, 16);
                    GLUtils.drawPost();
                }
                if (contact.type == EnumMobs.GHAST || contact.type == EnumMobs.WITHER || contact.type == EnumMobs.WITHERINVULNERABLE) {
                    if (contact.type == EnumMobs.GHAST) {
                        bng render = bnf.a.a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity).a();
                        contact.type = path.endsWith("ghast_fire.png") ? EnumMobs.GHASTATTACKING : EnumMobs.GHAST;
                        contact.refs = new int[]{this.imageRef[contact.type.ordinal()][0], this.imageRef[contact.type.ordinal()][1]};
                    } else if (contact.type == EnumMobs.WITHER || contact.type == EnumMobs.WITHERINVULNERABLE) {
                        bng render = bnf.a.a(contact.entity);
                        String path = VoxelMapProtectedFieldsHelper.getRendersResourceLocation(render, contact.entity).a();
                        contact.type = path.endsWith("wither_invulnerable.png") ? EnumMobs.WITHERINVULNERABLE : EnumMobs.WITHER;
                        contact.refs = new int[]{this.imageRef[contact.type.ordinal()][0], this.imageRef[contact.type.ordinal()][1]};
                    }
                    if (this.options.randomobs && (this.randomobsInstalled || this.randomobsOptifine)) {
                        contact.refs = this.getRefsForRandomob(contact);
                    }
                }
                GLUtils.disp(contact.refs[guiScale]);
                this.applyFilteringParameters();
                GLUtils.drawPre();
                if (contact.type == EnumMobs.CUSTOM || contact.type == EnumMobs.AUTO) {
                    Integer size = this.imageSizeCustomOrAutoType.get(contact.refs[guiScale]);
                    if (size == null) {
                        size = 8;
                    }
                    GLUtils.setMap(x, y2, size);
                } else {
                    GLUtils.setMap(x, y2, contact.type.squaredSize);
                }
                GLUtils.drawPost();
                if (this.options.showHelmetsPlayers && contact.type == EnumMobs.PLAYER || this.options.showHelmetsMobs && contact.type != EnumMobs.PLAYER) {
                    if (contact.blockOnHead != -1) {
                        Integer ref = -1;
                        if (contact.blockOnHead == abn.e.b(abn.e.a("skull"))) {
                            switch (contact.blockOnHeadMetadata) {
                                case 0: {
                                    ref = this.imageRef[EnumMobs.SKELETON.ordinal()][guiScale];
                                    break;
                                }
                                case 1: {
                                    ref = this.imageRef[EnumMobs.SKELETONWITHER.ordinal()][guiScale];
                                    break;
                                }
                                case 2: {
                                    ref = this.imageRef[EnumMobs.ZOMBIE.ordinal()][guiScale];
                                    break;
                                }
                                case 3: {
                                    ref = this.imageRef[EnumMobs.PLAYER.ordinal()][guiScale];
                                    break;
                                }
                                case 4: {
                                    ref = this.imageRef[EnumMobs.CREEPER.ordinal()][guiScale];
                                }
                            }
                        } else {
                            ref = this.armorImageRefCustomType.get(contact.blockOnHead + " " + contact.blockOnHeadMetadata + " " + guiScale);
                            if (ref == null) {
                                BufferedImage blockImage = this.master.getColorManager().getBlockImage(contact.blockOnHead, contact.blockOnHeadMetadata);
                                float scale = (float)blockImage.getWidth() / 8.0f;
                                BufferedImage largeImage = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(blockImage, 2.0f / scale)), this.options.outlines);
                                ref = GLUtils.tex(largeImage);
                                this.armorImageRefCustomType.put(contact.blockOnHead + " " + contact.blockOnHeadMetadata + " " + 1, ref);
                                BufferedImage smallImage = ImageUtils.fillOutline(ImageUtils.intoSquare(ImageUtils.scaleImage(blockImage, 1.0f / scale)), this.options.outlines);
                                ref = GLUtils.tex(smallImage);
                                this.armorImageRefCustomType.put(contact.blockOnHead + " " + contact.blockOnHeadMetadata + " " + 0, ref);
                            }
                        }
                        if (ref != -1) {
                            GLUtils.disp(ref);
                            this.applyFilteringParameters();
                            GLUtils.drawPre();
                            GLUtils.setMap(x, y2, 16);
                            GLUtils.drawPost();
                        }
                    } else if (contact.armorValue != UNKNOWN && contact.armorValue != -1) {
                        int armorSize = 20;
                        float armorOffset = 0.0f;
                        if (contact.type == EnumMobs.ZOMBIEVILLAGER) {
                            armorOffset = -0.5f;
                        }
                        float red = 1.0f;
                        float green = 1.0f;
                        float blue = 1.0f;
                        if (contact.armorValue == 0) {
                            red = (float)(contact.armorColor >> 16 & 0xFF) / 255.0f;
                            green = (float)(contact.armorColor >> 8 & 0xFF) / 255.0f;
                            blue = (float)(contact.armorColor >> 0 & 0xFF) / 255.0f;
                            if (wayY < 0) {
                                GL11.glColor4f((float)red, (float)green, (float)blue, (float)contact.brightness);
                            } else {
                                GL11.glColor3f((float)(red * contact.brightness), (float)(green * contact.brightness), (float)(blue * contact.brightness));
                            }
                        }
                        if (contact.armorValue == CUSTOM) {
                            Integer ref = this.armorImageRefCustomType.get("" + contact.helmet.a() + guiScale);
                            if (ref != null && ref != -1) {
                                GLUtils.disp(ref);
                                armorSize = this.armorImageSizeCustomType.get("" + contact.helmet.a());
                            } else {
                                GLUtils.disp(this.armorImageRef[6][guiScale]);
                            }
                        } else {
                            GLUtils.disp(this.armorImageRef[contact.armorValue][guiScale]);
                        }
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(x, (float)y2 + armorOffset, armorSize);
                        GLUtils.drawPost();
                        if (contact.armorValue == 0) {
                            if (wayY < 0) {
                                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)contact.brightness);
                            } else {
                                GL11.glColor3f((float)(1.0f * contact.brightness), (float)(1.0f * contact.brightness), (float)(1.0f * contact.brightness));
                            }
                            GLUtils.disp(this.armorImageRef[2][guiScale]);
                            this.applyFilteringParameters();
                            GLUtils.drawPre();
                            GLUtils.setMap(x, (float)y2 + armorOffset, 20);
                            GLUtils.drawPost();
                            if (wayY < 0) {
                                GL11.glColor4f((float)red, (float)green, (float)blue, (float)contact.brightness);
                            } else {
                                GL11.glColor3f((float)(red * contact.brightness), (float)(green * contact.brightness), (float)(blue * contact.brightness));
                            }
                            GLUtils.disp(this.armorImageRef[contact.armorValue + 1][guiScale]);
                            this.applyFilteringParameters();
                            GLUtils.drawPre();
                            GLUtils.setMap(x, (float)y2 + armorOffset, 20);
                            GLUtils.drawPost();
                            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                            GLUtils.disp(this.armorImageRef[3][guiScale]);
                            this.applyFilteringParameters();
                            GLUtils.drawPre();
                            GLUtils.setMap(x, (float)y2 + armorOffset, 20);
                            GLUtils.drawPost();
                        }
                    } else if (contact.name.equals("MamiyaOtaru")) {
                        GLUtils.disp(this.crownRef);
                        this.applyFilteringParameters();
                        GLUtils.drawPre();
                        GLUtils.setMap(x, y2, 16);
                        GLUtils.drawPost();
                    }
                } else if (contact.name.equals("MamiyaOtaru")) {
                    GLUtils.disp(this.crownRef);
                    this.applyFilteringParameters();
                    GLUtils.drawPre();
                    GLUtils.setMap(x, y2, 16);
                    GLUtils.drawPost();
                }
                if (!this.options.showPlayerNames || contact.type != EnumMobs.PLAYER) continue;
                float scaleFactor = (float)this.layoutVariables.scScale / this.options.fontScale;
                GL11.glScalef((float)(1.0f / scaleFactor), (float)(1.0f / scaleFactor), (float)1.0f);
                String name = ((bld)contact.entity).bH().getName();
                int m = this.chkLen(name) / 2;
                this.write(name, (int)((float)x * scaleFactor) - m, (int)((float)(y2 + 3) * scaleFactor), 0xFFFFFF);
                continue;
            }
            catch (Exception localException) {
                System.err.println("Error rendering mob icon! " + localException.getLocalizedMessage() + " contact type " + (Object)((Object)contact.type));
                continue;
            }
            finally {
                GL11.glPopMatrix();
            }
        }
    }

    private void applyFilteringParameters() {
        if (this.options.filtering) {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10242, (int)10496);
            GL11.glTexParameteri((int)3553, (int)10243, (int)10496);
        } else {
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        }
    }

    private boolean isHostile(qn entity) {
        if (entity instanceof wt) {
            return ((wt)entity).bR() != null;
        }
        if (entity instanceof ws) {
            return true;
        }
        if (entity instanceof wn) {
            return true;
        }
        if (entity instanceof vi) {
            return true;
        }
        if (entity instanceof vh) {
            return ((vh)entity).cg();
        }
        return entity.getClass().getSimpleName().equals("EntityTFHydraHead");
    }

    private boolean isPlayer(qn entity) {
        return entity instanceof bld;
    }

    private boolean isNeutral(qn entity) {
        if (entity instanceof ri) {
            return !(entity instanceof xl) && !this.isHostile(entity);
        }
        return false;
    }
}

